package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ShaLink}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableShaLink.builder()}.
 */
@Generated(from = "ShaLink", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableShaLink implements ShaLink {
  private final @Nullable String sha;
  private final @Nullable URI url;

  private ImmutableShaLink(@Nullable String sha, @Nullable URI url) {
    this.sha = sha;
    this.url = url;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShaLink#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableShaLink withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableShaLink(value, this.url);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShaLink#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableShaLink withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableShaLink(this.sha, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableShaLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableShaLink
        && equalTo(0, (ImmutableShaLink) another);
  }

  private boolean equalTo(int synthetic, ImmutableShaLink another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    return h;
  }

  /**
   * Prints the immutable value {@code ShaLink} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ShaLink{"
        + "sha=" + sha
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ShaLink", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ShaLink {
    @Nullable String sha;
    @Nullable URI url;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableShaLink fromJson(Json json) {
    ImmutableShaLink.Builder builder = ImmutableShaLink.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ShaLink} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ShaLink instance
   */
  public static ImmutableShaLink copyOf(ShaLink instance) {
    if (instance instanceof ImmutableShaLink) {
      return (ImmutableShaLink) instance;
    }
    return ImmutableShaLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableShaLink ImmutableShaLink}.
   * <pre>
   * ImmutableShaLink.builder()
   *    .sha(String | null) // nullable {@link ShaLink#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link ShaLink#url() url}
   *    .build();
   * </pre>
   * @return A new ImmutableShaLink builder
   */
  public static ImmutableShaLink.Builder builder() {
    return new ImmutableShaLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableShaLink ImmutableShaLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ShaLink", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ShaLink} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String shaValue = instance.sha();
      if (shaValue != null) {
        sha(shaValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ShaLink#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link ShaLink#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Builds a new {@link ImmutableShaLink ImmutableShaLink}.
     * @return An immutable instance of ShaLink
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableShaLink build() {
      return new ImmutableShaLink(sha, url);
    }
  }
}
