package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TreeItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTreeItem.builder()}.
 */
@Generated(from = "TreeItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTreeItem implements TreeItem {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable String path;
  private final @Nullable String mode;
  private final @Nullable String type;
  private final @Nullable Long size;

  private ImmutableTreeItem(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable String path,
      @Nullable String mode,
      @Nullable String type,
      @Nullable Long size) {
    this.sha = sha;
    this.url = url;
    this.path = path;
    this.mode = mode;
    this.type = type;
    this.size = size;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *The file referenced in the tree. 
   */
  @JsonProperty
  @Override
  public @Nullable String path() {
    return path;
  }

  /**
   * The file mode; one of 100644 for file (blob), 100755 for executable (blob), 040000 for
   * subdirectory (tree), 160000 for submodule (commit), or 120000 for a blob that specifies the
   * path of a symlink.
   */
  @JsonProperty
  @Override
  public @Nullable String mode() {
    return mode;
  }

  /**
   *Either blob, tree, or commit. 
   */
  @JsonProperty
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   *File size in bytes. 
   */
  @JsonProperty
  @Override
  public @Nullable Long size() {
    return size;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItem#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItem withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableTreeItem(value, this.url, this.path, this.mode, this.type, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItem#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItem withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableTreeItem(this.sha, value, this.path, this.mode, this.type, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItem#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItem withPath(@Nullable String value) {
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableTreeItem(this.sha, this.url, value, this.mode, this.type, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItem#mode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItem withMode(@Nullable String value) {
    if (Objects.equals(this.mode, value)) return this;
    return new ImmutableTreeItem(this.sha, this.url, this.path, value, this.type, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItem#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItem withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableTreeItem(this.sha, this.url, this.path, this.mode, value, this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItem#size() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItem withSize(@Nullable Long value) {
    if (Objects.equals(this.size, value)) return this;
    return new ImmutableTreeItem(this.sha, this.url, this.path, this.mode, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTreeItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTreeItem
        && equalTo(0, (ImmutableTreeItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableTreeItem another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(path, another.path)
        && Objects.equals(mode, another.mode)
        && Objects.equals(type, another.type)
        && Objects.equals(size, another.size);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code path}, {@code mode}, {@code type}, {@code size}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(mode);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(size);
    return h;
  }

  /**
   * Prints the immutable value {@code TreeItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TreeItem{"
        + "sha=" + sha
        + ", url=" + url
        + ", path=" + path
        + ", mode=" + mode
        + ", type=" + type
        + ", size=" + size
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TreeItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TreeItem {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable String path;
    @Nullable String mode;
    @Nullable String type;
    @Nullable Long size;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty
    public void setMode(@Nullable String mode) {
      this.mode = mode;
    }
    @JsonProperty
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty
    public void setSize(@Nullable Long size) {
      this.size = size;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String path() { throw new UnsupportedOperationException(); }
    @Override
    public String mode() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public Long size() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTreeItem fromJson(Json json) {
    ImmutableTreeItem.Builder builder = ImmutableTreeItem.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.mode != null) {
      builder.mode(json.mode);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TreeItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TreeItem instance
   */
  public static ImmutableTreeItem copyOf(TreeItem instance) {
    if (instance instanceof ImmutableTreeItem) {
      return (ImmutableTreeItem) instance;
    }
    return ImmutableTreeItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTreeItem ImmutableTreeItem}.
   * <pre>
   * ImmutableTreeItem.builder()
   *    .sha(String | null) // nullable {@link TreeItem#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link TreeItem#url() url}
   *    .path(String | null) // nullable {@link TreeItem#path() path}
   *    .mode(String | null) // nullable {@link TreeItem#mode() mode}
   *    .type(String | null) // nullable {@link TreeItem#type() type}
   *    .size(Long | null) // nullable {@link TreeItem#size() size}
   *    .build();
   * </pre>
   * @return A new ImmutableTreeItem builder
   */
  public static ImmutableTreeItem.Builder builder() {
    return new ImmutableTreeItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTreeItem ImmutableTreeItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TreeItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable String path;
    private @Nullable String mode;
    private @Nullable String type;
    private @Nullable Long size;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.TreeItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TreeItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof TreeItem) {
        TreeItem instance = (TreeItem) object;
        @Nullable String modeValue = instance.mode();
        if (modeValue != null) {
          mode(modeValue);
        }
        @Nullable String pathValue = instance.path();
        if (pathValue != null) {
          path(pathValue);
        }
        @Nullable Long sizeValue = instance.size();
        if (sizeValue != null) {
          size(sizeValue);
        }
        @Nullable String typeValue = instance.type();
        if (typeValue != null) {
          type(typeValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String shaValue = instance.sha();
          if (shaValue != null) {
            sha(shaValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable URI urlValue = instance.url();
          if (urlValue != null) {
            url(urlValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link TreeItem#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItem#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItem#path() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItem#mode() mode} attribute.
     * @param mode The value for mode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mode(@Nullable String mode) {
      this.mode = mode;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItem#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItem#size() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder size(@Nullable Long size) {
      this.size = size;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTreeItem ImmutableTreeItem}.
     * @return An immutable instance of TreeItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTreeItem build() {
      return new ImmutableTreeItem(sha, url, path, mode, type, size);
    }
  }
}
