package com.spotify.github.v3.issues.changes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Body}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBody.builder()}.
 */
@Generated(from = "Body", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBody implements Body {
  private final @Nullable String from;

  private ImmutableBody(@Nullable String from) {
    this.from = from;
  }

  /**
   * The previous version of the body if the issue comment was edited.
   * @return The previous version of the body if the issue comment was edited.
   */
  @JsonProperty
  @Override
  public @Nullable String from() {
    return from;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Body#from() from} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for from (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBody withFrom(@Nullable String value) {
    if (Objects.equals(this.from, value)) return this;
    return new ImmutableBody(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBody} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBody
        && equalTo(0, (ImmutableBody) another);
  }

  private boolean equalTo(int synthetic, ImmutableBody another) {
    return Objects.equals(from, another.from);
  }

  /**
   * Computes a hash code from attributes: {@code from}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(from);
    return h;
  }

  /**
   * Prints the immutable value {@code Body} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Body{"
        + "from=" + from
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Body", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Body {
    @Nullable String from;
    @JsonProperty
    public void setFrom(@Nullable String from) {
      this.from = from;
    }
    @Override
    public String from() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBody fromJson(Json json) {
    ImmutableBody.Builder builder = ImmutableBody.builder();
    if (json.from != null) {
      builder.from(json.from);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Body} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Body instance
   */
  public static ImmutableBody copyOf(Body instance) {
    if (instance instanceof ImmutableBody) {
      return (ImmutableBody) instance;
    }
    return ImmutableBody.builder()
        .from(instance.from())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBody ImmutableBody}.
   * <pre>
   * ImmutableBody.builder()
   *    .from(String | null) // nullable {@link Body#from() from}
   *    .build();
   * </pre>
   * @return A new ImmutableBody builder
   */
  public static ImmutableBody.Builder builder() {
    return new ImmutableBody.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBody ImmutableBody}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Body", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String from;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link Body#from() from} attribute.
     * @param from The value for from (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder from(@Nullable String from) {
      this.from = from;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBody ImmutableBody}.
     * @return An immutable instance of Body
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBody build() {
      return new ImmutableBody(from);
    }
  }
}
