package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MembershipCreate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMembershipCreate.builder()}.
 */
@Generated(from = "MembershipCreate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMembershipCreate implements MembershipCreate {
  private final @Nullable String role;

  private ImmutableMembershipCreate(@Nullable String role) {
    this.role = role;
  }

  /**
   * The role that this user should have in the team.
   * Defaults to 'member'
   */
  @JsonProperty
  @Override
  public @Nullable String role() {
    return role;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MembershipCreate#role() role} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMembershipCreate withRole(@Nullable String value) {
    if (Objects.equals(this.role, value)) return this;
    return new ImmutableMembershipCreate(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMembershipCreate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMembershipCreate
        && equalTo(0, (ImmutableMembershipCreate) another);
  }

  private boolean equalTo(int synthetic, ImmutableMembershipCreate another) {
    return Objects.equals(role, another.role);
  }

  /**
   * Computes a hash code from attributes: {@code role}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(role);
    return h;
  }

  /**
   * Prints the immutable value {@code MembershipCreate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MembershipCreate{"
        + "role=" + role
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MembershipCreate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MembershipCreate {
    @Nullable String role;
    @JsonProperty
    public void setRole(@Nullable String role) {
      this.role = role;
    }
    @Override
    public String role() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMembershipCreate fromJson(Json json) {
    ImmutableMembershipCreate.Builder builder = ImmutableMembershipCreate.builder();
    if (json.role != null) {
      builder.role(json.role);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MembershipCreate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MembershipCreate instance
   */
  public static ImmutableMembershipCreate copyOf(MembershipCreate instance) {
    if (instance instanceof ImmutableMembershipCreate) {
      return (ImmutableMembershipCreate) instance;
    }
    return ImmutableMembershipCreate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMembershipCreate ImmutableMembershipCreate}.
   * <pre>
   * ImmutableMembershipCreate.builder()
   *    .role(String | null) // nullable {@link MembershipCreate#role() role}
   *    .build();
   * </pre>
   * @return A new ImmutableMembershipCreate builder
   */
  public static ImmutableMembershipCreate.Builder builder() {
    return new ImmutableMembershipCreate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMembershipCreate ImmutableMembershipCreate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MembershipCreate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String role;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MembershipCreate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MembershipCreate instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String roleValue = instance.role();
      if (roleValue != null) {
        role(roleValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MembershipCreate#role() role} attribute.
     * @param role The value for role (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder role(@Nullable String role) {
      this.role = role;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMembershipCreate ImmutableMembershipCreate}.
     * @return An immutable instance of MembershipCreate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMembershipCreate build() {
      return new ImmutableMembershipCreate(role);
    }
  }
}
