package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TeamUpdate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTeamUpdate.builder()}.
 */
@Generated(from = "TeamUpdate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTeamUpdate implements TeamUpdate {
  private final @Nullable String name;
  private final @Nullable String description;
  private final @Nullable String privacy;
  private final @Nullable String notificationSetting;
  private final @Nullable Integer parentTeamId;

  private ImmutableTeamUpdate(
      @Nullable String name,
      @Nullable String description,
      @Nullable String privacy,
      @Nullable String notificationSetting,
      @Nullable Integer parentTeamId) {
    this.name = name;
    this.description = description;
    this.privacy = privacy;
    this.notificationSetting = notificationSetting;
    this.parentTeamId = parentTeamId;
  }

  /**
   *The name of the team. 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *The description of the team. 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * The level of privacy this team should have.
   * For a non-nested team:
   * secret - only visible to organization owners and members of this team.
   * closed - visible to all members of this organization.
   * Default: secret
   * For a parent or child team:
   * closed - visible to all members of this organization.
   * Default for child team: closed
   * Can be one of: secret, closed
   */
  @JsonProperty
  @Override
  public Optional<String> privacy() {
    return Optional.ofNullable(privacy);
  }

  /**
   * The notification setting the team has chosen. The options are:
   * notifications_enabled - team members receive notifications when the team is @mentioned.
   * notifications_disabled - no one receives notifications.
   * Default: notifications_enabled
   * Can be one of: notifications_enabled, notifications_disabled
   */
  @JsonProperty("notification_setting")
  @Override
  public Optional<String> notificationSetting() {
    return Optional.ofNullable(notificationSetting);
  }

  /**
   *The ID of a team to set as the parent team. 
   */
  @JsonProperty("parent_team_id")
  @Override
  public Optional<Integer> parentTeamId() {
    return Optional.ofNullable(parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TeamUpdate#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeamUpdate withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableTeamUpdate(value, this.description, this.privacy, this.notificationSetting, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamUpdate#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableTeamUpdate(this.name, newValue, this.privacy, this.notificationSetting, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamUpdate#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableTeamUpdate(this.name, value, this.privacy, this.notificationSetting, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamUpdate#privacy() privacy} attribute.
   * @param value The value for privacy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withPrivacy(String value) {
    String newValue = Objects.requireNonNull(value, "privacy");
    if (Objects.equals(this.privacy, newValue)) return this;
    return new ImmutableTeamUpdate(this.name, this.description, newValue, this.notificationSetting, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamUpdate#privacy() privacy} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privacy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withPrivacy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.privacy, value)) return this;
    return new ImmutableTeamUpdate(this.name, this.description, value, this.notificationSetting, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamUpdate#notificationSetting() notificationSetting} attribute.
   * @param value The value for notificationSetting
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withNotificationSetting(String value) {
    String newValue = Objects.requireNonNull(value, "notificationSetting");
    if (Objects.equals(this.notificationSetting, newValue)) return this;
    return new ImmutableTeamUpdate(this.name, this.description, this.privacy, newValue, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamUpdate#notificationSetting() notificationSetting} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notificationSetting
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withNotificationSetting(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.notificationSetting, value)) return this;
    return new ImmutableTeamUpdate(this.name, this.description, this.privacy, value, this.parentTeamId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TeamUpdate#parentTeamId() parentTeamId} attribute.
   * @param value The value for parentTeamId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withParentTeamId(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.parentTeamId, newValue)) return this;
    return new ImmutableTeamUpdate(this.name, this.description, this.privacy, this.notificationSetting, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TeamUpdate#parentTeamId() parentTeamId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parentTeamId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeamUpdate withParentTeamId(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.parentTeamId, value)) return this;
    return new ImmutableTeamUpdate(this.name, this.description, this.privacy, this.notificationSetting, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTeamUpdate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTeamUpdate
        && equalTo(0, (ImmutableTeamUpdate) another);
  }

  private boolean equalTo(int synthetic, ImmutableTeamUpdate another) {
    return Objects.equals(name, another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(privacy, another.privacy)
        && Objects.equals(notificationSetting, another.notificationSetting)
        && Objects.equals(parentTeamId, another.parentTeamId);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code privacy}, {@code notificationSetting}, {@code parentTeamId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(privacy);
    h += (h << 5) + Objects.hashCode(notificationSetting);
    h += (h << 5) + Objects.hashCode(parentTeamId);
    return h;
  }

  /**
   * Prints the immutable value {@code TeamUpdate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("TeamUpdate{");
    if (name != null) {
      builder.append("name=").append(name);
    }
    if (description != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("description=").append(description);
    }
    if (privacy != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("privacy=").append(privacy);
    }
    if (notificationSetting != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("notificationSetting=").append(notificationSetting);
    }
    if (parentTeamId != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("parentTeamId=").append(parentTeamId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TeamUpdate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TeamUpdate {
    @Nullable String name;
    @Nullable Optional<String> description = Optional.empty();
    @Nullable Optional<String> privacy = Optional.empty();
    @Nullable Optional<String> notificationSetting = Optional.empty();
    @Nullable Optional<Integer> parentTeamId = Optional.empty();
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setPrivacy(Optional<String> privacy) {
      this.privacy = privacy;
    }
    @JsonProperty("notification_setting")
    public void setNotificationSetting(Optional<String> notificationSetting) {
      this.notificationSetting = notificationSetting;
    }
    @JsonProperty("parent_team_id")
    public void setParentTeamId(Optional<Integer> parentTeamId) {
      this.parentTeamId = parentTeamId;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> privacy() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> notificationSetting() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> parentTeamId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTeamUpdate fromJson(Json json) {
    ImmutableTeamUpdate.Builder builder = ImmutableTeamUpdate.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.privacy != null) {
      builder.privacy(json.privacy);
    }
    if (json.notificationSetting != null) {
      builder.notificationSetting(json.notificationSetting);
    }
    if (json.parentTeamId != null) {
      builder.parentTeamId(json.parentTeamId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TeamUpdate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TeamUpdate instance
   */
  public static ImmutableTeamUpdate copyOf(TeamUpdate instance) {
    if (instance instanceof ImmutableTeamUpdate) {
      return (ImmutableTeamUpdate) instance;
    }
    return ImmutableTeamUpdate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTeamUpdate ImmutableTeamUpdate}.
   * <pre>
   * ImmutableTeamUpdate.builder()
   *    .name(String | null) // nullable {@link TeamUpdate#name() name}
   *    .description(String) // optional {@link TeamUpdate#description() description}
   *    .privacy(String) // optional {@link TeamUpdate#privacy() privacy}
   *    .notificationSetting(String) // optional {@link TeamUpdate#notificationSetting() notificationSetting}
   *    .parentTeamId(Integer) // optional {@link TeamUpdate#parentTeamId() parentTeamId}
   *    .build();
   * </pre>
   * @return A new ImmutableTeamUpdate builder
   */
  public static ImmutableTeamUpdate.Builder builder() {
    return new ImmutableTeamUpdate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTeamUpdate ImmutableTeamUpdate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TeamUpdate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String privacy;
    private @Nullable String notificationSetting;
    private @Nullable Integer parentTeamId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TeamUpdate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TeamUpdate instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      Optional<String> privacyOptional = instance.privacy();
      if (privacyOptional.isPresent()) {
        privacy(privacyOptional);
      }
      Optional<String> notificationSettingOptional = instance.notificationSetting();
      if (notificationSettingOptional.isPresent()) {
        notificationSetting(notificationSettingOptional);
      }
      Optional<Integer> parentTeamIdOptional = instance.parentTeamId();
      if (parentTeamIdOptional.isPresent()) {
        parentTeamId(parentTeamIdOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TeamUpdate#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#privacy() privacy} to privacy.
     * @param privacy The value for privacy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privacy(String privacy) {
      this.privacy = Objects.requireNonNull(privacy, "privacy");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#privacy() privacy} to privacy.
     * @param privacy The value for privacy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder privacy(Optional<String> privacy) {
      this.privacy = privacy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#notificationSetting() notificationSetting} to notificationSetting.
     * @param notificationSetting The value for notificationSetting
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder notificationSetting(String notificationSetting) {
      this.notificationSetting = Objects.requireNonNull(notificationSetting, "notificationSetting");
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#notificationSetting() notificationSetting} to notificationSetting.
     * @param notificationSetting The value for notificationSetting
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("notification_setting")
    public final Builder notificationSetting(Optional<String> notificationSetting) {
      this.notificationSetting = notificationSetting.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#parentTeamId() parentTeamId} to parentTeamId.
     * @param parentTeamId The value for parentTeamId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parentTeamId(int parentTeamId) {
      this.parentTeamId = parentTeamId;
      return this;
    }

    /**
     * Initializes the optional value {@link TeamUpdate#parentTeamId() parentTeamId} to parentTeamId.
     * @param parentTeamId The value for parentTeamId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parent_team_id")
    public final Builder parentTeamId(Optional<Integer> parentTeamId) {
      this.parentTeamId = parentTeamId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTeamUpdate ImmutableTeamUpdate}.
     * @return An immutable instance of TeamUpdate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTeamUpdate build() {
      return new ImmutableTeamUpdate(name, description, privacy, notificationSetting, parentTeamId);
    }
  }
}
