package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestRef.builder()}.
 */
@Generated(from = "PullRequestRef", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestRef implements PullRequestRef {
  private final @Nullable String label;
  private final @Nullable String ref;
  private final @Nullable String sha;
  private final @Nullable User user;
  private final @Nullable Repository repo;

  private ImmutablePullRequestRef(
      @Nullable String label,
      @Nullable String ref,
      @Nullable String sha,
      @Nullable User user,
      @Nullable Repository repo) {
    this.label = label;
    this.ref = ref;
    this.sha = sha;
    this.user = user;
    this.repo = repo;
  }

  /**
   *Label 
   */
  @JsonProperty
  @Override
  public Optional<String> label() {
    return Optional.ofNullable(label);
  }

  /**
   *Reference 
   */
  @JsonProperty
  @Override
  public @Nullable String ref() {
    return ref;
  }

  /**
   *SHA 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *User 
   */
  @JsonProperty
  @Override
  public Optional<User> user() {
    return Optional.ofNullable(user);
  }

  /**
   *Repository 
   */
  @JsonProperty
  @Override
  public Optional<Repository> repo() {
    return Optional.ofNullable(repo);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestRef#label() label} attribute.
   * @param value The value for label
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestRef withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (Objects.equals(this.label, newValue)) return this;
    return new ImmutablePullRequestRef(newValue, this.ref, this.sha, this.user, this.repo);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestRef#label() label} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for label
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestRef withLabel(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.label, value)) return this;
    return new ImmutablePullRequestRef(value, this.ref, this.sha, this.user, this.repo);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestRef#ref() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestRef withRef(@Nullable String value) {
    if (Objects.equals(this.ref, value)) return this;
    return new ImmutablePullRequestRef(this.label, value, this.sha, this.user, this.repo);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestRef#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestRef withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutablePullRequestRef(this.label, this.ref, value, this.user, this.repo);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestRef#user() user} attribute.
   * @param value The value for user
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestRef withUser(User value) {
    User newValue = Objects.requireNonNull(value, "user");
    if (this.user == newValue) return this;
    return new ImmutablePullRequestRef(this.label, this.ref, this.sha, newValue, this.repo);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestRef#user() user} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for user
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestRef withUser(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.user == value) return this;
    return new ImmutablePullRequestRef(this.label, this.ref, this.sha, value, this.repo);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestRef#repo() repo} attribute.
   * @param value The value for repo
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestRef withRepo(Repository value) {
    Repository newValue = Objects.requireNonNull(value, "repo");
    if (this.repo == newValue) return this;
    return new ImmutablePullRequestRef(this.label, this.ref, this.sha, this.user, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestRef#repo() repo} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for repo
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestRef withRepo(Optional<? extends Repository> optional) {
    @Nullable Repository value = optional.orElse(null);
    if (this.repo == value) return this;
    return new ImmutablePullRequestRef(this.label, this.ref, this.sha, this.user, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestRef
        && equalTo(0, (ImmutablePullRequestRef) another);
  }

  private boolean equalTo(int synthetic, ImmutablePullRequestRef another) {
    return Objects.equals(label, another.label)
        && Objects.equals(ref, another.ref)
        && Objects.equals(sha, another.sha)
        && Objects.equals(user, another.user)
        && Objects.equals(repo, another.repo);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code ref}, {@code sha}, {@code user}, {@code repo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(ref);
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(repo);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PullRequestRef{");
    if (label != null) {
      builder.append("label=").append(label);
    }
    if (ref != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("ref=").append(ref);
    }
    if (sha != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("sha=").append(sha);
    }
    if (user != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("user=").append(user);
    }
    if (repo != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("repo=").append(repo);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestRef", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestRef {
    @Nullable Optional<String> label = Optional.empty();
    @Nullable String ref;
    @Nullable String sha;
    @Nullable Optional<User> user = Optional.empty();
    @Nullable Optional<Repository> repo = Optional.empty();
    @JsonProperty
    public void setLabel(Optional<String> label) {
      this.label = label;
    }
    @JsonProperty
    public void setRef(@Nullable String ref) {
      this.ref = ref;
    }
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUser(Optional<User> user) {
      this.user = user;
    }
    @JsonProperty
    public void setRepo(Optional<Repository> repo) {
      this.repo = repo;
    }
    @Override
    public Optional<String> label() { throw new UnsupportedOperationException(); }
    @Override
    public String ref() { throw new UnsupportedOperationException(); }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> user() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Repository> repo() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestRef fromJson(Json json) {
    ImmutablePullRequestRef.Builder builder = ImmutablePullRequestRef.builder();
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.ref != null) {
      builder.ref(json.ref);
    }
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.repo != null) {
      builder.repo(json.repo);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestRef instance
   */
  public static ImmutablePullRequestRef copyOf(PullRequestRef instance) {
    if (instance instanceof ImmutablePullRequestRef) {
      return (ImmutablePullRequestRef) instance;
    }
    return ImmutablePullRequestRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestRef ImmutablePullRequestRef}.
   * <pre>
   * ImmutablePullRequestRef.builder()
   *    .label(String) // optional {@link PullRequestRef#label() label}
   *    .ref(String | null) // nullable {@link PullRequestRef#ref() ref}
   *    .sha(String | null) // nullable {@link PullRequestRef#sha() sha}
   *    .user(com.spotify.github.v3.User) // optional {@link PullRequestRef#user() user}
   *    .repo(com.spotify.github.v3.repos.Repository) // optional {@link PullRequestRef#repo() repo}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestRef builder
   */
  public static ImmutablePullRequestRef.Builder builder() {
    return new ImmutablePullRequestRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestRef ImmutablePullRequestRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String label;
    private @Nullable String ref;
    private @Nullable String sha;
    private @Nullable User user;
    private @Nullable Repository repo;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PullRequestRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestRef instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> labelOptional = instance.label();
      if (labelOptional.isPresent()) {
        label(labelOptional);
      }
      @Nullable String refValue = instance.ref();
      if (refValue != null) {
        ref(refValue);
      }
      @Nullable String shaValue = instance.sha();
      if (shaValue != null) {
        sha(shaValue);
      }
      Optional<User> userOptional = instance.user();
      if (userOptional.isPresent()) {
        user(userOptional);
      }
      Optional<Repository> repoOptional = instance.repo();
      if (repoOptional.isPresent()) {
        repo(repoOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestRef#label() label} to label.
     * @param label The value for label
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestRef#label() label} to label.
     * @param label The value for label
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder label(Optional<String> label) {
      this.label = label.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestRef#ref() ref} attribute.
     * @param ref The value for ref (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder ref(@Nullable String ref) {
      this.ref = ref;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestRef#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestRef#user() user} to user.
     * @param user The value for user
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder user(User user) {
      this.user = Objects.requireNonNull(user, "user");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestRef#user() user} to user.
     * @param user The value for user
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(Optional<? extends User> user) {
      this.user = user.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestRef#repo() repo} to repo.
     * @param repo The value for repo
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repository repo) {
      this.repo = Objects.requireNonNull(repo, "repo");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestRef#repo() repo} to repo.
     * @param repo The value for repo
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repo(Optional<? extends Repository> repo) {
      this.repo = repo.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestRef ImmutablePullRequestRef}.
     * @return An immutable instance of PullRequestRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestRef build() {
      return new ImmutablePullRequestRef(label, ref, sha, user, repo);
    }
  }
}
