package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReviewParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReviewParameters.builder()}.
 */
@Generated(from = "ReviewParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReviewParameters extends ReviewParameters {
  private final @Nullable String commitId;
  private final @Nullable String body;
  private final String event;
  private final List<ReviewComment> comments;

  private ImmutableReviewParameters(
      @Nullable String commitId,
      @Nullable String body,
      String event,
      List<ReviewComment> comments) {
    this.commitId = commitId;
    this.body = body;
    this.event = event;
    this.comments = comments;
  }

  /**
   * SHA of the commit that needs a review. If not the latest, the review may be outdated.
   * Defaults to the most recent commit in the PR when you do not specify a value.
   * @return the optional commitId.
   */
  @JsonProperty
  @Override
  public Optional<String> commitId() {
    return Optional.ofNullable(commitId);
  }

  /**
   * **required** when using REQUEST_CHANGES or COMMENT for the event.
   * @return the optional body for REQUEST_CHANGES or COMMENT events.
   */
  @JsonProperty
  @Override
  public Optional<String> body() {
    return Optional.ofNullable(body);
  }

  /**
   * Review action you want to perform. Should be one of: APPROVE, REQUEST_CHANGES or COMMENT.
   * @return the review action to perform.
   */
  @JsonProperty
  @Override
  public String event() {
    return event;
  }

  /**
   * List of comments for a non-approve review.
   * @return the list of comments for the review.
   */
  @JsonProperty
  @Override
  public List<ReviewComment> comments() {
    return comments;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ReviewParameters#commitId() commitId} attribute.
   * @param value The value for commitId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewParameters withCommitId(String value) {
    String newValue = Objects.requireNonNull(value, "commitId");
    if (Objects.equals(this.commitId, newValue)) return this;
    return new ImmutableReviewParameters(newValue, this.body, this.event, this.comments);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ReviewParameters#commitId() commitId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for commitId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewParameters withCommitId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.commitId, value)) return this;
    return new ImmutableReviewParameters(value, this.body, this.event, this.comments);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ReviewParameters#body() body} attribute.
   * @param value The value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewParameters withBody(String value) {
    String newValue = Objects.requireNonNull(value, "body");
    if (Objects.equals(this.body, newValue)) return this;
    return new ImmutableReviewParameters(this.commitId, newValue, this.event, this.comments);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ReviewParameters#body() body} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewParameters withBody(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.body, value)) return this;
    return new ImmutableReviewParameters(this.commitId, value, this.event, this.comments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewParameters#event() event} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReviewParameters withEvent(String value) {
    String newValue = Objects.requireNonNull(value, "event");
    if (this.event.equals(newValue)) return this;
    return new ImmutableReviewParameters(this.commitId, this.body, newValue, this.comments);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReviewParameters#comments() comments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewParameters withComments(ReviewComment... elements) {
    List<ReviewComment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableReviewParameters(this.commitId, this.body, this.event, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReviewParameters#comments() comments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of comments elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReviewParameters withComments(Iterable<? extends ReviewComment> elements) {
    if (this.comments == elements) return this;
    List<ReviewComment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableReviewParameters(this.commitId, this.body, this.event, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReviewParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReviewParameters
        && equalTo(0, (ImmutableReviewParameters) another);
  }

  private boolean equalTo(int synthetic, ImmutableReviewParameters another) {
    return Objects.equals(commitId, another.commitId)
        && Objects.equals(body, another.body)
        && event.equals(another.event)
        && comments.equals(another.comments);
  }

  /**
   * Computes a hash code from attributes: {@code commitId}, {@code body}, {@code event}, {@code comments}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(commitId);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + event.hashCode();
    h += (h << 5) + comments.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReviewParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ReviewParameters{");
    if (commitId != null) {
      builder.append("commitId=").append(commitId);
    }
    if (body != null) {
      if (builder.length() > 17) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (builder.length() > 17) builder.append(", ");
    builder.append("event=").append(event);
    builder.append(", ");
    builder.append("comments=").append(comments);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReviewParameters", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ReviewParameters {
    @Nullable Optional<String> commitId = Optional.empty();
    @Nullable Optional<String> body = Optional.empty();
    @Nullable String event;
    @Nullable List<ReviewComment> comments = Collections.emptyList();
    @JsonProperty
    public void setCommitId(Optional<String> commitId) {
      this.commitId = commitId;
    }
    @JsonProperty
    public void setBody(Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setEvent(String event) {
      this.event = event;
    }
    @JsonProperty
    public void setComments(List<ReviewComment> comments) {
      this.comments = comments;
    }
    @Override
    public Optional<String> commitId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public String event() { throw new UnsupportedOperationException(); }
    @Override
    public List<ReviewComment> comments() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReviewParameters fromJson(Json json) {
    ImmutableReviewParameters.Builder builder = ImmutableReviewParameters.builder();
    if (json.commitId != null) {
      builder.commitId(json.commitId);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.event != null) {
      builder.event(json.event);
    }
    if (json.comments != null) {
      builder.addAllComments(json.comments);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReviewParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReviewParameters instance
   */
  public static ImmutableReviewParameters copyOf(ReviewParameters instance) {
    if (instance instanceof ImmutableReviewParameters) {
      return (ImmutableReviewParameters) instance;
    }
    return ImmutableReviewParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReviewParameters ImmutableReviewParameters}.
   * <pre>
   * ImmutableReviewParameters.builder()
   *    .commitId(String) // optional {@link ReviewParameters#commitId() commitId}
   *    .body(String) // optional {@link ReviewParameters#body() body}
   *    .event(String) // required {@link ReviewParameters#event() event}
   *    .addComments|addAllComments(com.spotify.github.v3.prs.ReviewComment) // {@link ReviewParameters#comments() comments} elements
   *    .build();
   * </pre>
   * @return A new ImmutableReviewParameters builder
   */
  public static ImmutableReviewParameters.Builder builder() {
    return new ImmutableReviewParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReviewParameters ImmutableReviewParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReviewParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EVENT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String commitId;
    private @Nullable String body;
    private @Nullable String event;
    private List<ReviewComment> comments = new ArrayList<ReviewComment>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReviewParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReviewParameters instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> commitIdOptional = instance.commitId();
      if (commitIdOptional.isPresent()) {
        commitId(commitIdOptional);
      }
      Optional<String> bodyOptional = instance.body();
      if (bodyOptional.isPresent()) {
        body(bodyOptional);
      }
      event(instance.event());
      addAllComments(instance.comments());
      return this;
    }

    /**
     * Initializes the optional value {@link ReviewParameters#commitId() commitId} to commitId.
     * @param commitId The value for commitId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitId(String commitId) {
      this.commitId = Objects.requireNonNull(commitId, "commitId");
      return this;
    }

    /**
     * Initializes the optional value {@link ReviewParameters#commitId() commitId} to commitId.
     * @param commitId The value for commitId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitId(Optional<String> commitId) {
      this.commitId = commitId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ReviewParameters#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link ReviewParameters#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(Optional<String> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewParameters#event() event} attribute.
     * @param event The value for event 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder event(String event) {
      this.event = Objects.requireNonNull(event, "event");
      initBits &= ~INIT_BIT_EVENT;
      return this;
    }

    /**
     * Adds one element to {@link ReviewParameters#comments() comments} list.
     * @param element A comments element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addComments(ReviewComment element) {
      this.comments.add(Objects.requireNonNull(element, "comments element"));
      return this;
    }

    /**
     * Adds elements to {@link ReviewParameters#comments() comments} list.
     * @param elements An array of comments elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addComments(ReviewComment... elements) {
      for (ReviewComment element : elements) {
        this.comments.add(Objects.requireNonNull(element, "comments element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ReviewParameters#comments() comments} list.
     * @param elements An iterable of comments elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comments(Iterable<? extends ReviewComment> elements) {
      this.comments.clear();
      return addAllComments(elements);
    }

    /**
     * Adds elements to {@link ReviewParameters#comments() comments} list.
     * @param elements An iterable of comments elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllComments(Iterable<? extends ReviewComment> elements) {
      for (ReviewComment element : elements) {
        this.comments.add(Objects.requireNonNull(element, "comments element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableReviewParameters ImmutableReviewParameters}.
     * @return An immutable instance of ReviewParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReviewParameters build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableReviewParameters(commitId, body, event, createUnmodifiableList(true, comments));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EVENT) != 0) attributes.add("event");
      return "Cannot build ReviewParameters, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
