package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AuthenticatedUserRepositoriesFilter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAuthenticatedUserRepositoriesFilter.builder()}.
 */
@Generated(from = "AuthenticatedUserRepositoriesFilter", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAuthenticatedUserRepositoriesFilter
    implements AuthenticatedUserRepositoriesFilter {
  private final @Nullable String visibility;
  private final @Nullable String affiliation;
  private final @Nullable String type;
  private final @Nullable String sort;
  private final @Nullable String direction;

  private ImmutableAuthenticatedUserRepositoriesFilter(
      @Nullable String visibility,
      @Nullable String affiliation,
      @Nullable String type,
      @Nullable String sort,
      @Nullable String direction) {
    this.visibility = visibility;
    this.affiliation = affiliation;
    this.type = type;
    this.sort = sort;
    this.direction = direction;
  }

  /**
   * Can be one of all, public, or private. Default: all
   */
  @JsonProperty
  @Override
  public @Nullable String visibility() {
    return visibility;
  }

  /**
   * Comma-separated list of values. Can include:
   * * owner: Repositories that are owned by the authenticated user.
   * * collaborator: Repositories that the user has been added to as a
   *   collaborator.
   * * organization_member: Repositories that the user has access to through
   *   being a member of an organization. This includes every repository on
   *   every team that the user is on.
   * Default: owner,collaborator,organization_member
   */
  @JsonProperty
  @Override
  public @Nullable String affiliation() {
    return affiliation;
  }

  /**
   * Can be one of all, owner, public, private, member. Default: all
   * Will cause a 422 error if used in the same request as visibility or
   * affiliation.
   */
  @JsonProperty
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * Can be one of created, updated, pushed, full_name. Default: full_name
   */
  @JsonProperty
  @Override
  public @Nullable String sort() {
    return sort;
  }

  /**
   * Can be one of asc or desc. Default: asc when using full_name, otherwise
   * desc
   * 
   */
  @JsonProperty
  @Override
  public @Nullable String direction() {
    return direction;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticatedUserRepositoriesFilter#visibility() visibility} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visibility (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticatedUserRepositoriesFilter withVisibility(@Nullable String value) {
    if (Objects.equals(this.visibility, value)) return this;
    return new ImmutableAuthenticatedUserRepositoriesFilter(value, this.affiliation, this.type, this.sort, this.direction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticatedUserRepositoriesFilter#affiliation() affiliation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for affiliation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticatedUserRepositoriesFilter withAffiliation(@Nullable String value) {
    if (Objects.equals(this.affiliation, value)) return this;
    return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, value, this.type, this.sort, this.direction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticatedUserRepositoriesFilter#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticatedUserRepositoriesFilter withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, value, this.sort, this.direction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticatedUserRepositoriesFilter#sort() sort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sort (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticatedUserRepositoriesFilter withSort(@Nullable String value) {
    if (Objects.equals(this.sort, value)) return this;
    return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, this.type, value, this.direction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticatedUserRepositoriesFilter#direction() direction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for direction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticatedUserRepositoriesFilter withDirection(@Nullable String value) {
    if (Objects.equals(this.direction, value)) return this;
    return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, this.type, this.sort, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAuthenticatedUserRepositoriesFilter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAuthenticatedUserRepositoriesFilter
        && equalTo(0, (ImmutableAuthenticatedUserRepositoriesFilter) another);
  }

  private boolean equalTo(int synthetic, ImmutableAuthenticatedUserRepositoriesFilter another) {
    return Objects.equals(visibility, another.visibility)
        && Objects.equals(affiliation, another.affiliation)
        && Objects.equals(type, another.type)
        && Objects.equals(sort, another.sort)
        && Objects.equals(direction, another.direction);
  }

  /**
   * Computes a hash code from attributes: {@code visibility}, {@code affiliation}, {@code type}, {@code sort}, {@code direction}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(visibility);
    h += (h << 5) + Objects.hashCode(affiliation);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(sort);
    h += (h << 5) + Objects.hashCode(direction);
    return h;
  }

  /**
   * Prints the immutable value {@code AuthenticatedUserRepositoriesFilter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthenticatedUserRepositoriesFilter{"
        + "visibility=" + visibility
        + ", affiliation=" + affiliation
        + ", type=" + type
        + ", sort=" + sort
        + ", direction=" + direction
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AuthenticatedUserRepositoriesFilter", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AuthenticatedUserRepositoriesFilter {
    @Nullable String visibility;
    @Nullable String affiliation;
    @Nullable String type;
    @Nullable String sort;
    @Nullable String direction;
    @JsonProperty
    public void setVisibility(@Nullable String visibility) {
      this.visibility = visibility;
    }
    @JsonProperty
    public void setAffiliation(@Nullable String affiliation) {
      this.affiliation = affiliation;
    }
    @JsonProperty
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty
    public void setSort(@Nullable String sort) {
      this.sort = sort;
    }
    @JsonProperty
    public void setDirection(@Nullable String direction) {
      this.direction = direction;
    }
    @Override
    public String visibility() { throw new UnsupportedOperationException(); }
    @Override
    public String affiliation() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public String sort() { throw new UnsupportedOperationException(); }
    @Override
    public String direction() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAuthenticatedUserRepositoriesFilter fromJson(Json json) {
    ImmutableAuthenticatedUserRepositoriesFilter.Builder builder = ImmutableAuthenticatedUserRepositoriesFilter.builder();
    if (json.visibility != null) {
      builder.visibility(json.visibility);
    }
    if (json.affiliation != null) {
      builder.affiliation(json.affiliation);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.sort != null) {
      builder.sort(json.sort);
    }
    if (json.direction != null) {
      builder.direction(json.direction);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AuthenticatedUserRepositoriesFilter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuthenticatedUserRepositoriesFilter instance
   */
  public static ImmutableAuthenticatedUserRepositoriesFilter copyOf(AuthenticatedUserRepositoriesFilter instance) {
    if (instance instanceof ImmutableAuthenticatedUserRepositoriesFilter) {
      return (ImmutableAuthenticatedUserRepositoriesFilter) instance;
    }
    return ImmutableAuthenticatedUserRepositoriesFilter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAuthenticatedUserRepositoriesFilter ImmutableAuthenticatedUserRepositoriesFilter}.
   * <pre>
   * ImmutableAuthenticatedUserRepositoriesFilter.builder()
   *    .visibility(String | null) // nullable {@link AuthenticatedUserRepositoriesFilter#visibility() visibility}
   *    .affiliation(String | null) // nullable {@link AuthenticatedUserRepositoriesFilter#affiliation() affiliation}
   *    .type(String | null) // nullable {@link AuthenticatedUserRepositoriesFilter#type() type}
   *    .sort(String | null) // nullable {@link AuthenticatedUserRepositoriesFilter#sort() sort}
   *    .direction(String | null) // nullable {@link AuthenticatedUserRepositoriesFilter#direction() direction}
   *    .build();
   * </pre>
   * @return A new ImmutableAuthenticatedUserRepositoriesFilter builder
   */
  public static ImmutableAuthenticatedUserRepositoriesFilter.Builder builder() {
    return new ImmutableAuthenticatedUserRepositoriesFilter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAuthenticatedUserRepositoriesFilter ImmutableAuthenticatedUserRepositoriesFilter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AuthenticatedUserRepositoriesFilter", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String visibility;
    private @Nullable String affiliation;
    private @Nullable String type;
    private @Nullable String sort;
    private @Nullable String direction;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthenticatedUserRepositoriesFilter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AuthenticatedUserRepositoriesFilter instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String visibilityValue = instance.visibility();
      if (visibilityValue != null) {
        visibility(visibilityValue);
      }
      @Nullable String affiliationValue = instance.affiliation();
      if (affiliationValue != null) {
        affiliation(affiliationValue);
      }
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String sortValue = instance.sort();
      if (sortValue != null) {
        sort(sortValue);
      }
      @Nullable String directionValue = instance.direction();
      if (directionValue != null) {
        direction(directionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticatedUserRepositoriesFilter#visibility() visibility} attribute.
     * @param visibility The value for visibility (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder visibility(@Nullable String visibility) {
      this.visibility = visibility;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticatedUserRepositoriesFilter#affiliation() affiliation} attribute.
     * @param affiliation The value for affiliation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder affiliation(@Nullable String affiliation) {
      this.affiliation = affiliation;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticatedUserRepositoriesFilter#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticatedUserRepositoriesFilter#sort() sort} attribute.
     * @param sort The value for sort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sort(@Nullable String sort) {
      this.sort = sort;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticatedUserRepositoriesFilter#direction() direction} attribute.
     * @param direction The value for direction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder direction(@Nullable String direction) {
      this.direction = direction;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAuthenticatedUserRepositoriesFilter ImmutableAuthenticatedUserRepositoriesFilter}.
     * @return An immutable instance of AuthenticatedUserRepositoriesFilter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAuthenticatedUserRepositoriesFilter build() {
      return new ImmutableAuthenticatedUserRepositoriesFilter(visibility, affiliation, type, sort, direction);
    }
  }
}
