/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.requests.RepositoryDispatch;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryDispatch", generator="Immutables")
@Immutable
public final class ImmutableRepositoryDispatch
implements RepositoryDispatch {
    private final String eventType;
    @Nullable
    private final JsonNode clientPayload;

    private ImmutableRepositoryDispatch(String eventType, @Nullable JsonNode clientPayload) {
        this.eventType = eventType;
        this.clientPayload = clientPayload;
    }

    @Override
    @JsonProperty
    public String eventType() {
        return this.eventType;
    }

    @Override
    @JsonProperty
    public Optional<JsonNode> clientPayload() {
        return Optional.ofNullable(this.clientPayload);
    }

    public final ImmutableRepositoryDispatch withEventType(String value) {
        String newValue = Objects.requireNonNull(value, "eventType");
        if (this.eventType.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryDispatch(newValue, this.clientPayload);
    }

    public final ImmutableRepositoryDispatch withClientPayload(JsonNode value) {
        JsonNode newValue = Objects.requireNonNull(value, "clientPayload");
        if (this.clientPayload == newValue) {
            return this;
        }
        return new ImmutableRepositoryDispatch(this.eventType, newValue);
    }

    public final ImmutableRepositoryDispatch withClientPayload(Optional<? extends JsonNode> optional) {
        JsonNode value = optional.orElse(null);
        if (this.clientPayload == value) {
            return this;
        }
        return new ImmutableRepositoryDispatch(this.eventType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryDispatch && this.equalTo(0, (ImmutableRepositoryDispatch)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryDispatch another) {
        return this.eventType.equals(another.eventType) && Objects.equals(this.clientPayload, another.clientPayload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.eventType.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientPayload);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RepositoryDispatch{");
        builder.append("eventType=").append(this.eventType);
        if (this.clientPayload != null) {
            builder.append(", ");
            builder.append("clientPayload=").append(this.clientPayload);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryDispatch fromJson(Json json) {
        Builder builder = ImmutableRepositoryDispatch.builder();
        if (json.eventType != null) {
            builder.eventType(json.eventType);
        }
        if (json.clientPayload != null) {
            builder.clientPayload(json.clientPayload);
        }
        return builder.build();
    }

    public static ImmutableRepositoryDispatch copyOf(RepositoryDispatch instance) {
        if (instance instanceof ImmutableRepositoryDispatch) {
            return (ImmutableRepositoryDispatch)instance;
        }
        return ImmutableRepositoryDispatch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryDispatch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EVENT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String eventType;
        @Nullable
        private JsonNode clientPayload;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryDispatch instance) {
            Objects.requireNonNull(instance, "instance");
            this.eventType(instance.eventType());
            Optional<JsonNode> clientPayloadOptional = instance.clientPayload();
            if (clientPayloadOptional.isPresent()) {
                this.clientPayload(clientPayloadOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder eventType(String eventType) {
            this.eventType = Objects.requireNonNull(eventType, "eventType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientPayload(JsonNode clientPayload) {
            this.clientPayload = Objects.requireNonNull(clientPayload, "clientPayload");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder clientPayload(Optional<? extends JsonNode> clientPayload) {
            this.clientPayload = clientPayload.orElse(null);
            return this;
        }

        public ImmutableRepositoryDispatch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepositoryDispatch(this.eventType, this.clientPayload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventType");
            }
            return "Cannot build RepositoryDispatch, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryDispatch", generator="Immutables")
    static final class Json
    implements RepositoryDispatch {
        @Nullable
        String eventType;
        @Nullable
        Optional<JsonNode> clientPayload = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @JsonProperty
        public void setClientPayload(Optional<JsonNode> clientPayload) {
            this.clientPayload = clientPayload;
        }

        @Override
        public String eventType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<JsonNode> clientPayload() {
            throw new UnsupportedOperationException();
        }
    }
}

