/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.requests.RepositoryUpdate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryUpdate", generator="Immutables")
@Immutable
public final class ImmutableRepositoryUpdate
implements RepositoryUpdate {
    @Nullable
    private final String description;
    @Nullable
    private final Boolean allowAutoMerge;
    @Nullable
    private final Boolean allowForking;
    @Nullable
    private final Boolean allowSquashMerge;
    @Nullable
    private final Boolean allowMergeCommit;
    @Nullable
    private final Boolean allowRebaseMerge;
    @Nullable
    private final Boolean allowUpdateBranch;
    @Nullable
    private final String defaultBranch;
    @Nullable
    private final Boolean deleteBranchOnMerge;
    @Nullable
    private final String homepage;
    @Nullable
    private final Boolean hasDownloads;
    @Nullable
    private final Boolean hasIssues;
    @Nullable
    private final Boolean hasWiki;
    @Nullable
    private final Boolean hasPages;
    @Nullable
    private final Boolean hasProjects;
    @Nullable
    private final Boolean isArchived;
    @Nullable
    private final Boolean isPrivate;
    @Nullable
    private final Boolean isTemplate;
    @Nullable
    private final String squashMergeCommitMessage;
    @Nullable
    private final String squashMergeCommitTitle;
    @Nullable
    private final String mergeCommitMessage;
    @Nullable
    private final String mergeCommitTitle;
    @Nullable
    private final Integer teamId;
    @Nullable
    private final String visibility;
    @Nullable
    private final Boolean webCommitSignoffRequired;

    private ImmutableRepositoryUpdate(@Nullable String description, @Nullable Boolean allowAutoMerge, @Nullable Boolean allowForking, @Nullable Boolean allowSquashMerge, @Nullable Boolean allowMergeCommit, @Nullable Boolean allowRebaseMerge, @Nullable Boolean allowUpdateBranch, @Nullable String defaultBranch, @Nullable Boolean deleteBranchOnMerge, @Nullable String homepage, @Nullable Boolean hasDownloads, @Nullable Boolean hasIssues, @Nullable Boolean hasWiki, @Nullable Boolean hasPages, @Nullable Boolean hasProjects, @Nullable Boolean isArchived, @Nullable Boolean isPrivate, @Nullable Boolean isTemplate, @Nullable String squashMergeCommitMessage, @Nullable String squashMergeCommitTitle, @Nullable String mergeCommitMessage, @Nullable String mergeCommitTitle, @Nullable Integer teamId, @Nullable String visibility, @Nullable Boolean webCommitSignoffRequired) {
        this.description = description;
        this.allowAutoMerge = allowAutoMerge;
        this.allowForking = allowForking;
        this.allowSquashMerge = allowSquashMerge;
        this.allowMergeCommit = allowMergeCommit;
        this.allowRebaseMerge = allowRebaseMerge;
        this.allowUpdateBranch = allowUpdateBranch;
        this.defaultBranch = defaultBranch;
        this.deleteBranchOnMerge = deleteBranchOnMerge;
        this.homepage = homepage;
        this.hasDownloads = hasDownloads;
        this.hasIssues = hasIssues;
        this.hasWiki = hasWiki;
        this.hasPages = hasPages;
        this.hasProjects = hasProjects;
        this.isArchived = isArchived;
        this.isPrivate = isPrivate;
        this.isTemplate = isTemplate;
        this.squashMergeCommitMessage = squashMergeCommitMessage;
        this.squashMergeCommitTitle = squashMergeCommitTitle;
        this.mergeCommitMessage = mergeCommitMessage;
        this.mergeCommitTitle = mergeCommitTitle;
        this.teamId = teamId;
        this.visibility = visibility;
        this.webCommitSignoffRequired = webCommitSignoffRequired;
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> allowAutoMerge() {
        return Optional.ofNullable(this.allowAutoMerge);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> allowForking() {
        return Optional.ofNullable(this.allowForking);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> allowSquashMerge() {
        return Optional.ofNullable(this.allowSquashMerge);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> allowMergeCommit() {
        return Optional.ofNullable(this.allowMergeCommit);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> allowRebaseMerge() {
        return Optional.ofNullable(this.allowRebaseMerge);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> allowUpdateBranch() {
        return Optional.ofNullable(this.allowUpdateBranch);
    }

    @Override
    @JsonProperty
    public Optional<String> defaultBranch() {
        return Optional.ofNullable(this.defaultBranch);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> deleteBranchOnMerge() {
        return Optional.ofNullable(this.deleteBranchOnMerge);
    }

    @Override
    @JsonProperty
    public Optional<String> homepage() {
        return Optional.ofNullable(this.homepage);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> hasDownloads() {
        return Optional.ofNullable(this.hasDownloads);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> hasIssues() {
        return Optional.ofNullable(this.hasIssues);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> hasWiki() {
        return Optional.ofNullable(this.hasWiki);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> hasPages() {
        return Optional.ofNullable(this.hasPages);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> hasProjects() {
        return Optional.ofNullable(this.hasProjects);
    }

    @Override
    @JsonProperty(value="archived")
    public Optional<Boolean> isArchived() {
        return Optional.ofNullable(this.isArchived);
    }

    @Override
    @JsonProperty(value="private")
    public Optional<Boolean> isPrivate() {
        return Optional.ofNullable(this.isPrivate);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isTemplate() {
        return Optional.ofNullable(this.isTemplate);
    }

    @Override
    @JsonProperty
    public Optional<String> squashMergeCommitMessage() {
        return Optional.ofNullable(this.squashMergeCommitMessage);
    }

    @Override
    @JsonProperty
    public Optional<String> squashMergeCommitTitle() {
        return Optional.ofNullable(this.squashMergeCommitTitle);
    }

    @Override
    @JsonProperty
    public Optional<String> mergeCommitMessage() {
        return Optional.ofNullable(this.mergeCommitMessage);
    }

    @Override
    @JsonProperty
    public Optional<String> mergeCommitTitle() {
        return Optional.ofNullable(this.mergeCommitTitle);
    }

    @Override
    @JsonProperty
    public Optional<Integer> teamId() {
        return Optional.ofNullable(this.teamId);
    }

    @Override
    @JsonProperty
    public Optional<String> visibility() {
        return Optional.ofNullable(this.visibility);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> webCommitSignoffRequired() {
        return Optional.ofNullable(this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(newValue, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(value, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowAutoMerge(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.allowAutoMerge, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, newValue, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowAutoMerge(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.allowAutoMerge, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, value, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowForking(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.allowForking, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, newValue, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowForking(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.allowForking, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, value, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowSquashMerge(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.allowSquashMerge, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, newValue, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowSquashMerge(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.allowSquashMerge, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, value, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowMergeCommit(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.allowMergeCommit, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, newValue, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowMergeCommit(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.allowMergeCommit, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, value, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowRebaseMerge(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.allowRebaseMerge, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, newValue, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowRebaseMerge(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.allowRebaseMerge, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, value, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowUpdateBranch(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.allowUpdateBranch, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, newValue, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withAllowUpdateBranch(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.allowUpdateBranch, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, value, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withDefaultBranch(String value) {
        String newValue = Objects.requireNonNull(value, "defaultBranch");
        if (Objects.equals(this.defaultBranch, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, newValue, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withDefaultBranch(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.defaultBranch, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, value, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withDeleteBranchOnMerge(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.deleteBranchOnMerge, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, newValue, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withDeleteBranchOnMerge(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.deleteBranchOnMerge, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, value, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHomepage(String value) {
        String newValue = Objects.requireNonNull(value, "homepage");
        if (Objects.equals(this.homepage, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, newValue, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHomepage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.homepage, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, value, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasDownloads(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.hasDownloads, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, newValue, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasDownloads(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.hasDownloads, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, value, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasIssues(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.hasIssues, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, newValue, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasIssues(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.hasIssues, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, value, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasWiki(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.hasWiki, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, newValue, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasWiki(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.hasWiki, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, value, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasPages(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.hasPages, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, newValue, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasPages(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.hasPages, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, value, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasProjects(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.hasProjects, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, newValue, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withHasProjects(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.hasProjects, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, value, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withIsArchived(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isArchived, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, newValue, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withIsArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isArchived, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, value, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withIsPrivate(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isPrivate, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, newValue, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withIsPrivate(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isPrivate, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, value, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withIsTemplate(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isTemplate, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, newValue, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withIsTemplate(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isTemplate, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, value, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withSquashMergeCommitMessage(String value) {
        String newValue = Objects.requireNonNull(value, "squashMergeCommitMessage");
        if (Objects.equals(this.squashMergeCommitMessage, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, newValue, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withSquashMergeCommitMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.squashMergeCommitMessage, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, value, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withSquashMergeCommitTitle(String value) {
        String newValue = Objects.requireNonNull(value, "squashMergeCommitTitle");
        if (Objects.equals(this.squashMergeCommitTitle, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, newValue, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withSquashMergeCommitTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.squashMergeCommitTitle, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, value, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withMergeCommitMessage(String value) {
        String newValue = Objects.requireNonNull(value, "mergeCommitMessage");
        if (Objects.equals(this.mergeCommitMessage, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, newValue, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withMergeCommitMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeCommitMessage, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, value, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withMergeCommitTitle(String value) {
        String newValue = Objects.requireNonNull(value, "mergeCommitTitle");
        if (Objects.equals(this.mergeCommitTitle, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, newValue, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withMergeCommitTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeCommitTitle, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, value, this.teamId, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withTeamId(int value) {
        Integer newValue = value;
        if (Objects.equals(this.teamId, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, newValue, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withTeamId(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.teamId, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, value, this.visibility, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withVisibility(String value) {
        String newValue = Objects.requireNonNull(value, "visibility");
        if (Objects.equals(this.visibility, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, newValue, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withVisibility(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.visibility, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, value, this.webCommitSignoffRequired);
    }

    public final ImmutableRepositoryUpdate withWebCommitSignoffRequired(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.webCommitSignoffRequired, newValue)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, newValue);
    }

    public final ImmutableRepositoryUpdate withWebCommitSignoffRequired(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.webCommitSignoffRequired, value)) {
            return this;
        }
        return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryUpdate && this.equalTo(0, (ImmutableRepositoryUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryUpdate another) {
        return Objects.equals(this.description, another.description) && Objects.equals(this.allowAutoMerge, another.allowAutoMerge) && Objects.equals(this.allowForking, another.allowForking) && Objects.equals(this.allowSquashMerge, another.allowSquashMerge) && Objects.equals(this.allowMergeCommit, another.allowMergeCommit) && Objects.equals(this.allowRebaseMerge, another.allowRebaseMerge) && Objects.equals(this.allowUpdateBranch, another.allowUpdateBranch) && Objects.equals(this.defaultBranch, another.defaultBranch) && Objects.equals(this.deleteBranchOnMerge, another.deleteBranchOnMerge) && Objects.equals(this.homepage, another.homepage) && Objects.equals(this.hasDownloads, another.hasDownloads) && Objects.equals(this.hasIssues, another.hasIssues) && Objects.equals(this.hasWiki, another.hasWiki) && Objects.equals(this.hasPages, another.hasPages) && Objects.equals(this.hasProjects, another.hasProjects) && Objects.equals(this.isArchived, another.isArchived) && Objects.equals(this.isPrivate, another.isPrivate) && Objects.equals(this.isTemplate, another.isTemplate) && Objects.equals(this.squashMergeCommitMessage, another.squashMergeCommitMessage) && Objects.equals(this.squashMergeCommitTitle, another.squashMergeCommitTitle) && Objects.equals(this.mergeCommitMessage, another.mergeCommitMessage) && Objects.equals(this.mergeCommitTitle, another.mergeCommitTitle) && Objects.equals(this.teamId, another.teamId) && Objects.equals(this.visibility, another.visibility) && Objects.equals(this.webCommitSignoffRequired, another.webCommitSignoffRequired);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.allowAutoMerge);
        h += (h << 5) + Objects.hashCode(this.allowForking);
        h += (h << 5) + Objects.hashCode(this.allowSquashMerge);
        h += (h << 5) + Objects.hashCode(this.allowMergeCommit);
        h += (h << 5) + Objects.hashCode(this.allowRebaseMerge);
        h += (h << 5) + Objects.hashCode(this.allowUpdateBranch);
        h += (h << 5) + Objects.hashCode(this.defaultBranch);
        h += (h << 5) + Objects.hashCode(this.deleteBranchOnMerge);
        h += (h << 5) + Objects.hashCode(this.homepage);
        h += (h << 5) + Objects.hashCode(this.hasDownloads);
        h += (h << 5) + Objects.hashCode(this.hasIssues);
        h += (h << 5) + Objects.hashCode(this.hasWiki);
        h += (h << 5) + Objects.hashCode(this.hasPages);
        h += (h << 5) + Objects.hashCode(this.hasProjects);
        h += (h << 5) + Objects.hashCode(this.isArchived);
        h += (h << 5) + Objects.hashCode(this.isPrivate);
        h += (h << 5) + Objects.hashCode(this.isTemplate);
        h += (h << 5) + Objects.hashCode(this.squashMergeCommitMessage);
        h += (h << 5) + Objects.hashCode(this.squashMergeCommitTitle);
        h += (h << 5) + Objects.hashCode(this.mergeCommitMessage);
        h += (h << 5) + Objects.hashCode(this.mergeCommitTitle);
        h += (h << 5) + Objects.hashCode(this.teamId);
        h += (h << 5) + Objects.hashCode(this.visibility);
        h += (h << 5) + Objects.hashCode(this.webCommitSignoffRequired);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RepositoryUpdate{");
        if (this.description != null) {
            builder.append("description=").append(this.description);
        }
        if (this.allowAutoMerge != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("allowAutoMerge=").append(this.allowAutoMerge);
        }
        if (this.allowForking != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("allowForking=").append(this.allowForking);
        }
        if (this.allowSquashMerge != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("allowSquashMerge=").append(this.allowSquashMerge);
        }
        if (this.allowMergeCommit != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("allowMergeCommit=").append(this.allowMergeCommit);
        }
        if (this.allowRebaseMerge != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("allowRebaseMerge=").append(this.allowRebaseMerge);
        }
        if (this.allowUpdateBranch != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("allowUpdateBranch=").append(this.allowUpdateBranch);
        }
        if (this.defaultBranch != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("defaultBranch=").append(this.defaultBranch);
        }
        if (this.deleteBranchOnMerge != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("deleteBranchOnMerge=").append(this.deleteBranchOnMerge);
        }
        if (this.homepage != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("homepage=").append(this.homepage);
        }
        if (this.hasDownloads != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("hasDownloads=").append(this.hasDownloads);
        }
        if (this.hasIssues != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("hasIssues=").append(this.hasIssues);
        }
        if (this.hasWiki != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("hasWiki=").append(this.hasWiki);
        }
        if (this.hasPages != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("hasPages=").append(this.hasPages);
        }
        if (this.hasProjects != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("hasProjects=").append(this.hasProjects);
        }
        if (this.isArchived != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("isArchived=").append(this.isArchived);
        }
        if (this.isPrivate != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("isPrivate=").append(this.isPrivate);
        }
        if (this.isTemplate != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("isTemplate=").append(this.isTemplate);
        }
        if (this.squashMergeCommitMessage != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("squashMergeCommitMessage=").append(this.squashMergeCommitMessage);
        }
        if (this.squashMergeCommitTitle != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("squashMergeCommitTitle=").append(this.squashMergeCommitTitle);
        }
        if (this.mergeCommitMessage != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("mergeCommitMessage=").append(this.mergeCommitMessage);
        }
        if (this.mergeCommitTitle != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("mergeCommitTitle=").append(this.mergeCommitTitle);
        }
        if (this.teamId != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("teamId=").append(this.teamId);
        }
        if (this.visibility != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("visibility=").append(this.visibility);
        }
        if (this.webCommitSignoffRequired != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("webCommitSignoffRequired=").append(this.webCommitSignoffRequired);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryUpdate fromJson(Json json) {
        Builder builder = ImmutableRepositoryUpdate.builder();
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.allowAutoMerge != null) {
            builder.allowAutoMerge(json.allowAutoMerge);
        }
        if (json.allowForking != null) {
            builder.allowForking(json.allowForking);
        }
        if (json.allowSquashMerge != null) {
            builder.allowSquashMerge(json.allowSquashMerge);
        }
        if (json.allowMergeCommit != null) {
            builder.allowMergeCommit(json.allowMergeCommit);
        }
        if (json.allowRebaseMerge != null) {
            builder.allowRebaseMerge(json.allowRebaseMerge);
        }
        if (json.allowUpdateBranch != null) {
            builder.allowUpdateBranch(json.allowUpdateBranch);
        }
        if (json.defaultBranch != null) {
            builder.defaultBranch(json.defaultBranch);
        }
        if (json.deleteBranchOnMerge != null) {
            builder.deleteBranchOnMerge(json.deleteBranchOnMerge);
        }
        if (json.homepage != null) {
            builder.homepage(json.homepage);
        }
        if (json.hasDownloads != null) {
            builder.hasDownloads(json.hasDownloads);
        }
        if (json.hasIssues != null) {
            builder.hasIssues(json.hasIssues);
        }
        if (json.hasWiki != null) {
            builder.hasWiki(json.hasWiki);
        }
        if (json.hasPages != null) {
            builder.hasPages(json.hasPages);
        }
        if (json.hasProjects != null) {
            builder.hasProjects(json.hasProjects);
        }
        if (json.isArchived != null) {
            builder.isArchived(json.isArchived);
        }
        if (json.isPrivate != null) {
            builder.isPrivate(json.isPrivate);
        }
        if (json.isTemplate != null) {
            builder.isTemplate(json.isTemplate);
        }
        if (json.squashMergeCommitMessage != null) {
            builder.squashMergeCommitMessage(json.squashMergeCommitMessage);
        }
        if (json.squashMergeCommitTitle != null) {
            builder.squashMergeCommitTitle(json.squashMergeCommitTitle);
        }
        if (json.mergeCommitMessage != null) {
            builder.mergeCommitMessage(json.mergeCommitMessage);
        }
        if (json.mergeCommitTitle != null) {
            builder.mergeCommitTitle(json.mergeCommitTitle);
        }
        if (json.teamId != null) {
            builder.teamId(json.teamId);
        }
        if (json.visibility != null) {
            builder.visibility(json.visibility);
        }
        if (json.webCommitSignoffRequired != null) {
            builder.webCommitSignoffRequired(json.webCommitSignoffRequired);
        }
        return builder.build();
    }

    public static ImmutableRepositoryUpdate copyOf(RepositoryUpdate instance) {
        if (instance instanceof ImmutableRepositoryUpdate) {
            return (ImmutableRepositoryUpdate)instance;
        }
        return ImmutableRepositoryUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryUpdate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String description;
        @Nullable
        private Boolean allowAutoMerge;
        @Nullable
        private Boolean allowForking;
        @Nullable
        private Boolean allowSquashMerge;
        @Nullable
        private Boolean allowMergeCommit;
        @Nullable
        private Boolean allowRebaseMerge;
        @Nullable
        private Boolean allowUpdateBranch;
        @Nullable
        private String defaultBranch;
        @Nullable
        private Boolean deleteBranchOnMerge;
        @Nullable
        private String homepage;
        @Nullable
        private Boolean hasDownloads;
        @Nullable
        private Boolean hasIssues;
        @Nullable
        private Boolean hasWiki;
        @Nullable
        private Boolean hasPages;
        @Nullable
        private Boolean hasProjects;
        @Nullable
        private Boolean isArchived;
        @Nullable
        private Boolean isPrivate;
        @Nullable
        private Boolean isTemplate;
        @Nullable
        private String squashMergeCommitMessage;
        @Nullable
        private String squashMergeCommitTitle;
        @Nullable
        private String mergeCommitMessage;
        @Nullable
        private String mergeCommitTitle;
        @Nullable
        private Integer teamId;
        @Nullable
        private String visibility;
        @Nullable
        private Boolean webCommitSignoffRequired;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryUpdate instance) {
            Optional<Boolean> webCommitSignoffRequiredOptional;
            Optional<String> visibilityOptional;
            Optional<Integer> teamIdOptional;
            Optional<String> mergeCommitTitleOptional;
            Optional<String> mergeCommitMessageOptional;
            Optional<String> squashMergeCommitTitleOptional;
            Optional<String> squashMergeCommitMessageOptional;
            Optional<Boolean> isTemplateOptional;
            Optional<Boolean> isPrivateOptional;
            Optional<Boolean> isArchivedOptional;
            Optional<Boolean> hasProjectsOptional;
            Optional<Boolean> hasPagesOptional;
            Optional<Boolean> hasWikiOptional;
            Optional<Boolean> hasIssuesOptional;
            Optional<Boolean> hasDownloadsOptional;
            Optional<String> homepageOptional;
            Optional<Boolean> deleteBranchOnMergeOptional;
            Optional<String> defaultBranchOptional;
            Optional<Boolean> allowUpdateBranchOptional;
            Optional<Boolean> allowRebaseMergeOptional;
            Optional<Boolean> allowMergeCommitOptional;
            Optional<Boolean> allowSquashMergeOptional;
            Optional<Boolean> allowForkingOptional;
            Optional<Boolean> allowAutoMergeOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            if ((allowAutoMergeOptional = instance.allowAutoMerge()).isPresent()) {
                this.allowAutoMerge(allowAutoMergeOptional);
            }
            if ((allowForkingOptional = instance.allowForking()).isPresent()) {
                this.allowForking(allowForkingOptional);
            }
            if ((allowSquashMergeOptional = instance.allowSquashMerge()).isPresent()) {
                this.allowSquashMerge(allowSquashMergeOptional);
            }
            if ((allowMergeCommitOptional = instance.allowMergeCommit()).isPresent()) {
                this.allowMergeCommit(allowMergeCommitOptional);
            }
            if ((allowRebaseMergeOptional = instance.allowRebaseMerge()).isPresent()) {
                this.allowRebaseMerge(allowRebaseMergeOptional);
            }
            if ((allowUpdateBranchOptional = instance.allowUpdateBranch()).isPresent()) {
                this.allowUpdateBranch(allowUpdateBranchOptional);
            }
            if ((defaultBranchOptional = instance.defaultBranch()).isPresent()) {
                this.defaultBranch(defaultBranchOptional);
            }
            if ((deleteBranchOnMergeOptional = instance.deleteBranchOnMerge()).isPresent()) {
                this.deleteBranchOnMerge(deleteBranchOnMergeOptional);
            }
            if ((homepageOptional = instance.homepage()).isPresent()) {
                this.homepage(homepageOptional);
            }
            if ((hasDownloadsOptional = instance.hasDownloads()).isPresent()) {
                this.hasDownloads(hasDownloadsOptional);
            }
            if ((hasIssuesOptional = instance.hasIssues()).isPresent()) {
                this.hasIssues(hasIssuesOptional);
            }
            if ((hasWikiOptional = instance.hasWiki()).isPresent()) {
                this.hasWiki(hasWikiOptional);
            }
            if ((hasPagesOptional = instance.hasPages()).isPresent()) {
                this.hasPages(hasPagesOptional);
            }
            if ((hasProjectsOptional = instance.hasProjects()).isPresent()) {
                this.hasProjects(hasProjectsOptional);
            }
            if ((isArchivedOptional = instance.isArchived()).isPresent()) {
                this.isArchived(isArchivedOptional);
            }
            if ((isPrivateOptional = instance.isPrivate()).isPresent()) {
                this.isPrivate(isPrivateOptional);
            }
            if ((isTemplateOptional = instance.isTemplate()).isPresent()) {
                this.isTemplate(isTemplateOptional);
            }
            if ((squashMergeCommitMessageOptional = instance.squashMergeCommitMessage()).isPresent()) {
                this.squashMergeCommitMessage(squashMergeCommitMessageOptional);
            }
            if ((squashMergeCommitTitleOptional = instance.squashMergeCommitTitle()).isPresent()) {
                this.squashMergeCommitTitle(squashMergeCommitTitleOptional);
            }
            if ((mergeCommitMessageOptional = instance.mergeCommitMessage()).isPresent()) {
                this.mergeCommitMessage(mergeCommitMessageOptional);
            }
            if ((mergeCommitTitleOptional = instance.mergeCommitTitle()).isPresent()) {
                this.mergeCommitTitle(mergeCommitTitleOptional);
            }
            if ((teamIdOptional = instance.teamId()).isPresent()) {
                this.teamId(teamIdOptional);
            }
            if ((visibilityOptional = instance.visibility()).isPresent()) {
                this.visibility(visibilityOptional);
            }
            if ((webCommitSignoffRequiredOptional = instance.webCommitSignoffRequired()).isPresent()) {
                this.webCommitSignoffRequired(webCommitSignoffRequiredOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowAutoMerge(boolean allowAutoMerge) {
            this.allowAutoMerge = allowAutoMerge;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowAutoMerge(Optional<Boolean> allowAutoMerge) {
            this.allowAutoMerge = allowAutoMerge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowForking(boolean allowForking) {
            this.allowForking = allowForking;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowForking(Optional<Boolean> allowForking) {
            this.allowForking = allowForking.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowSquashMerge(boolean allowSquashMerge) {
            this.allowSquashMerge = allowSquashMerge;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowSquashMerge(Optional<Boolean> allowSquashMerge) {
            this.allowSquashMerge = allowSquashMerge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowMergeCommit(boolean allowMergeCommit) {
            this.allowMergeCommit = allowMergeCommit;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowMergeCommit(Optional<Boolean> allowMergeCommit) {
            this.allowMergeCommit = allowMergeCommit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowRebaseMerge(boolean allowRebaseMerge) {
            this.allowRebaseMerge = allowRebaseMerge;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowRebaseMerge(Optional<Boolean> allowRebaseMerge) {
            this.allowRebaseMerge = allowRebaseMerge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowUpdateBranch(boolean allowUpdateBranch) {
            this.allowUpdateBranch = allowUpdateBranch;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowUpdateBranch(Optional<Boolean> allowUpdateBranch) {
            this.allowUpdateBranch = allowUpdateBranch.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = Objects.requireNonNull(defaultBranch, "defaultBranch");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder defaultBranch(Optional<String> defaultBranch) {
            this.defaultBranch = defaultBranch.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleteBranchOnMerge(boolean deleteBranchOnMerge) {
            this.deleteBranchOnMerge = deleteBranchOnMerge;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deleteBranchOnMerge(Optional<Boolean> deleteBranchOnMerge) {
            this.deleteBranchOnMerge = deleteBranchOnMerge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder homepage(String homepage) {
            this.homepage = Objects.requireNonNull(homepage, "homepage");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder homepage(Optional<String> homepage) {
            this.homepage = homepage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasDownloads(boolean hasDownloads) {
            this.hasDownloads = hasDownloads;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder hasDownloads(Optional<Boolean> hasDownloads) {
            this.hasDownloads = hasDownloads.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasIssues(boolean hasIssues) {
            this.hasIssues = hasIssues;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder hasIssues(Optional<Boolean> hasIssues) {
            this.hasIssues = hasIssues.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasWiki(boolean hasWiki) {
            this.hasWiki = hasWiki;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder hasWiki(Optional<Boolean> hasWiki) {
            this.hasWiki = hasWiki.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasPages(boolean hasPages) {
            this.hasPages = hasPages;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder hasPages(Optional<Boolean> hasPages) {
            this.hasPages = hasPages.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasProjects(boolean hasProjects) {
            this.hasProjects = hasProjects;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder hasProjects(Optional<Boolean> hasProjects) {
            this.hasProjects = hasProjects.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isArchived(boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        @JsonProperty(value="archived")
        @CanIgnoreReturnValue
        public final Builder isArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        @JsonProperty(value="private")
        @CanIgnoreReturnValue
        public final Builder isPrivate(Optional<Boolean> isPrivate) {
            this.isPrivate = isPrivate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isTemplate(boolean isTemplate) {
            this.isTemplate = isTemplate;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder isTemplate(Optional<Boolean> isTemplate) {
            this.isTemplate = isTemplate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder squashMergeCommitMessage(String squashMergeCommitMessage) {
            this.squashMergeCommitMessage = Objects.requireNonNull(squashMergeCommitMessage, "squashMergeCommitMessage");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder squashMergeCommitMessage(Optional<String> squashMergeCommitMessage) {
            this.squashMergeCommitMessage = squashMergeCommitMessage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder squashMergeCommitTitle(String squashMergeCommitTitle) {
            this.squashMergeCommitTitle = Objects.requireNonNull(squashMergeCommitTitle, "squashMergeCommitTitle");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder squashMergeCommitTitle(Optional<String> squashMergeCommitTitle) {
            this.squashMergeCommitTitle = squashMergeCommitTitle.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeCommitMessage(String mergeCommitMessage) {
            this.mergeCommitMessage = Objects.requireNonNull(mergeCommitMessage, "mergeCommitMessage");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeCommitMessage(Optional<String> mergeCommitMessage) {
            this.mergeCommitMessage = mergeCommitMessage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeCommitTitle(String mergeCommitTitle) {
            this.mergeCommitTitle = Objects.requireNonNull(mergeCommitTitle, "mergeCommitTitle");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeCommitTitle(Optional<String> mergeCommitTitle) {
            this.mergeCommitTitle = mergeCommitTitle.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder teamId(int teamId) {
            this.teamId = teamId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder teamId(Optional<Integer> teamId) {
            this.teamId = teamId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder visibility(String visibility) {
            this.visibility = Objects.requireNonNull(visibility, "visibility");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder visibility(Optional<String> visibility) {
            this.visibility = visibility.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder webCommitSignoffRequired(boolean webCommitSignoffRequired) {
            this.webCommitSignoffRequired = webCommitSignoffRequired;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder webCommitSignoffRequired(Optional<Boolean> webCommitSignoffRequired) {
            this.webCommitSignoffRequired = webCommitSignoffRequired.orElse(null);
            return this;
        }

        public ImmutableRepositoryUpdate build() {
            return new ImmutableRepositoryUpdate(this.description, this.allowAutoMerge, this.allowForking, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.allowUpdateBranch, this.defaultBranch, this.deleteBranchOnMerge, this.homepage, this.hasDownloads, this.hasIssues, this.hasWiki, this.hasPages, this.hasProjects, this.isArchived, this.isPrivate, this.isTemplate, this.squashMergeCommitMessage, this.squashMergeCommitTitle, this.mergeCommitMessage, this.mergeCommitTitle, this.teamId, this.visibility, this.webCommitSignoffRequired);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryUpdate", generator="Immutables")
    static final class Json
    implements RepositoryUpdate {
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<Boolean> allowAutoMerge = Optional.empty();
        @Nullable
        Optional<Boolean> allowForking = Optional.empty();
        @Nullable
        Optional<Boolean> allowSquashMerge = Optional.empty();
        @Nullable
        Optional<Boolean> allowMergeCommit = Optional.empty();
        @Nullable
        Optional<Boolean> allowRebaseMerge = Optional.empty();
        @Nullable
        Optional<Boolean> allowUpdateBranch = Optional.empty();
        @Nullable
        Optional<String> defaultBranch = Optional.empty();
        @Nullable
        Optional<Boolean> deleteBranchOnMerge = Optional.empty();
        @Nullable
        Optional<String> homepage = Optional.empty();
        @Nullable
        Optional<Boolean> hasDownloads = Optional.empty();
        @Nullable
        Optional<Boolean> hasIssues = Optional.empty();
        @Nullable
        Optional<Boolean> hasWiki = Optional.empty();
        @Nullable
        Optional<Boolean> hasPages = Optional.empty();
        @Nullable
        Optional<Boolean> hasProjects = Optional.empty();
        @Nullable
        Optional<Boolean> isArchived = Optional.empty();
        @Nullable
        Optional<Boolean> isPrivate = Optional.empty();
        @Nullable
        Optional<Boolean> isTemplate = Optional.empty();
        @Nullable
        Optional<String> squashMergeCommitMessage = Optional.empty();
        @Nullable
        Optional<String> squashMergeCommitTitle = Optional.empty();
        @Nullable
        Optional<String> mergeCommitMessage = Optional.empty();
        @Nullable
        Optional<String> mergeCommitTitle = Optional.empty();
        @Nullable
        Optional<Integer> teamId = Optional.empty();
        @Nullable
        Optional<String> visibility = Optional.empty();
        @Nullable
        Optional<Boolean> webCommitSignoffRequired = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setAllowAutoMerge(Optional<Boolean> allowAutoMerge) {
            this.allowAutoMerge = allowAutoMerge;
        }

        @JsonProperty
        public void setAllowForking(Optional<Boolean> allowForking) {
            this.allowForking = allowForking;
        }

        @JsonProperty
        public void setAllowSquashMerge(Optional<Boolean> allowSquashMerge) {
            this.allowSquashMerge = allowSquashMerge;
        }

        @JsonProperty
        public void setAllowMergeCommit(Optional<Boolean> allowMergeCommit) {
            this.allowMergeCommit = allowMergeCommit;
        }

        @JsonProperty
        public void setAllowRebaseMerge(Optional<Boolean> allowRebaseMerge) {
            this.allowRebaseMerge = allowRebaseMerge;
        }

        @JsonProperty
        public void setAllowUpdateBranch(Optional<Boolean> allowUpdateBranch) {
            this.allowUpdateBranch = allowUpdateBranch;
        }

        @JsonProperty
        public void setDefaultBranch(Optional<String> defaultBranch) {
            this.defaultBranch = defaultBranch;
        }

        @JsonProperty
        public void setDeleteBranchOnMerge(Optional<Boolean> deleteBranchOnMerge) {
            this.deleteBranchOnMerge = deleteBranchOnMerge;
        }

        @JsonProperty
        public void setHomepage(Optional<String> homepage) {
            this.homepage = homepage;
        }

        @JsonProperty
        public void setHasDownloads(Optional<Boolean> hasDownloads) {
            this.hasDownloads = hasDownloads;
        }

        @JsonProperty
        public void setHasIssues(Optional<Boolean> hasIssues) {
            this.hasIssues = hasIssues;
        }

        @JsonProperty
        public void setHasWiki(Optional<Boolean> hasWiki) {
            this.hasWiki = hasWiki;
        }

        @JsonProperty
        public void setHasPages(Optional<Boolean> hasPages) {
            this.hasPages = hasPages;
        }

        @JsonProperty
        public void setHasProjects(Optional<Boolean> hasProjects) {
            this.hasProjects = hasProjects;
        }

        @JsonProperty(value="archived")
        public void setIsArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived;
        }

        @JsonProperty(value="private")
        public void setIsPrivate(Optional<Boolean> isPrivate) {
            this.isPrivate = isPrivate;
        }

        @JsonProperty
        public void setIsTemplate(Optional<Boolean> isTemplate) {
            this.isTemplate = isTemplate;
        }

        @JsonProperty
        public void setSquashMergeCommitMessage(Optional<String> squashMergeCommitMessage) {
            this.squashMergeCommitMessage = squashMergeCommitMessage;
        }

        @JsonProperty
        public void setSquashMergeCommitTitle(Optional<String> squashMergeCommitTitle) {
            this.squashMergeCommitTitle = squashMergeCommitTitle;
        }

        @JsonProperty
        public void setMergeCommitMessage(Optional<String> mergeCommitMessage) {
            this.mergeCommitMessage = mergeCommitMessage;
        }

        @JsonProperty
        public void setMergeCommitTitle(Optional<String> mergeCommitTitle) {
            this.mergeCommitTitle = mergeCommitTitle;
        }

        @JsonProperty
        public void setTeamId(Optional<Integer> teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setVisibility(Optional<String> visibility) {
            this.visibility = visibility;
        }

        @JsonProperty
        public void setWebCommitSignoffRequired(Optional<Boolean> webCommitSignoffRequired) {
            this.webCommitSignoffRequired = webCommitSignoffRequired;
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> allowAutoMerge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> allowForking() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> allowSquashMerge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> allowMergeCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> allowRebaseMerge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> allowUpdateBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> defaultBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> deleteBranchOnMerge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> homepage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasDownloads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasIssues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasWiki() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasPages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasProjects() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isTemplate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> squashMergeCommitMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> squashMergeCommitTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> mergeCommitMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> mergeCommitTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> teamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> visibility() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> webCommitSignoffRequired() {
            throw new UnsupportedOperationException();
        }
    }
}

