/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.PullRequestEvent;
import com.spotify.github.v3.prs.PullRequest;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestEvent", generator="Immutables")
@Immutable
public final class ImmutablePullRequestEvent
implements PullRequestEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Integer number;
    @Nullable
    private final PullRequest pullRequest;

    private ImmutablePullRequestEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Integer number, @Nullable PullRequest pullRequest) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.number = number;
        this.pullRequest = pullRequest;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequest pullRequest() {
        return this.pullRequest;
    }

    public final ImmutablePullRequestEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutablePullRequestEvent(value, this.sender, this.eventInstallation, this.action, this.number, this.pullRequest);
    }

    public final ImmutablePullRequestEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutablePullRequestEvent(this.repository, value, this.eventInstallation, this.action, this.number, this.pullRequest);
    }

    public final ImmutablePullRequestEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutablePullRequestEvent(this.repository, this.sender, value, this.action, this.number, this.pullRequest);
    }

    public final ImmutablePullRequestEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, value, this.number, this.pullRequest);
    }

    public final ImmutablePullRequestEvent withNumber(@Nullable Integer value) {
        if (Objects.equals(this.number, value)) {
            return this;
        }
        return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.pullRequest);
    }

    public final ImmutablePullRequestEvent withPullRequest(@Nullable PullRequest value) {
        if (this.pullRequest == value) {
            return this;
        }
        return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, this.action, this.number, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestEvent && this.equalTo(0, (ImmutablePullRequestEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutablePullRequestEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.number, another.number) && Objects.equals(this.pullRequest, another.pullRequest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.number);
        h += (h << 5) + Objects.hashCode(this.pullRequest);
        return h;
    }

    public String toString() {
        return "PullRequestEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", action=" + this.action + ", number=" + this.number + ", pullRequest=" + this.pullRequest + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestEvent fromJson(Json json) {
        Builder builder = ImmutablePullRequestEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.pullRequest != null) {
            builder.pullRequest(json.pullRequest);
        }
        return builder.build();
    }

    public static ImmutablePullRequestEvent copyOf(PullRequestEvent instance) {
        if (instance instanceof ImmutablePullRequestEvent) {
            return (ImmutablePullRequestEvent)instance;
        }
        return ImmutablePullRequestEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Integer number;
        @Nullable
        private PullRequest pullRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof PullRequestEvent) {
                PullRequest pullRequestValue;
                String actionValue;
                instance = (PullRequestEvent)object;
                Integer numberValue = instance.number();
                if (numberValue != null) {
                    this.number(numberValue);
                }
                if ((actionValue = instance.action()) != null) {
                    this.action(actionValue);
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((pullRequestValue = instance.pullRequest()) != null) {
                    this.pullRequest(pullRequestValue);
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(@Nullable Integer number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequest(@Nullable PullRequest pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public ImmutablePullRequestEvent build() {
            return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, this.action, this.number, this.pullRequest);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestEvent", generator="Immutables")
    static final class Json
    implements PullRequestEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Integer number;
        @Nullable
        PullRequest pullRequest;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setNumber(@Nullable Integer number) {
            this.number = number;
        }

        @JsonProperty
        public void setPullRequest(@Nullable PullRequest pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequest pullRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

