/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.collect.ImmutableMap;
import com.spotify.github.async.AsyncPage;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubPage;
import com.spotify.github.v3.clients.GithubPageIterator;
import com.spotify.github.v3.comment.Comment;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueClient {
    static final String COMMENTS_URI_NUMBER_TEMPLATE = "/repos/%s/%s/issues/%s/comments";
    static final String COMMENTS_URI_TEMPLATE = "/repos/%s/%s/issues/comments";
    static final String COMMENTS_URI_ID_TEMPLATE = "/repos/%s/%s/issues/comments/%s";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GitHubClient github;
    private final String owner;
    private final String repo;

    IssueClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static IssueClient create(GitHubClient github, String owner, String repo) {
        return new IssueClient(github, owner, repo);
    }

    public Iterator<AsyncPage<Comment>> listComments() {
        return this.listComments(String.format(COMMENTS_URI_TEMPLATE, this.owner, this.repo));
    }

    public Iterator<AsyncPage<Comment>> listComments(int number) {
        return this.listComments(String.format(COMMENTS_URI_NUMBER_TEMPLATE, this.owner, this.repo, number));
    }

    public CompletableFuture<Comment> getComment(int id) {
        String path = String.format(COMMENTS_URI_ID_TEMPLATE, this.owner, this.repo, id);
        log.info("Fetching issue comments from " + path);
        return this.github.request(path, Comment.class);
    }

    public CompletableFuture<Comment> createComment(int number, String body) {
        String path = String.format(COMMENTS_URI_NUMBER_TEMPLATE, this.owner, this.repo, number);
        String requestBody = this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"body", (Object)body));
        return this.github.post(path, requestBody, Comment.class);
    }

    public CompletableFuture<Void> editComment(int id, String body) {
        String path = String.format(COMMENTS_URI_ID_TEMPLATE, this.owner, this.repo, id);
        return this.github.patch(path, this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"body", (Object)body))).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Void> deleteComment(int id) {
        return this.github.delete(String.format(COMMENTS_URI_ID_TEMPLATE, this.owner, this.repo, id)).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    private Iterator<AsyncPage<Comment>> listComments(String path) {
        return new GithubPageIterator<Comment>(new GithubPage<Comment>(this.github, path, GitHubClient.LIST_COMMENT_TYPE_REFERENCE));
    }
}

