/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.Organization;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Organization", generator="Immutables")
@Immutable
public final class ImmutableOrganization
implements Organization {
    @Nullable
    private final String login;
    @Nullable
    private final Long id;
    @Nullable
    private final URI url;
    @Nullable
    private final URI reposUrl;
    @Nullable
    private final URI eventsUrl;
    @Nullable
    private final String membersUrl;
    @Nullable
    private final String publicMembersUrl;
    @Nullable
    private final URI avatarUrl;

    private ImmutableOrganization(@Nullable String login, @Nullable Long id, @Nullable URI url, @Nullable URI reposUrl, @Nullable URI eventsUrl, @Nullable String membersUrl, @Nullable String publicMembersUrl, @Nullable URI avatarUrl) {
        this.login = login;
        this.id = id;
        this.url = url;
        this.reposUrl = reposUrl;
        this.eventsUrl = eventsUrl;
        this.membersUrl = membersUrl;
        this.publicMembersUrl = publicMembersUrl;
        this.avatarUrl = avatarUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String login() {
        return this.login;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI reposUrl() {
        return this.reposUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI eventsUrl() {
        return this.eventsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String membersUrl() {
        return this.membersUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String publicMembersUrl() {
        return this.publicMembersUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI avatarUrl() {
        return this.avatarUrl;
    }

    public final ImmutableOrganization withLogin(@Nullable String value) {
        if (Objects.equals(this.login, value)) {
            return this;
        }
        return new ImmutableOrganization(value, this.id, this.url, this.reposUrl, this.eventsUrl, this.membersUrl, this.publicMembersUrl, this.avatarUrl);
    }

    public final ImmutableOrganization withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableOrganization(this.login, value, this.url, this.reposUrl, this.eventsUrl, this.membersUrl, this.publicMembersUrl, this.avatarUrl);
    }

    public final ImmutableOrganization withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableOrganization(this.login, this.id, value, this.reposUrl, this.eventsUrl, this.membersUrl, this.publicMembersUrl, this.avatarUrl);
    }

    public final ImmutableOrganization withReposUrl(@Nullable URI value) {
        if (this.reposUrl == value) {
            return this;
        }
        return new ImmutableOrganization(this.login, this.id, this.url, value, this.eventsUrl, this.membersUrl, this.publicMembersUrl, this.avatarUrl);
    }

    public final ImmutableOrganization withEventsUrl(@Nullable URI value) {
        if (this.eventsUrl == value) {
            return this;
        }
        return new ImmutableOrganization(this.login, this.id, this.url, this.reposUrl, value, this.membersUrl, this.publicMembersUrl, this.avatarUrl);
    }

    public final ImmutableOrganization withMembersUrl(@Nullable String value) {
        if (Objects.equals(this.membersUrl, value)) {
            return this;
        }
        return new ImmutableOrganization(this.login, this.id, this.url, this.reposUrl, this.eventsUrl, value, this.publicMembersUrl, this.avatarUrl);
    }

    public final ImmutableOrganization withPublicMembersUrl(@Nullable String value) {
        if (Objects.equals(this.publicMembersUrl, value)) {
            return this;
        }
        return new ImmutableOrganization(this.login, this.id, this.url, this.reposUrl, this.eventsUrl, this.membersUrl, value, this.avatarUrl);
    }

    public final ImmutableOrganization withAvatarUrl(@Nullable URI value) {
        if (this.avatarUrl == value) {
            return this;
        }
        return new ImmutableOrganization(this.login, this.id, this.url, this.reposUrl, this.eventsUrl, this.membersUrl, this.publicMembersUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOrganization && this.equalTo(0, (ImmutableOrganization)another);
    }

    private boolean equalTo(int synthetic, ImmutableOrganization another) {
        return Objects.equals(this.login, another.login) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.reposUrl, another.reposUrl) && Objects.equals(this.eventsUrl, another.eventsUrl) && Objects.equals(this.membersUrl, another.membersUrl) && Objects.equals(this.publicMembersUrl, another.publicMembersUrl) && Objects.equals(this.avatarUrl, another.avatarUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.login);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.reposUrl);
        h += (h << 5) + Objects.hashCode(this.eventsUrl);
        h += (h << 5) + Objects.hashCode(this.membersUrl);
        h += (h << 5) + Objects.hashCode(this.publicMembersUrl);
        h += (h << 5) + Objects.hashCode(this.avatarUrl);
        return h;
    }

    public String toString() {
        return "Organization{login=" + this.login + ", id=" + this.id + ", url=" + this.url + ", reposUrl=" + this.reposUrl + ", eventsUrl=" + this.eventsUrl + ", membersUrl=" + this.membersUrl + ", publicMembersUrl=" + this.publicMembersUrl + ", avatarUrl=" + this.avatarUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOrganization fromJson(Json json) {
        Builder builder = ImmutableOrganization.builder();
        if (json.login != null) {
            builder.login(json.login);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.reposUrl != null) {
            builder.reposUrl(json.reposUrl);
        }
        if (json.eventsUrl != null) {
            builder.eventsUrl(json.eventsUrl);
        }
        if (json.membersUrl != null) {
            builder.membersUrl(json.membersUrl);
        }
        if (json.publicMembersUrl != null) {
            builder.publicMembersUrl(json.publicMembersUrl);
        }
        if (json.avatarUrl != null) {
            builder.avatarUrl(json.avatarUrl);
        }
        return builder.build();
    }

    public static ImmutableOrganization copyOf(Organization instance) {
        if (instance instanceof ImmutableOrganization) {
            return (ImmutableOrganization)instance;
        }
        return ImmutableOrganization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Organization", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String login;
        @Nullable
        private Long id;
        @Nullable
        private URI url;
        @Nullable
        private URI reposUrl;
        @Nullable
        private URI eventsUrl;
        @Nullable
        private String membersUrl;
        @Nullable
        private String publicMembersUrl;
        @Nullable
        private URI avatarUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Organization instance) {
            URI avatarUrlValue;
            String publicMembersUrlValue;
            String membersUrlValue;
            URI eventsUrlValue;
            URI reposUrlValue;
            URI urlValue;
            Long idValue;
            Objects.requireNonNull(instance, "instance");
            String loginValue = instance.login();
            if (loginValue != null) {
                this.login(loginValue);
            }
            if ((idValue = instance.id()) != null) {
                this.id(idValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((reposUrlValue = instance.reposUrl()) != null) {
                this.reposUrl(reposUrlValue);
            }
            if ((eventsUrlValue = instance.eventsUrl()) != null) {
                this.eventsUrl(eventsUrlValue);
            }
            if ((membersUrlValue = instance.membersUrl()) != null) {
                this.membersUrl(membersUrlValue);
            }
            if ((publicMembersUrlValue = instance.publicMembersUrl()) != null) {
                this.publicMembersUrl(publicMembersUrlValue);
            }
            if ((avatarUrlValue = instance.avatarUrl()) != null) {
                this.avatarUrl(avatarUrlValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder login(@Nullable String login) {
            this.login = login;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reposUrl(@Nullable URI reposUrl) {
            this.reposUrl = reposUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder eventsUrl(@Nullable URI eventsUrl) {
            this.eventsUrl = eventsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder membersUrl(@Nullable String membersUrl) {
            this.membersUrl = membersUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder publicMembersUrl(@Nullable String publicMembersUrl) {
            this.publicMembersUrl = publicMembersUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder avatarUrl(@Nullable URI avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        public ImmutableOrganization build() {
            return new ImmutableOrganization(this.login, this.id, this.url, this.reposUrl, this.eventsUrl, this.membersUrl, this.publicMembersUrl, this.avatarUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Organization", generator="Immutables")
    static final class Json
    implements Organization {
        @Nullable
        String login;
        @Nullable
        Long id;
        @Nullable
        URI url;
        @Nullable
        URI reposUrl;
        @Nullable
        URI eventsUrl;
        @Nullable
        String membersUrl;
        @Nullable
        String publicMembersUrl;
        @Nullable
        URI avatarUrl;

        Json() {
        }

        @JsonProperty
        public void setLogin(@Nullable String login) {
            this.login = login;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setReposUrl(@Nullable URI reposUrl) {
            this.reposUrl = reposUrl;
        }

        @JsonProperty
        public void setEventsUrl(@Nullable URI eventsUrl) {
            this.eventsUrl = eventsUrl;
        }

        @JsonProperty
        public void setMembersUrl(@Nullable String membersUrl) {
            this.membersUrl = membersUrl;
        }

        @JsonProperty
        public void setPublicMembersUrl(@Nullable String publicMembersUrl) {
            this.publicMembersUrl = publicMembersUrl;
        }

        @JsonProperty
        public void setAvatarUrl(@Nullable URI avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        @Override
        public String login() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI reposUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI eventsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String membersUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String publicMembersUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI avatarUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

