/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.Protection;
import com.spotify.github.v3.repos.RequiredStatusChecks;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Protection", generator="Immutables")
@Immutable
public final class ImmutableProtection
implements Protection {
    private final boolean enabled;
    private final RequiredStatusChecks requiredStatusChecks;

    private ImmutableProtection(boolean enabled, RequiredStatusChecks requiredStatusChecks) {
        this.enabled = enabled;
        this.requiredStatusChecks = requiredStatusChecks;
    }

    @Override
    @JsonProperty
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="required_status_checks")
    public RequiredStatusChecks requiredStatusChecks() {
        return this.requiredStatusChecks;
    }

    public final ImmutableProtection withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableProtection(value, this.requiredStatusChecks);
    }

    public final ImmutableProtection withRequiredStatusChecks(RequiredStatusChecks value) {
        if (this.requiredStatusChecks == value) {
            return this;
        }
        RequiredStatusChecks newValue = Objects.requireNonNull(value, "requiredStatusChecks");
        return new ImmutableProtection(this.enabled, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProtection && this.equalTo(0, (ImmutableProtection)another);
    }

    private boolean equalTo(int synthetic, ImmutableProtection another) {
        return this.enabled == another.enabled && this.requiredStatusChecks.equals(another.requiredStatusChecks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + this.requiredStatusChecks.hashCode();
        return h;
    }

    public String toString() {
        return "Protection{enabled=" + this.enabled + ", requiredStatusChecks=" + this.requiredStatusChecks + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProtection fromJson(Json json) {
        Builder builder = ImmutableProtection.builder();
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.requiredStatusChecks != null) {
            builder.requiredStatusChecks(json.requiredStatusChecks);
        }
        return builder.build();
    }

    public static ImmutableProtection copyOf(Protection instance) {
        if (instance instanceof ImmutableProtection) {
            return (ImmutableProtection)instance;
        }
        return ImmutableProtection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Protection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long INIT_BIT_REQUIRED_STATUS_CHECKS = 2L;
        private long initBits = 3L;
        private boolean enabled;
        @Nullable
        private RequiredStatusChecks requiredStatusChecks;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Protection instance) {
            Objects.requireNonNull(instance, "instance");
            this.enabled(instance.enabled());
            this.requiredStatusChecks(instance.requiredStatusChecks());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="required_status_checks")
        @CanIgnoreReturnValue
        public final Builder requiredStatusChecks(RequiredStatusChecks requiredStatusChecks) {
            this.requiredStatusChecks = Objects.requireNonNull(requiredStatusChecks, "requiredStatusChecks");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableProtection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProtection(this.enabled, this.requiredStatusChecks);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("requiredStatusChecks");
            }
            return "Cannot build Protection, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Protection", generator="Immutables")
    static final class Json
    implements Protection {
        boolean enabled;
        boolean enabledIsSet;
        @Nullable
        RequiredStatusChecks requiredStatusChecks;

        Json() {
        }

        @JsonProperty
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="required_status_checks")
        public void setRequiredStatusChecks(RequiredStatusChecks requiredStatusChecks) {
            this.requiredStatusChecks = requiredStatusChecks;
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RequiredStatusChecks requiredStatusChecks() {
            throw new UnsupportedOperationException();
        }
    }
}

