/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.comment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.comment.CommentReaction;
import com.spotify.github.v3.comment.CommentReactionContent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommentReaction", generator="Immutables")
@Immutable
public final class ImmutableCommentReaction
implements CommentReaction {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    private final long id;
    private final User user;
    private final CommentReactionContent content;

    private ImmutableCommentReaction(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, long id, User user, CommentReactionContent content) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.id = id;
        this.user = user;
        this.content = content;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    public CommentReactionContent content() {
        return this.content;
    }

    public final ImmutableCommentReaction withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableCommentReaction(value, this.updatedAt, this.id, this.user, this.content);
    }

    public final ImmutableCommentReaction withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableCommentReaction(this.createdAt, value, this.id, this.user, this.content);
    }

    public final ImmutableCommentReaction withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableCommentReaction(this.createdAt, this.updatedAt, value, this.user, this.content);
    }

    public final ImmutableCommentReaction withUser(User value) {
        if (this.user == value) {
            return this;
        }
        User newValue = Objects.requireNonNull(value, "user");
        return new ImmutableCommentReaction(this.createdAt, this.updatedAt, this.id, newValue, this.content);
    }

    public final ImmutableCommentReaction withContent(CommentReactionContent value) {
        CommentReactionContent newValue = Objects.requireNonNull(value, "content");
        if (this.content == newValue) {
            return this;
        }
        return new ImmutableCommentReaction(this.createdAt, this.updatedAt, this.id, this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommentReaction && this.equalTo(0, (ImmutableCommentReaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommentReaction another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && this.id == another.id && this.user.equals(another.user) && this.content.equals((Object)another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return "CommentReaction{createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", id=" + this.id + ", user=" + this.user + ", content=" + this.content + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommentReaction fromJson(Json json) {
        Builder builder = ImmutableCommentReaction.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static ImmutableCommentReaction copyOf(CommentReaction instance) {
        if (instance instanceof ImmutableCommentReaction) {
            return (ImmutableCommentReaction)instance;
        }
        return ImmutableCommentReaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommentReaction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_USER = 2L;
        private static final long INIT_BIT_CONTENT = 4L;
        private long initBits = 7L;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        private long id;
        @Nullable
        private User user;
        @Nullable
        private CommentReactionContent content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommentReaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GitHubInstant updatedAtValue;
            GitHubInstant createdAtValue;
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof CommentReaction) {
                instance = (CommentReaction)object;
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                this.id(instance.id());
                this.user(instance.user());
                this.content(instance.content());
                if ((bits & 2L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(User user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder content(CommentReactionContent content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCommentReaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommentReaction(this.createdAt, this.updatedAt, this.id, this.user, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build CommentReaction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommentReaction", generator="Immutables")
    static final class Json
    implements CommentReaction {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        long id;
        boolean idIsSet;
        @Nullable
        User user;
        @Nullable
        CommentReactionContent content;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty
        public void setUser(User user) {
            this.user = user;
        }

        @JsonProperty
        public void setContent(CommentReactionContent content) {
            this.content = content;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommentReactionContent content() {
            throw new UnsupportedOperationException();
        }
    }
}

