/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.http.HttpRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpRequest", generator="Immutables")
@Immutable
public final class ImmutableHttpRequest
implements HttpRequest {
    private final String method;
    private final String url;
    @Nullable
    private final String body;
    private final Map<String, List<String>> headers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHttpRequest(Builder builder) {
        this.url = builder.url;
        this.body = builder.body;
        if (builder.method != null) {
            this.initShim.method(builder.method);
        }
        if (builder.headersIsSet()) {
            this.initShim.headers(ImmutableHttpRequest.createUnmodifiableMap(false, false, builder.headers));
        }
        this.method = this.initShim.method();
        this.headers = this.initShim.headers();
        this.initShim = null;
    }

    private ImmutableHttpRequest(String method, String url, @Nullable String body, Map<String, List<String>> headers) {
        this.method = method;
        this.url = url;
        this.body = body;
        this.headers = headers;
        this.initShim = null;
    }

    private String methodInitialize() {
        return HttpRequest.super.method();
    }

    private Map<String, List<String>> headersInitialize() {
        return HttpRequest.super.headers();
    }

    @Override
    @JsonProperty
    public String method() {
        InitShim shim = this.initShim;
        return shim != null ? shim.method() : this.method;
    }

    @Override
    @JsonProperty
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty
    public Map<String, List<String>> headers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.headers() : this.headers;
    }

    public final ImmutableHttpRequest withMethod(String value) {
        String newValue = Objects.requireNonNull(value, "method");
        if (this.method.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpRequest(newValue, this.url, this.body, this.headers);
    }

    public final ImmutableHttpRequest withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpRequest(this.method, newValue, this.body, this.headers);
    }

    public final ImmutableHttpRequest withBody(@Nullable String value) {
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableHttpRequest(this.method, this.url, value, this.headers);
    }

    public final ImmutableHttpRequest withHeaders(Map<String, ? extends List<String>> entries) {
        if (this.headers == entries) {
            return this;
        }
        Map<String, List<String>> newValue = ImmutableHttpRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableHttpRequest(this.method, this.url, this.body, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpRequest && this.equalTo(0, (ImmutableHttpRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableHttpRequest another) {
        return this.method.equals(another.method) && this.url.equals(another.url) && Objects.equals(this.body, another.body) && this.headers.equals(another.headers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.method.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + this.headers.hashCode();
        return h;
    }

    public String toString() {
        return "HttpRequest{method=" + this.method + ", url=" + this.url + ", body=" + this.body + ", headers=" + String.valueOf(this.headers) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHttpRequest fromJson(Json json) {
        Builder builder = ImmutableHttpRequest.builder();
        if (json.method != null) {
            builder.method(json.method);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.headersIsSet) {
            builder.putAllHeaders(json.headers);
        }
        return builder.build();
    }

    public static ImmutableHttpRequest copyOf(HttpRequest instance) {
        if (instance instanceof ImmutableHttpRequest) {
            return (ImmutableHttpRequest)instance;
        }
        return ImmutableHttpRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + String.valueOf(k));
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + String.valueOf(k));
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="HttpRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long OPT_BIT_HEADERS = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String method;
        @Nullable
        private String url;
        @Nullable
        private String body;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HttpRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.method(instance.method());
            this.url(instance.url());
            String bodyValue = instance.body();
            if (bodyValue != null) {
                this.body(bodyValue);
            }
            this.putAllHeaders(instance.headers());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder method(String method) {
            this.method = Objects.requireNonNull(method, "method");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(@Nullable String body) {
            this.body = body;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(String key, List<String> value) {
            this.headers.put(Objects.requireNonNull(key, "headers key"), value == null ? Objects.requireNonNull(value, "headers value for key: " + key) : value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(Map.Entry<String, ? extends List<String>> entry) {
            List<String> v;
            String k = entry.getKey();
            this.headers.put(Objects.requireNonNull(k, "headers key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headers(Map<String, ? extends List<String>> entries) {
            this.headers.clear();
            this.optBits |= 1L;
            return this.putAllHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHeaders(Map<String, ? extends List<String>> entries) {
            for (Map.Entry<String, ? extends List<String>> e : entries.entrySet()) {
                List<String> v;
                String k = e.getKey();
                this.headers.put(Objects.requireNonNull(k, "headers key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutableHttpRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHttpRequest(this);
        }

        private boolean headersIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build HttpRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HttpRequest", generator="Immutables")
    static final class Json
    implements HttpRequest {
        @Nullable
        String method;
        @Nullable
        String url;
        @Nullable
        String body;
        @Nullable
        Map<String, List<String>> headers = Collections.emptyMap();
        boolean headersIsSet;

        Json() {
        }

        @JsonProperty
        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setBody(@Nullable String body) {
            this.body = body;
        }

        @JsonProperty
        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            this.headersIsSet = null != headers;
        }

        @Override
        public String method() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, List<String>> headers() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="HttpRequest", generator="Immutables")
    private final class InitShim {
        private byte methodBuildStage = 0;
        private String method;
        private byte headersBuildStage = 0;
        private Map<String, List<String>> headers;

        private InitShim() {
        }

        String method() {
            if (this.methodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.methodBuildStage == 0) {
                this.methodBuildStage = (byte)-1;
                this.method = Objects.requireNonNull(ImmutableHttpRequest.this.methodInitialize(), "method");
                this.methodBuildStage = 1;
            }
            return this.method;
        }

        void method(String method) {
            this.method = method;
            this.methodBuildStage = 1;
        }

        Map<String, List<String>> headers() {
            if (this.headersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.headersBuildStage == 0) {
                this.headersBuildStage = (byte)-1;
                this.headers = ImmutableHttpRequest.createUnmodifiableMap(true, false, ImmutableHttpRequest.this.headersInitialize());
                this.headersBuildStage = 1;
            }
            return this.headers;
        }

        void headers(Map<String, List<String>> headers) {
            this.headers = headers;
            this.headersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.methodBuildStage == -1) {
                attributes.add("method");
            }
            if (this.headersBuildStage == -1) {
                attributes.add("headers");
            }
            return "Cannot build HttpRequest, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }
}

