/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.github.http.HttpClient;
import com.spotify.github.http.HttpRequest;
import com.spotify.github.http.HttpResponse;
import com.spotify.github.http.ImmutableHttpRequest;
import com.spotify.github.http.okhttp.OkHttpHttpResponse;
import com.spotify.github.tracing.NoopTracer;
import com.spotify.github.tracing.Span;
import com.spotify.github.tracing.Tracer;
import com.spotify.github.tracing.opencensus.OpenCensusTracer;
import com.spotify.github.tracing.opentelemetry.OpenTelemetryTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.okhttp.v3_0.OkHttpTelemetry;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class OkHttpHttpClient
implements HttpClient {
    private final OkHttpClient client;
    private Tracer tracer;
    private Call.Factory callFactory;

    public OkHttpHttpClient(OkHttpClient client) {
        this.client = client;
        this.tracer = NoopTracer.INSTANCE;
        this.callFactory = this.createTracedClient();
    }

    public OkHttpHttpClient(OkHttpClient client, Tracer tracer) {
        this.client = client;
        this.tracer = tracer;
        this.callFactory = this.createTracedClient();
    }

    @Override
    public CompletableFuture<HttpResponse> send(final HttpRequest httpRequest) {
        Request request = this.buildOkHttpRequest(httpRequest);
        final CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        try (Span span = this.tracer.span(httpRequest);){
            if (this.callFactory == null) {
                this.callFactory = this.createTracedClient();
            }
            this.tracer.attachSpanToFuture(span, future);
            try {
                this.callFactory.newCall(request).enqueue(new Callback(){

                    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                        future.complete(new OkHttpHttpResponse(httpRequest, response));
                    }

                    public void onFailure(@NotNull Call call, @NotNull IOException e) {
                        future.completeExceptionally(e);
                    }
                });
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }
        return future;
    }

    @Override
    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
        this.callFactory = this.createTracedClient();
    }

    private Request buildOkHttpRequest(HttpRequest request) {
        Request.Builder requestBuilder = new Request.Builder().url(request.url());
        request.headers().forEach((key, values) -> values.forEach(value -> requestBuilder.addHeader(key, value)));
        if (request.method().equals("GET")) {
            requestBuilder.get();
        } else {
            requestBuilder.method(request.method(), RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)request.body()));
        }
        return requestBuilder.build();
    }

    private HttpRequest buildHttpRequest(Request request) {
        return ImmutableHttpRequest.builder().url(request.url().toString()).method(request.method()).headers(request.headers().toMultimap()).body(Optional.ofNullable(request.body()).map(Object::toString).orElse("")).build();
    }

    private Call.Factory createTracedClient() {
        if (this.tracer == null || this.tracer instanceof NoopTracer) {
            return this.createTracedClientNoopTracer();
        }
        if (this.tracer instanceof OpenCensusTracer) {
            return this.createTracedClientOpenCensus();
        }
        if (this.tracer instanceof OpenTelemetryTracer) {
            return this.createTracedClientOpenTelemetry();
        }
        return this.createTracedClientNoopTracer();
    }

    protected Call.Factory createTracedClientNoopTracer() {
        return new Call.Factory(){

            @NotNull
            public Call newCall(@NotNull Request request) {
                return OkHttpHttpClient.this.client.newCall(request);
            }
        };
    }

    @VisibleForTesting
    protected Call.Factory createTracedClientOpenTelemetry() {
        return OkHttpTelemetry.builder((OpenTelemetry)((OpenTelemetryTracer)this.tracer).getOpenTelemetry()).build().newCallFactory(this.client);
    }

    protected Call.Factory createTracedClientOpenCensus() {
        return new Call.Factory(){

            @NotNull
            public Call newCall(@NotNull Request request) {
                final CompletableFuture future = new CompletableFuture();
                final Span span = OkHttpHttpClient.this.tracer.span(OkHttpHttpClient.this.buildHttpRequest(request)).addTag("http.url", request.url().toString());
                OkHttpClient.Builder okBuilder = OkHttpHttpClient.this.client.newBuilder();
                okBuilder.networkInterceptors().add(0, new Interceptor(){

                    @NotNull
                    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                        try {
                            Response response = chain.proceed(chain.request());
                            span.addTag("http.status_code", response.code()).addTag("http.status_message", response.message()).success();
                            future.complete(response);
                            Response response2 = response;
                            return response2;
                        }
                        catch (Exception ex) {
                            span.failure(ex);
                            future.completeExceptionally(ex);
                            throw ex;
                        }
                        finally {
                            span.close();
                        }
                    }
                });
                return okBuilder.build().newCall(request);
            }
        };
    }
}

