/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.tracing.opencensus;

import com.spotify.github.tracing.Span;
import com.spotify.github.tracing.TraceHelper;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Status;
import java.util.Objects;

public class OpenCensusSpan
implements Span {
    private final io.opencensus.trace.Span span;

    public OpenCensusSpan(io.opencensus.trace.Span span) {
        this.span = Objects.requireNonNull(span);
    }

    @Override
    public Span success() {
        this.span.setStatus(Status.OK);
        return this;
    }

    @Override
    public Span failure(Throwable t) {
        TraceHelper.failSpan(this, t);
        this.span.setStatus(Status.UNKNOWN);
        return this;
    }

    @Override
    public void close() {
        this.span.end();
    }

    @Override
    public Span addTag(String key, String value) {
        this.span.putAttribute(key, AttributeValue.stringAttributeValue((String)value));
        return this;
    }

    @Override
    public Span addTag(String key, boolean value) {
        this.span.putAttribute(key, AttributeValue.booleanAttributeValue((boolean)value));
        return this;
    }

    @Override
    public Span addTag(String key, long value) {
        this.span.putAttribute(key, AttributeValue.longAttributeValue((long)value));
        return this;
    }

    @Override
    public Span addTag(String key, double value) {
        this.span.putAttribute(key, AttributeValue.doubleAttributeValue((double)value));
        return this;
    }

    @Override
    public Span addEvent(String description) {
        this.span.addAnnotation(description);
        return this;
    }
}

