/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.tracing.opencensus;

import com.spotify.github.http.HttpRequest;
import com.spotify.github.tracing.BaseTracer;
import com.spotify.github.tracing.Span;
import com.spotify.github.tracing.opencensus.OpenCensusSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class OpenCensusTracer
extends BaseTracer {
    private static final Tracer TRACER = Tracing.getTracer();

    @Override
    protected Span internalSpan(String path, String method, CompletionStage<?> future) {
        Objects.requireNonNull(path);
        io.opencensus.trace.Span ocSpan = TRACER.spanBuilder("GitHub Request").setSpanKind(Span.Kind.CLIENT).startSpan();
        Span span = new OpenCensusSpan(ocSpan).addTag("component", "github-api-client").addTag("peer.service", "github").addTag("http.url", path).addTag("method", method);
        if (future != null) {
            this.attachSpanToFuture(span, future);
        }
        return span;
    }

    @Override
    protected Span internalSpan(HttpRequest request, CompletionStage<?> future) {
        Objects.requireNonNull(request);
        return this.internalSpan(request.url(), request.method(), future);
    }
}

