/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.tracing.opentelemetry;

import com.spotify.github.tracing.Span;
import com.spotify.github.tracing.TraceHelper;
import io.opentelemetry.api.trace.StatusCode;
import java.util.Objects;

public class OpenTelemetrySpan
implements Span {
    public static final int NOT_FOUND = 404;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private final io.opentelemetry.api.trace.Span span;

    public OpenTelemetrySpan(io.opentelemetry.api.trace.Span span) {
        this.span = Objects.requireNonNull(span);
    }

    @Override
    public Span success() {
        this.span.setStatus(StatusCode.OK);
        return this;
    }

    @Override
    public Span failure(Throwable t) {
        TraceHelper.failSpan(this, t);
        this.span.setStatus(StatusCode.ERROR);
        return this;
    }

    @Override
    public void close() {
        this.span.end();
    }

    @Override
    public Span addTag(String key, String value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addTag(String key, boolean value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addTag(String key, long value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addTag(String key, double value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addEvent(String description) {
        this.span.addEvent(description);
        return this;
    }
}

