/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.DeleteEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeleteEvent", generator="Immutables")
@Immutable
public final class ImmutableDeleteEvent
implements DeleteEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String ref;
    @Nullable
    private final String refType;
    @Nullable
    private final String pusherType;

    private ImmutableDeleteEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String ref, @Nullable String refType, @Nullable String pusherType) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.ref = ref;
        this.refType = refType;
        this.pusherType = pusherType;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String ref() {
        return this.ref;
    }

    @Override
    @JsonProperty
    @Nullable
    public String refType() {
        return this.refType;
    }

    @Override
    @JsonProperty
    @Nullable
    public String pusherType() {
        return this.pusherType;
    }

    public final ImmutableDeleteEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableDeleteEvent(value, this.sender, this.eventInstallation, this.ref, this.refType, this.pusherType);
    }

    public final ImmutableDeleteEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableDeleteEvent(this.repository, value, this.eventInstallation, this.ref, this.refType, this.pusherType);
    }

    public final ImmutableDeleteEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableDeleteEvent(this.repository, this.sender, value, this.ref, this.refType, this.pusherType);
    }

    public final ImmutableDeleteEvent withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, value, this.refType, this.pusherType);
    }

    public final ImmutableDeleteEvent withRefType(@Nullable String value) {
        if (Objects.equals(this.refType, value)) {
            return this;
        }
        return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, this.ref, value, this.pusherType);
    }

    public final ImmutableDeleteEvent withPusherType(@Nullable String value) {
        if (Objects.equals(this.pusherType, value)) {
            return this;
        }
        return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteEvent && this.equalTo(0, (ImmutableDeleteEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refType, another.refType) && Objects.equals(this.pusherType, another.pusherType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refType);
        h += (h << 5) + Objects.hashCode(this.pusherType);
        return h;
    }

    public String toString() {
        return "DeleteEvent{repository=" + String.valueOf(this.repository) + ", sender=" + String.valueOf(this.sender) + ", eventInstallation=" + String.valueOf(this.eventInstallation) + ", ref=" + this.ref + ", refType=" + this.refType + ", pusherType=" + this.pusherType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeleteEvent fromJson(Json json) {
        Builder builder = ImmutableDeleteEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.ref != null) {
            builder.ref(json.ref);
        }
        if (json.refType != null) {
            builder.refType(json.refType);
        }
        if (json.pusherType != null) {
            builder.pusherType(json.pusherType);
        }
        return builder.build();
    }

    public static ImmutableDeleteEvent copyOf(DeleteEvent instance) {
        if (instance instanceof ImmutableDeleteEvent) {
            return (ImmutableDeleteEvent)instance;
        }
        return ImmutableDeleteEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String ref;
        @Nullable
        private String refType;
        @Nullable
        private String pusherType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof DeleteEvent) {
                String pusherTypeValue;
                String refValue;
                instance = (DeleteEvent)object;
                String refTypeValue = instance.refType();
                if (refTypeValue != null) {
                    this.refType(refTypeValue);
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((refValue = instance.ref()) != null) {
                    this.ref(refValue);
                }
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((pusherTypeValue = instance.pusherType()) != null) {
                    this.pusherType(pusherTypeValue);
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder refType(@Nullable String refType) {
            this.refType = refType;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pusherType(@Nullable String pusherType) {
            this.pusherType = pusherType;
            return this;
        }

        public ImmutableDeleteEvent build() {
            return new ImmutableDeleteEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, this.pusherType);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeleteEvent", generator="Immutables")
    static final class Json
    implements DeleteEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String ref;
        @Nullable
        String refType;
        @Nullable
        String pusherType;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @JsonProperty
        public void setRefType(@Nullable String refType) {
            this.refType = refType;
        }

        @JsonProperty
        public void setPusherType(@Nullable String pusherType) {
            this.pusherType = pusherType;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String refType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String pusherType() {
            throw new UnsupportedOperationException();
        }
    }
}

