/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.App;
import com.spotify.github.v3.checks.CheckRunBase;
import com.spotify.github.v3.checks.CheckRunConclusion;
import com.spotify.github.v3.checks.CheckRunOutput;
import com.spotify.github.v3.checks.CheckRunResponse;
import com.spotify.github.v3.checks.CheckRunStatus;
import com.spotify.github.v3.checks.CheckSuite;
import com.spotify.github.v3.prs.PartialPullRequestItem;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunResponse", generator="Immutables")
@Immutable
public final class ImmutableCheckRunResponse
implements CheckRunResponse {
    private final String headSha;
    private final String name;
    private final CheckRunStatus status;
    @Nullable
    private final CheckRunConclusion conclusion;
    @Nullable
    private final ZonedDateTime startedAt;
    @Nullable
    private final ZonedDateTime completedAt;
    @Nullable
    private final String externalId;
    @Nullable
    private final String detailsUrl;
    private final long id;
    private final String url;
    private final String htmlUrl;
    private final CheckRunOutput output;
    @Nullable
    private final CheckSuite checkSuite;
    @Nullable
    private final App app;
    private final List<PartialPullRequestItem> pullRequests;

    private ImmutableCheckRunResponse(String headSha, String name, CheckRunStatus status, @Nullable CheckRunConclusion conclusion, @Nullable ZonedDateTime startedAt, @Nullable ZonedDateTime completedAt, @Nullable String externalId, @Nullable String detailsUrl, long id, String url, String htmlUrl, CheckRunOutput output, @Nullable CheckSuite checkSuite, @Nullable App app, List<PartialPullRequestItem> pullRequests) {
        this.headSha = headSha;
        this.name = name;
        this.status = status;
        this.conclusion = conclusion;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.externalId = externalId;
        this.detailsUrl = detailsUrl;
        this.id = id;
        this.url = url;
        this.htmlUrl = htmlUrl;
        this.output = output;
        this.checkSuite = checkSuite;
        this.app = app;
        this.pullRequests = pullRequests;
    }

    @Override
    @JsonProperty
    public String headSha() {
        return this.headSha;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public CheckRunStatus status() {
        return this.status;
    }

    @Override
    @JsonProperty
    public Optional<CheckRunConclusion> conclusion() {
        return Optional.ofNullable(this.conclusion);
    }

    @Override
    @JsonProperty
    public Optional<ZonedDateTime> startedAt() {
        return Optional.ofNullable(this.startedAt);
    }

    @Override
    @JsonProperty
    public Optional<ZonedDateTime> completedAt() {
        return Optional.ofNullable(this.completedAt);
    }

    @Override
    @JsonProperty
    public Optional<String> externalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public Optional<String> detailsUrl() {
        return Optional.ofNullable(this.detailsUrl);
    }

    @Override
    @JsonProperty
    public long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public String htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    public CheckRunOutput output() {
        return this.output;
    }

    @Override
    @JsonProperty
    public Optional<CheckSuite> checkSuite() {
        return Optional.ofNullable(this.checkSuite);
    }

    @Override
    @JsonProperty
    public Optional<App> app() {
        return Optional.ofNullable(this.app);
    }

    @Override
    @JsonProperty
    public List<PartialPullRequestItem> pullRequests() {
        return this.pullRequests;
    }

    public final ImmutableCheckRunResponse withHeadSha(String value) {
        String newValue = Objects.requireNonNull(value, "headSha");
        if (this.headSha.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunResponse(newValue, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, newValue, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withStatus(CheckRunStatus value) {
        CheckRunStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, newValue, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withConclusion(CheckRunConclusion value) {
        CheckRunConclusion newValue = Objects.requireNonNull(value, "conclusion");
        if (this.conclusion == newValue) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, newValue, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withConclusion(Optional<? extends CheckRunConclusion> optional) {
        CheckRunConclusion value = optional.orElse(null);
        if (this.conclusion == value) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, value, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withStartedAt(ZonedDateTime value) {
        ZonedDateTime newValue = Objects.requireNonNull(value, "startedAt");
        if (this.startedAt == newValue) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, newValue, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withStartedAt(Optional<? extends ZonedDateTime> optional) {
        ZonedDateTime value = optional.orElse(null);
        if (this.startedAt == value) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, value, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withCompletedAt(ZonedDateTime value) {
        ZonedDateTime newValue = Objects.requireNonNull(value, "completedAt");
        if (this.completedAt == newValue) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, newValue, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withCompletedAt(Optional<? extends ZonedDateTime> optional) {
        ZonedDateTime value = optional.orElse(null);
        if (this.completedAt == value) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, value, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withExternalId(String value) {
        String newValue = Objects.requireNonNull(value, "externalId");
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, newValue, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, value, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withDetailsUrl(String value) {
        String newValue = Objects.requireNonNull(value, "detailsUrl");
        if (Objects.equals(this.detailsUrl, newValue)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, newValue, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withDetailsUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.detailsUrl, value)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, value, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, value, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, newValue, this.htmlUrl, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withHtmlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "htmlUrl");
        if (this.htmlUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, newValue, this.output, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withOutput(CheckRunOutput value) {
        if (this.output == value) {
            return this;
        }
        CheckRunOutput newValue = Objects.requireNonNull(value, "output");
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, newValue, this.checkSuite, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withCheckSuite(CheckSuite value) {
        CheckSuite newValue = Objects.requireNonNull(value, "checkSuite");
        if (this.checkSuite == newValue) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, newValue, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withCheckSuite(Optional<? extends CheckSuite> optional) {
        CheckSuite value = optional.orElse(null);
        if (this.checkSuite == value) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, value, this.app, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withApp(App value) {
        App newValue = Objects.requireNonNull(value, "app");
        if (this.app == newValue) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, newValue, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withApp(Optional<? extends App> optional) {
        App value = optional.orElse(null);
        if (this.app == value) {
            return this;
        }
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, value, this.pullRequests);
    }

    public final ImmutableCheckRunResponse withPullRequests(PartialPullRequestItem ... elements) {
        List<PartialPullRequestItem> newValue = ImmutableCheckRunResponse.createUnmodifiableList(false, ImmutableCheckRunResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, newValue);
    }

    public final ImmutableCheckRunResponse withPullRequests(Iterable<? extends PartialPullRequestItem> elements) {
        if (this.pullRequests == elements) {
            return this;
        }
        List<PartialPullRequestItem> newValue = ImmutableCheckRunResponse.createUnmodifiableList(false, ImmutableCheckRunResponse.createSafeList(elements, true, false));
        return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunResponse && this.equalTo(0, (ImmutableCheckRunResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckRunResponse another) {
        return this.headSha.equals(another.headSha) && this.name.equals(another.name) && this.status.equals((Object)another.status) && Objects.equals((Object)this.conclusion, (Object)another.conclusion) && Objects.equals(this.startedAt, another.startedAt) && Objects.equals(this.completedAt, another.completedAt) && Objects.equals(this.externalId, another.externalId) && Objects.equals(this.detailsUrl, another.detailsUrl) && this.id == another.id && this.url.equals(another.url) && this.htmlUrl.equals(another.htmlUrl) && this.output.equals(another.output) && Objects.equals(this.checkSuite, another.checkSuite) && Objects.equals(this.app, another.app) && this.pullRequests.equals(another.pullRequests);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.headSha.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.conclusion);
        h += (h << 5) + Objects.hashCode(this.startedAt);
        h += (h << 5) + Objects.hashCode(this.completedAt);
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + Objects.hashCode(this.detailsUrl);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.htmlUrl.hashCode();
        h += (h << 5) + this.output.hashCode();
        h += (h << 5) + Objects.hashCode(this.checkSuite);
        h += (h << 5) + Objects.hashCode(this.app);
        h += (h << 5) + this.pullRequests.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CheckRunResponse{");
        builder.append("headSha=").append(this.headSha);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("status=").append((Object)this.status);
        if (this.conclusion != null) {
            builder.append(", ");
            builder.append("conclusion=").append((Object)this.conclusion);
        }
        if (this.startedAt != null) {
            builder.append(", ");
            builder.append("startedAt=").append(this.startedAt);
        }
        if (this.completedAt != null) {
            builder.append(", ");
            builder.append("completedAt=").append(this.completedAt);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        if (this.detailsUrl != null) {
            builder.append(", ");
            builder.append("detailsUrl=").append(this.detailsUrl);
        }
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("url=").append(this.url);
        builder.append(", ");
        builder.append("htmlUrl=").append(this.htmlUrl);
        builder.append(", ");
        builder.append("output=").append(this.output);
        if (this.checkSuite != null) {
            builder.append(", ");
            builder.append("checkSuite=").append(this.checkSuite);
        }
        if (this.app != null) {
            builder.append(", ");
            builder.append("app=").append(this.app);
        }
        builder.append(", ");
        builder.append("pullRequests=").append(this.pullRequests);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunResponse fromJson(Json json) {
        Builder builder = ImmutableCheckRunResponse.builder();
        if (json.headSha != null) {
            builder.headSha(json.headSha);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.conclusion != null) {
            builder.conclusion(json.conclusion);
        }
        if (json.startedAt != null) {
            builder.startedAt(json.startedAt);
        }
        if (json.completedAt != null) {
            builder.completedAt(json.completedAt);
        }
        if (json.externalId != null) {
            builder.externalId(json.externalId);
        }
        if (json.detailsUrl != null) {
            builder.detailsUrl(json.detailsUrl);
        }
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.checkSuite != null) {
            builder.checkSuite(json.checkSuite);
        }
        if (json.app != null) {
            builder.app(json.app);
        }
        if (json.pullRequests != null) {
            builder.addAllPullRequests(json.pullRequests);
        }
        return builder.build();
    }

    public static ImmutableCheckRunResponse copyOf(CheckRunResponse instance) {
        if (instance instanceof ImmutableCheckRunResponse) {
            return (ImmutableCheckRunResponse)instance;
        }
        return ImmutableCheckRunResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckRunResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HEAD_SHA = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_STATUS = 4L;
        private static final long INIT_BIT_ID = 8L;
        private static final long INIT_BIT_URL = 16L;
        private static final long INIT_BIT_HTML_URL = 32L;
        private static final long INIT_BIT_OUTPUT = 64L;
        private long initBits = 127L;
        @Nullable
        private String headSha;
        @Nullable
        private String name;
        @Nullable
        private CheckRunStatus status;
        @Nullable
        private CheckRunConclusion conclusion;
        @Nullable
        private ZonedDateTime startedAt;
        @Nullable
        private ZonedDateTime completedAt;
        @Nullable
        private String externalId;
        @Nullable
        private String detailsUrl;
        private long id;
        @Nullable
        private String url;
        @Nullable
        private String htmlUrl;
        @Nullable
        private CheckRunOutput output;
        @Nullable
        private CheckSuite checkSuite;
        @Nullable
        private App app;
        private List<PartialPullRequestItem> pullRequests = new ArrayList<PartialPullRequestItem>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CheckRunBase instance;
            long bits = 0L;
            if (object instanceof CheckRunBase) {
                instance = (CheckRunBase)object;
                if ((bits & 0x20L) == 0L) {
                    Optional<CheckRunConclusion> conclusionOptional = instance.conclusion();
                    if (conclusionOptional.isPresent()) {
                        this.conclusion(conclusionOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
                    if (completedAtOptional.isPresent()) {
                        this.completedAt(completedAtOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> detailsUrlOptional = instance.detailsUrl();
                    if (detailsUrlOptional.isPresent()) {
                        this.detailsUrl(detailsUrlOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
                    if (startedAtOptional.isPresent()) {
                        this.startedAt(startedAtOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<String> externalIdOptional = instance.externalId();
                    if (externalIdOptional.isPresent()) {
                        this.externalId(externalIdOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.headSha(instance.headSha());
                    bits |= 0x10L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x80L;
                }
            }
            if (object instanceof CheckRunResponse) {
                Optional<CheckSuite> checkSuiteOptional;
                instance = (CheckRunResponse)object;
                Optional<App> appOptional = instance.app();
                if (appOptional.isPresent()) {
                    this.app(appOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
                    if (completedAtOptional.isPresent()) {
                        this.completedAt(completedAtOptional);
                    }
                    bits |= 1L;
                }
                if ((checkSuiteOptional = instance.checkSuite()).isPresent()) {
                    this.checkSuite(checkSuiteOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> detailsUrlOptional = instance.detailsUrl();
                    if (detailsUrlOptional.isPresent()) {
                        this.detailsUrl(detailsUrlOptional);
                    }
                    bits |= 2L;
                }
                this.htmlUrl(instance.htmlUrl());
                if ((bits & 4L) == 0L) {
                    Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
                    if (startedAtOptional.isPresent()) {
                        this.startedAt(startedAtOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<String> externalIdOptional = instance.externalId();
                    if (externalIdOptional.isPresent()) {
                        this.externalId(externalIdOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.headSha(instance.headSha());
                    bits |= 0x10L;
                }
                this.addAllPullRequests(instance.pullRequests());
                this.url(instance.url());
                if ((bits & 0x20L) == 0L) {
                    Optional<CheckRunConclusion> conclusionOptional = instance.conclusion();
                    if (conclusionOptional.isPresent()) {
                        this.conclusion(conclusionOptional);
                    }
                    bits |= 0x20L;
                }
                this.output(instance.output());
                if ((bits & 0x40L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x40L;
                }
                this.id(instance.id());
                if ((bits & 0x80L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x80L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headSha(String headSha) {
            this.headSha = Objects.requireNonNull(headSha, "headSha");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder status(CheckRunStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder conclusion(CheckRunConclusion conclusion) {
            this.conclusion = Objects.requireNonNull(conclusion, "conclusion");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder conclusion(Optional<? extends CheckRunConclusion> conclusion) {
            this.conclusion = conclusion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startedAt(ZonedDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder startedAt(Optional<? extends ZonedDateTime> startedAt) {
            this.startedAt = startedAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder completedAt(ZonedDateTime completedAt) {
            this.completedAt = Objects.requireNonNull(completedAt, "completedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder completedAt(Optional<? extends ZonedDateTime> completedAt) {
            this.completedAt = completedAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder externalId(String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder externalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder detailsUrl(String detailsUrl) {
            this.detailsUrl = Objects.requireNonNull(detailsUrl, "detailsUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder detailsUrl(Optional<String> detailsUrl) {
            this.detailsUrl = detailsUrl.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(String htmlUrl) {
            this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder output(CheckRunOutput output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder checkSuite(CheckSuite checkSuite) {
            this.checkSuite = Objects.requireNonNull(checkSuite, "checkSuite");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder checkSuite(Optional<? extends CheckSuite> checkSuite) {
            this.checkSuite = checkSuite.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder app(App app) {
            this.app = Objects.requireNonNull(app, "app");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder app(Optional<? extends App> app) {
            this.app = app.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPullRequests(PartialPullRequestItem element) {
            this.pullRequests.add(Objects.requireNonNull(element, "pullRequests element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPullRequests(PartialPullRequestItem ... elements) {
            for (PartialPullRequestItem element : elements) {
                this.pullRequests.add(Objects.requireNonNull(element, "pullRequests element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequests(Iterable<? extends PartialPullRequestItem> elements) {
            this.pullRequests.clear();
            return this.addAllPullRequests(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPullRequests(Iterable<? extends PartialPullRequestItem> elements) {
            for (PartialPullRequestItem partialPullRequestItem : elements) {
                this.pullRequests.add(Objects.requireNonNull(partialPullRequestItem, "pullRequests element"));
            }
            return this;
        }

        public ImmutableCheckRunResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckRunResponse(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.id, this.url, this.htmlUrl, this.output, this.checkSuite, this.app, ImmutableCheckRunResponse.createUnmodifiableList(true, this.pullRequests));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("headSha");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("htmlUrl");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("output");
            }
            return "Cannot build CheckRunResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunResponse", generator="Immutables")
    static final class Json
    implements CheckRunResponse {
        @Nullable
        String headSha;
        @Nullable
        String name;
        @Nullable
        CheckRunStatus status;
        @Nullable
        Optional<CheckRunConclusion> conclusion = Optional.empty();
        @Nullable
        Optional<ZonedDateTime> startedAt = Optional.empty();
        @Nullable
        Optional<ZonedDateTime> completedAt = Optional.empty();
        @Nullable
        Optional<String> externalId = Optional.empty();
        @Nullable
        Optional<String> detailsUrl = Optional.empty();
        long id;
        boolean idIsSet;
        @Nullable
        String url;
        @Nullable
        String htmlUrl;
        @Nullable
        CheckRunOutput output;
        @Nullable
        Optional<CheckSuite> checkSuite = Optional.empty();
        @Nullable
        Optional<App> app = Optional.empty();
        @Nullable
        List<PartialPullRequestItem> pullRequests = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setHeadSha(String headSha) {
            this.headSha = headSha;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setStatus(CheckRunStatus status) {
            this.status = status;
        }

        @JsonProperty
        public void setConclusion(Optional<CheckRunConclusion> conclusion) {
            this.conclusion = conclusion;
        }

        @JsonProperty
        public void setStartedAt(Optional<ZonedDateTime> startedAt) {
            this.startedAt = startedAt;
        }

        @JsonProperty
        public void setCompletedAt(Optional<ZonedDateTime> completedAt) {
            this.completedAt = completedAt;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setDetailsUrl(Optional<String> detailsUrl) {
            this.detailsUrl = detailsUrl;
        }

        @JsonProperty
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(String htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setOutput(CheckRunOutput output) {
            this.output = output;
        }

        @JsonProperty
        public void setCheckSuite(Optional<CheckSuite> checkSuite) {
            this.checkSuite = checkSuite;
        }

        @JsonProperty
        public void setApp(Optional<App> app) {
            this.app = app;
        }

        @JsonProperty
        public void setPullRequests(List<PartialPullRequestItem> pullRequests) {
            this.pullRequests = pullRequests;
        }

        @Override
        public String headSha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CheckRunStatus status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CheckRunConclusion> conclusion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ZonedDateTime> startedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ZonedDateTime> completedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> externalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> detailsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CheckRunOutput output() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CheckSuite> checkSuite() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<App> app() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PartialPullRequestItem> pullRequests() {
            throw new UnsupportedOperationException();
        }
    }
}

