/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.collect.ImmutableMap;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.workflows.WorkflowsRepositoryResponseList;
import com.spotify.github.v3.workflows.WorkflowsResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class WorkflowsClient {
    private static final String LIST_REPOSITORY_WORKFLOWS_URI = "/repos/%s/%s/actions/workflows";
    private static final String GET_WORKFLOW_URI = "/repos/%s/%s/actions/workflows/%s";
    private final GitHubClient github;
    private final String owner;
    private final String repo;
    private final Map<String, String> extraHeaders = ImmutableMap.of((Object)"Accept", (Object)"application/vnd.github+json");

    public WorkflowsClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static WorkflowsClient create(GitHubClient github, String owner, String repo) {
        return new WorkflowsClient(github, owner, repo);
    }

    public CompletableFuture<WorkflowsRepositoryResponseList> listWorkflows() {
        String path = String.format(LIST_REPOSITORY_WORKFLOWS_URI, this.owner, this.repo);
        return this.github.request(path, WorkflowsRepositoryResponseList.class, this.extraHeaders);
    }

    public CompletableFuture<WorkflowsResponse> getWorkflow(int id) {
        String path = String.format(GET_WORKFLOW_URI, this.owner, this.repo, id);
        return this.github.request(path, WorkflowsResponse.class, this.extraHeaders);
    }
}

