/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.comment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.comment.Comment;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Comment", generator="Immutables")
@Immutable
public final class ImmutableComment
implements Comment {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final URI url;
    @Nullable
    private final URI htmlUrl;
    private final Long id;
    @Nullable
    private final User user;
    @Nullable
    private final Integer position;
    @Nullable
    private final Integer line;
    @Nullable
    private final String path;
    @Nullable
    private final String commitId;
    @Nullable
    private final String body;
    @Nullable
    private final URI issueUrl;
    @Nullable
    private final String nodeId;

    private ImmutableComment(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable URI url, @Nullable URI htmlUrl, Long id, @Nullable User user, @Nullable Integer position, @Nullable Integer line, @Nullable String path, @Nullable String commitId, @Nullable String body, @Nullable URI issueUrl, @Nullable String nodeId) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.htmlUrl = htmlUrl;
        this.id = id;
        this.user = user;
        this.position = position;
        this.line = line;
        this.path = path;
        this.commitId = commitId;
        this.body = body;
        this.issueUrl = issueUrl;
        this.nodeId = nodeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    public Optional<Integer> position() {
        return Optional.ofNullable(this.position);
    }

    @Override
    @JsonProperty
    @Deprecated
    public Optional<Integer> line() {
        return Optional.ofNullable(this.line);
    }

    @Override
    @JsonProperty
    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    @Override
    @JsonProperty
    public Optional<String> commitId() {
        return Optional.ofNullable(this.commitId);
    }

    @Override
    @JsonProperty
    @Nullable
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty
    public Optional<URI> issueUrl() {
        return Optional.ofNullable(this.issueUrl);
    }

    @Override
    @JsonProperty
    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    public final ImmutableComment withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableComment(value, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, value, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, value, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, value, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withId(Long value) {
        Long newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, newValue, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, value, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withPosition(int value) {
        Integer newValue = value;
        if (Objects.equals(this.position, newValue)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, newValue, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withPosition(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.position, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, value, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    @Deprecated
    public final ImmutableComment withLine(int value) {
        Integer newValue = value;
        if (Objects.equals(this.line, newValue)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, newValue, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    @Deprecated
    public final ImmutableComment withLine(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.line, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, value, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (Objects.equals(this.path, newValue)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, newValue, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withPath(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, value, this.commitId, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withCommitId(String value) {
        String newValue = Objects.requireNonNull(value, "commitId");
        if (Objects.equals(this.commitId, newValue)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, newValue, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withCommitId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commitId, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, value, this.body, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withBody(@Nullable String value) {
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, value, this.issueUrl, this.nodeId);
    }

    public final ImmutableComment withIssueUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "issueUrl");
        if (this.issueUrl == newValue) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, newValue, this.nodeId);
    }

    public final ImmutableComment withIssueUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.issueUrl == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, value, this.nodeId);
    }

    public final ImmutableComment withNodeId(@Nullable String value) {
        if (Objects.equals(this.nodeId, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComment && this.equalTo(0, (ImmutableComment)another);
    }

    private boolean equalTo(int synthetic, ImmutableComment another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.url, another.url) && Objects.equals(this.htmlUrl, another.htmlUrl) && this.id.equals(another.id) && Objects.equals(this.user, another.user) && Objects.equals(this.position, another.position) && Objects.equals(this.line, another.line) && Objects.equals(this.path, another.path) && Objects.equals(this.commitId, another.commitId) && Objects.equals(this.body, another.body) && Objects.equals(this.issueUrl, another.issueUrl) && Objects.equals(this.nodeId, another.nodeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.position);
        h += (h << 5) + Objects.hashCode(this.line);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.commitId);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.issueUrl);
        h += (h << 5) + Objects.hashCode(this.nodeId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Comment{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 8) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.url != null) {
            if (builder.length() > 8) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 8) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (builder.length() > 8) {
            builder.append(", ");
        }
        builder.append("id=").append(this.id);
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        if (this.position != null) {
            builder.append(", ");
            builder.append("position=").append(this.position);
        }
        if (this.line != null) {
            builder.append(", ");
            builder.append("line=").append(this.line);
        }
        if (this.path != null) {
            builder.append(", ");
            builder.append("path=").append(this.path);
        }
        if (this.commitId != null) {
            builder.append(", ");
            builder.append("commitId=").append(this.commitId);
        }
        if (this.body != null) {
            builder.append(", ");
            builder.append("body=").append(this.body);
        }
        if (this.issueUrl != null) {
            builder.append(", ");
            builder.append("issueUrl=").append(this.issueUrl);
        }
        if (this.nodeId != null) {
            builder.append(", ");
            builder.append("nodeId=").append(this.nodeId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableComment fromJson(Json json) {
        Builder builder = ImmutableComment.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.position != null) {
            builder.position(json.position);
        }
        if (json.line != null) {
            builder.line(json.line);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.commitId != null) {
            builder.commitId(json.commitId);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.issueUrl != null) {
            builder.issueUrl(json.issueUrl);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        return builder.build();
    }

    public static ImmutableComment copyOf(Comment instance) {
        if (instance instanceof ImmutableComment) {
            return (ImmutableComment)instance;
        }
        return ImmutableComment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Comment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private URI url;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private Long id;
        @Nullable
        private User user;
        @Nullable
        private Integer position;
        @Nullable
        private Integer line;
        @Nullable
        private String path;
        @Nullable
        private String commitId;
        @Nullable
        private String body;
        @Nullable
        private URI issueUrl;
        @Nullable
        private String nodeId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Comment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof Comment) {
                String nodeIdValue;
                User userValue;
                Optional<URI> issueUrlOptional;
                Optional<String> pathOptional;
                URI urlValue;
                String bodyValue;
                Optional<String> commitIdOptional;
                URI htmlUrlValue;
                instance = (Comment)object;
                Optional<Integer> lineOptional = instance.line();
                if (lineOptional.isPresent()) {
                    this.line(lineOptional);
                }
                if ((htmlUrlValue = instance.htmlUrl()) != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((commitIdOptional = instance.commitId()).isPresent()) {
                    this.commitId(commitIdOptional);
                }
                if ((bodyValue = instance.body()) != null) {
                    this.body(bodyValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((bits & 1L) == 0L) {
                    GitHubInstant createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((pathOptional = instance.path()).isPresent()) {
                    this.path(pathOptional);
                }
                if ((issueUrlOptional = instance.issueUrl()).isPresent()) {
                    this.issueUrl(issueUrlOptional);
                }
                this.id(instance.id());
                Optional<Integer> positionOptional = instance.position();
                if (positionOptional.isPresent()) {
                    this.position(positionOptional);
                }
                if ((userValue = instance.user()) != null) {
                    this.user(userValue);
                }
                if ((nodeIdValue = instance.nodeId()) != null) {
                    this.nodeId(nodeIdValue);
                }
                if ((bits & 2L) == 0L) {
                    GitHubInstant updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 1L) == 0L) {
                    GitHubInstant createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    GitHubInstant updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Long id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder position(int position) {
            this.position = position;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder position(Optional<Integer> position) {
            this.position = position.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder line(int line) {
            this.line = line;
            return this;
        }

        @JsonProperty
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder line(Optional<Integer> line) {
            this.line = line.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(Optional<String> path) {
            this.path = path.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitId(String commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitId(Optional<String> commitId) {
            this.commitId = commitId.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(@Nullable String body) {
            this.body = body;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issueUrl(URI issueUrl) {
            this.issueUrl = Objects.requireNonNull(issueUrl, "issueUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder issueUrl(Optional<? extends URI> issueUrl) {
            this.issueUrl = issueUrl.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public ImmutableComment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.htmlUrl, this.id, this.user, this.position, this.line, this.path, this.commitId, this.body, this.issueUrl, this.nodeId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Comment, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Comment", generator="Immutables")
    static final class Json
    implements Comment {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        URI url;
        @Nullable
        URI htmlUrl;
        @Nullable
        Long id;
        @Nullable
        User user;
        @Nullable
        Optional<Integer> position = Optional.empty();
        @Nullable
        Optional<Integer> line = Optional.empty();
        @Nullable
        Optional<String> path = Optional.empty();
        @Nullable
        Optional<String> commitId = Optional.empty();
        @Nullable
        String body;
        @Nullable
        Optional<URI> issueUrl = Optional.empty();
        @Nullable
        String nodeId;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setId(Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setPosition(Optional<Integer> position) {
            this.position = position;
        }

        @JsonProperty
        public void setLine(Optional<Integer> line) {
            this.line = line;
        }

        @JsonProperty
        public void setPath(Optional<String> path) {
            this.path = path;
        }

        @JsonProperty
        public void setCommitId(Optional<String> commitId) {
            this.commitId = commitId;
        }

        @JsonProperty
        public void setBody(@Nullable String body) {
            this.body = body;
        }

        @JsonProperty
        public void setIssueUrl(Optional<URI> issueUrl) {
            this.issueUrl = issueUrl;
        }

        @JsonProperty
        public void setNodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> position() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> line() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> commitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> issueUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }
    }
}

