/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.issues.PullRequest;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequest", generator="Immutables")
@Immutable
public final class ImmutablePullRequest
implements PullRequest {
    @Nullable
    private final URI url;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI diffUrl;
    @Nullable
    private final URI patchUrl;

    private ImmutablePullRequest(@Nullable URI url, @Nullable URI htmlUrl, @Nullable URI diffUrl, @Nullable URI patchUrl) {
        this.url = url;
        this.htmlUrl = htmlUrl;
        this.diffUrl = diffUrl;
        this.patchUrl = patchUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI diffUrl() {
        return this.diffUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI patchUrl() {
        return this.patchUrl;
    }

    public final ImmutablePullRequest withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutablePullRequest(value, this.htmlUrl, this.diffUrl, this.patchUrl);
    }

    public final ImmutablePullRequest withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.url, value, this.diffUrl, this.patchUrl);
    }

    public final ImmutablePullRequest withDiffUrl(@Nullable URI value) {
        if (this.diffUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.url, this.htmlUrl, value, this.patchUrl);
    }

    public final ImmutablePullRequest withPatchUrl(@Nullable URI value) {
        if (this.patchUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.url, this.htmlUrl, this.diffUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequest && this.equalTo(0, (ImmutablePullRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutablePullRequest another) {
        return Objects.equals(this.url, another.url) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.diffUrl, another.diffUrl) && Objects.equals(this.patchUrl, another.patchUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.diffUrl);
        h += (h << 5) + Objects.hashCode(this.patchUrl);
        return h;
    }

    public String toString() {
        return "PullRequest{url=" + String.valueOf(this.url) + ", htmlUrl=" + String.valueOf(this.htmlUrl) + ", diffUrl=" + String.valueOf(this.diffUrl) + ", patchUrl=" + String.valueOf(this.patchUrl) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequest fromJson(Json json) {
        Builder builder = ImmutablePullRequest.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.diffUrl != null) {
            builder.diffUrl(json.diffUrl);
        }
        if (json.patchUrl != null) {
            builder.patchUrl(json.patchUrl);
        }
        return builder.build();
    }

    public static ImmutablePullRequest copyOf(PullRequest instance) {
        if (instance instanceof ImmutablePullRequest) {
            return (ImmutablePullRequest)instance;
        }
        return ImmutablePullRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private URI url;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI diffUrl;
        @Nullable
        private URI patchUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequest instance) {
            URI patchUrlValue;
            URI diffUrlValue;
            URI htmlUrlValue;
            Objects.requireNonNull(instance, "instance");
            URI urlValue = instance.url();
            if (urlValue != null) {
                this.url(urlValue);
            }
            if ((htmlUrlValue = instance.htmlUrl()) != null) {
                this.htmlUrl(htmlUrlValue);
            }
            if ((diffUrlValue = instance.diffUrl()) != null) {
                this.diffUrl(diffUrlValue);
            }
            if ((patchUrlValue = instance.patchUrl()) != null) {
                this.patchUrl(patchUrlValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder diffUrl(@Nullable URI diffUrl) {
            this.diffUrl = diffUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder patchUrl(@Nullable URI patchUrl) {
            this.patchUrl = patchUrl;
            return this;
        }

        public ImmutablePullRequest build() {
            return new ImmutablePullRequest(this.url, this.htmlUrl, this.diffUrl, this.patchUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequest", generator="Immutables")
    static final class Json
    implements PullRequest {
        @Nullable
        URI url;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI diffUrl;
        @Nullable
        URI patchUrl;

        Json() {
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setDiffUrl(@Nullable URI diffUrl) {
            this.diffUrl = diffUrl;
        }

        @JsonProperty
        public void setPatchUrl(@Nullable URI patchUrl) {
            this.patchUrl = patchUrl;
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI diffUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI patchUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

