/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.orgs.OrgMembership;
import com.spotify.github.v3.repos.Organization;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OrgMembership", generator="Immutables")
@Immutable
public final class ImmutableOrgMembership
implements OrgMembership {
    @Nullable
    private final URI url;
    @Nullable
    private final String role;
    @Nullable
    private final String state;
    @Nullable
    private final Organization organization;
    @Nullable
    private final User user;

    private ImmutableOrgMembership(@Nullable URI url, @Nullable String role, @Nullable String state, @Nullable Organization organization, @Nullable User user) {
        this.url = url;
        this.role = role;
        this.state = state;
        this.organization = organization;
        this.user = user;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String role() {
        return this.role;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public Organization organization() {
        return this.organization;
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    public final ImmutableOrgMembership withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableOrgMembership(value, this.role, this.state, this.organization, this.user);
    }

    public final ImmutableOrgMembership withRole(@Nullable String value) {
        if (Objects.equals(this.role, value)) {
            return this;
        }
        return new ImmutableOrgMembership(this.url, value, this.state, this.organization, this.user);
    }

    public final ImmutableOrgMembership withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableOrgMembership(this.url, this.role, value, this.organization, this.user);
    }

    public final ImmutableOrgMembership withOrganization(@Nullable Organization value) {
        if (this.organization == value) {
            return this;
        }
        return new ImmutableOrgMembership(this.url, this.role, this.state, value, this.user);
    }

    public final ImmutableOrgMembership withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableOrgMembership(this.url, this.role, this.state, this.organization, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOrgMembership && this.equalTo(0, (ImmutableOrgMembership)another);
    }

    private boolean equalTo(int synthetic, ImmutableOrgMembership another) {
        return Objects.equals(this.url, another.url) && Objects.equals(this.role, another.role) && Objects.equals(this.state, another.state) && Objects.equals(this.organization, another.organization) && Objects.equals(this.user, another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.role);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.organization);
        h += (h << 5) + Objects.hashCode(this.user);
        return h;
    }

    public String toString() {
        return "OrgMembership{url=" + String.valueOf(this.url) + ", role=" + this.role + ", state=" + this.state + ", organization=" + String.valueOf(this.organization) + ", user=" + String.valueOf(this.user) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOrgMembership fromJson(Json json) {
        Builder builder = ImmutableOrgMembership.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.role != null) {
            builder.role(json.role);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.organization != null) {
            builder.organization(json.organization);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        return builder.build();
    }

    public static ImmutableOrgMembership copyOf(OrgMembership instance) {
        if (instance instanceof ImmutableOrgMembership) {
            return (ImmutableOrgMembership)instance;
        }
        return ImmutableOrgMembership.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OrgMembership", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private URI url;
        @Nullable
        private String role;
        @Nullable
        private String state;
        @Nullable
        private Organization organization;
        @Nullable
        private User user;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OrgMembership instance) {
            User userValue;
            Organization organizationValue;
            String stateValue;
            String roleValue;
            Objects.requireNonNull(instance, "instance");
            URI urlValue = instance.url();
            if (urlValue != null) {
                this.url(urlValue);
            }
            if ((roleValue = instance.role()) != null) {
                this.role(roleValue);
            }
            if ((stateValue = instance.state()) != null) {
                this.state(stateValue);
            }
            if ((organizationValue = instance.organization()) != null) {
                this.organization(organizationValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder role(@Nullable String role) {
            this.role = role;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder organization(@Nullable Organization organization) {
            this.organization = organization;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        public ImmutableOrgMembership build() {
            return new ImmutableOrgMembership(this.url, this.role, this.state, this.organization, this.user);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OrgMembership", generator="Immutables")
    static final class Json
    implements OrgMembership {
        @Nullable
        URI url;
        @Nullable
        String role;
        @Nullable
        String state;
        @Nullable
        Organization organization;
        @Nullable
        User user;

        Json() {
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setOrganization(@Nullable Organization organization) {
            this.organization = organization;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String role() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Organization organization() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }
    }
}

