/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.prs.PartialPullRequestItem;
import com.spotify.github.v3.prs.PullRequestRef;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PartialPullRequestItem", generator="Immutables")
@Immutable
public final class ImmutablePartialPullRequestItem
implements PartialPullRequestItem {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final GitHubInstant closedAt;
    private final Long id;
    private final URI url;
    private final Long number;
    @Nullable
    private final PullRequestRef head;
    @Nullable
    private final PullRequestRef base;

    private ImmutablePartialPullRequestItem(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable GitHubInstant closedAt, Long id, URI url, Long number, @Nullable PullRequestRef head, @Nullable PullRequestRef base) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.id = id;
        this.url = url;
        this.number = number;
        this.head = head;
        this.base = base;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> closedAt() {
        return Optional.ofNullable(this.closedAt);
    }

    @Override
    @JsonProperty
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public Long number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestRef head() {
        return this.head;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestRef base() {
        return this.base;
    }

    public final ImmutablePartialPullRequestItem withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(value, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, value, this.closedAt, this.id, this.url, this.number, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withClosedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
        if (this.closedAt == newValue) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, newValue, this.id, this.url, this.number, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withClosedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.closedAt == value) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, value, this.id, this.url, this.number, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withId(Long value) {
        Long newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, this.closedAt, newValue, this.url, this.number, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withUrl(URI value) {
        if (this.url == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "url");
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, newValue, this.number, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withNumber(Long value) {
        Long newValue = Objects.requireNonNull(value, "number");
        if (this.number.equals(newValue)) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, newValue, this.head, this.base);
    }

    public final ImmutablePartialPullRequestItem withHead(@Nullable PullRequestRef value) {
        if (this.head == value) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, value, this.base);
    }

    public final ImmutablePartialPullRequestItem withBase(@Nullable PullRequestRef value) {
        if (this.base == value) {
            return this;
        }
        return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePartialPullRequestItem && this.equalTo(0, (ImmutablePartialPullRequestItem)another);
    }

    private boolean equalTo(int synthetic, ImmutablePartialPullRequestItem another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.closedAt, another.closedAt) && this.id.equals(another.id) && this.url.equals(another.url) && this.number.equals(another.number) && Objects.equals(this.head, another.head) && Objects.equals(this.base, another.base);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.closedAt);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.number.hashCode();
        h += (h << 5) + Objects.hashCode(this.head);
        h += (h << 5) + Objects.hashCode(this.base);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartialPullRequestItem{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 23) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.closedAt != null) {
            if (builder.length() > 23) {
                builder.append(", ");
            }
            builder.append("closedAt=").append(this.closedAt);
        }
        if (builder.length() > 23) {
            builder.append(", ");
        }
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("url=").append(this.url);
        builder.append(", ");
        builder.append("number=").append(this.number);
        if (this.head != null) {
            builder.append(", ");
            builder.append("head=").append(this.head);
        }
        if (this.base != null) {
            builder.append(", ");
            builder.append("base=").append(this.base);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePartialPullRequestItem fromJson(Json json) {
        Builder builder = ImmutablePartialPullRequestItem.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.closedAt != null) {
            builder.closedAt(json.closedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.base != null) {
            builder.base(json.base);
        }
        return builder.build();
    }

    public static ImmutablePartialPullRequestItem copyOf(PartialPullRequestItem instance) {
        if (instance instanceof ImmutablePartialPullRequestItem) {
            return (ImmutablePartialPullRequestItem)instance;
        }
        return ImmutablePartialPullRequestItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PartialPullRequestItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_NUMBER = 4L;
        private long initBits = 7L;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private GitHubInstant closedAt;
        @Nullable
        private Long id;
        @Nullable
        private URI url;
        @Nullable
        private Long number;
        @Nullable
        private PullRequestRef head;
        @Nullable
        private PullRequestRef base;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CloseTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PartialPullRequestItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GitHubInstant updatedAtValue;
            GitHubInstant createdAtValue;
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof CloseTracking) {
                instance = (CloseTracking)object;
                if ((bits & 2L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof PartialPullRequestItem) {
                PullRequestRef baseValue;
                instance = (PartialPullRequestItem)object;
                PullRequestRef headValue = instance.head();
                if (headValue != null) {
                    this.head(headValue);
                }
                if ((bits & 1L) == 0L) {
                    GitHubInstant createdAtValue2 = instance.createdAt();
                    if (createdAtValue2 != null) {
                        this.createdAt(createdAtValue2);
                    }
                    bits |= 1L;
                }
                this.number(instance.number());
                this.id(instance.id());
                if ((bits & 2L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 2L;
                }
                this.url(instance.url());
                if ((bits & 4L) == 0L) {
                    GitHubInstant updatedAtValue2 = instance.updatedAt();
                    if (updatedAtValue2 != null) {
                        this.updatedAt(updatedAtValue2);
                    }
                    bits |= 4L;
                }
                if ((baseValue = instance.base()) != null) {
                    this.base(baseValue);
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedAt(GitHubInstant closedAt) {
            this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
            this.closedAt = closedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Long id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(URI url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(Long number) {
            this.number = Objects.requireNonNull(number, "number");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder head(@Nullable PullRequestRef head) {
            this.head = head;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder base(@Nullable PullRequestRef base) {
            this.base = base;
            return this;
        }

        public ImmutablePartialPullRequestItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePartialPullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("number");
            }
            return "Cannot build PartialPullRequestItem, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PartialPullRequestItem", generator="Immutables")
    static final class Json
    implements PartialPullRequestItem {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Optional<GitHubInstant> closedAt = Optional.empty();
        @Nullable
        Long id;
        @Nullable
        URI url;
        @Nullable
        Long number;
        @Nullable
        PullRequestRef head;
        @Nullable
        PullRequestRef base;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setClosedAt(Optional<GitHubInstant> closedAt) {
            this.closedAt = closedAt;
        }

        @JsonProperty
        public void setId(Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setNumber(Long number) {
            this.number = number;
        }

        @JsonProperty
        public void setHead(@Nullable PullRequestRef head) {
            this.head = head;
        }

        @JsonProperty
        public void setBase(@Nullable PullRequestRef base) {
            this.base = base;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> closedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestRef head() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestRef base() {
            throw new UnsupportedOperationException();
        }
    }
}

