/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.ReviewComment;
import com.spotify.github.v3.prs.ReviewParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReviewParameters", generator="Immutables")
@Immutable
public final class ImmutableReviewParameters
extends ReviewParameters {
    @Nullable
    private final String commitId;
    @Nullable
    private final String body;
    private final String event;
    private final List<ReviewComment> comments;

    private ImmutableReviewParameters(@Nullable String commitId, @Nullable String body, String event, List<ReviewComment> comments) {
        this.commitId = commitId;
        this.body = body;
        this.event = event;
        this.comments = comments;
    }

    @Override
    @JsonProperty
    public Optional<String> commitId() {
        return Optional.ofNullable(this.commitId);
    }

    @Override
    @JsonProperty
    public Optional<String> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty
    public String event() {
        return this.event;
    }

    @Override
    @JsonProperty
    public List<ReviewComment> comments() {
        return this.comments;
    }

    public final ImmutableReviewParameters withCommitId(String value) {
        String newValue = Objects.requireNonNull(value, "commitId");
        if (Objects.equals(this.commitId, newValue)) {
            return this;
        }
        return new ImmutableReviewParameters(newValue, this.body, this.event, this.comments);
    }

    public final ImmutableReviewParameters withCommitId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commitId, value)) {
            return this;
        }
        return new ImmutableReviewParameters(value, this.body, this.event, this.comments);
    }

    public final ImmutableReviewParameters withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return new ImmutableReviewParameters(this.commitId, newValue, this.event, this.comments);
    }

    public final ImmutableReviewParameters withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableReviewParameters(this.commitId, value, this.event, this.comments);
    }

    public final ImmutableReviewParameters withEvent(String value) {
        String newValue = Objects.requireNonNull(value, "event");
        if (this.event.equals(newValue)) {
            return this;
        }
        return new ImmutableReviewParameters(this.commitId, this.body, newValue, this.comments);
    }

    public final ImmutableReviewParameters withComments(ReviewComment ... elements) {
        List<ReviewComment> newValue = ImmutableReviewParameters.createUnmodifiableList(false, ImmutableReviewParameters.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReviewParameters(this.commitId, this.body, this.event, newValue);
    }

    public final ImmutableReviewParameters withComments(Iterable<? extends ReviewComment> elements) {
        if (this.comments == elements) {
            return this;
        }
        List<ReviewComment> newValue = ImmutableReviewParameters.createUnmodifiableList(false, ImmutableReviewParameters.createSafeList(elements, true, false));
        return new ImmutableReviewParameters(this.commitId, this.body, this.event, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReviewParameters && this.equalTo(0, (ImmutableReviewParameters)another);
    }

    private boolean equalTo(int synthetic, ImmutableReviewParameters another) {
        return Objects.equals(this.commitId, another.commitId) && Objects.equals(this.body, another.body) && this.event.equals(another.event) && this.comments.equals(another.comments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.commitId);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + this.event.hashCode();
        h += (h << 5) + this.comments.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ReviewParameters{");
        if (this.commitId != null) {
            builder.append("commitId=").append(this.commitId);
        }
        if (this.body != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("event=").append(this.event);
        builder.append(", ");
        builder.append("comments=").append(this.comments);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReviewParameters fromJson(Json json) {
        Builder builder = ImmutableReviewParameters.builder();
        if (json.commitId != null) {
            builder.commitId(json.commitId);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.event != null) {
            builder.event(json.event);
        }
        if (json.comments != null) {
            builder.addAllComments(json.comments);
        }
        return builder.build();
    }

    public static ImmutableReviewParameters copyOf(ReviewParameters instance) {
        if (instance instanceof ImmutableReviewParameters) {
            return (ImmutableReviewParameters)instance;
        }
        return ImmutableReviewParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ReviewParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EVENT = 1L;
        private long initBits = 1L;
        @Nullable
        private String commitId;
        @Nullable
        private String body;
        @Nullable
        private String event;
        private List<ReviewComment> comments = new ArrayList<ReviewComment>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReviewParameters instance) {
            Optional<String> bodyOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> commitIdOptional = instance.commitId();
            if (commitIdOptional.isPresent()) {
                this.commitId(commitIdOptional);
            }
            if ((bodyOptional = instance.body()).isPresent()) {
                this.body(bodyOptional);
            }
            this.event(instance.event());
            this.addAllComments(instance.comments());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitId(String commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitId(Optional<String> commitId) {
            this.commitId = commitId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder event(String event) {
            this.event = Objects.requireNonNull(event, "event");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addComments(ReviewComment element) {
            this.comments.add(Objects.requireNonNull(element, "comments element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addComments(ReviewComment ... elements) {
            for (ReviewComment element : elements) {
                this.comments.add(Objects.requireNonNull(element, "comments element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comments(Iterable<? extends ReviewComment> elements) {
            this.comments.clear();
            return this.addAllComments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllComments(Iterable<? extends ReviewComment> elements) {
            for (ReviewComment reviewComment : elements) {
                this.comments.add(Objects.requireNonNull(reviewComment, "comments element"));
            }
            return this;
        }

        public ImmutableReviewParameters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReviewParameters(this.commitId, this.body, this.event, ImmutableReviewParameters.createUnmodifiableList(true, this.comments));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("event");
            }
            return "Cannot build ReviewParameters, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReviewParameters", generator="Immutables")
    static final class Json
    extends ReviewParameters {
        @Nullable
        Optional<String> commitId = Optional.empty();
        @Nullable
        Optional<String> body = Optional.empty();
        @Nullable
        String event;
        @Nullable
        List<ReviewComment> comments = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setCommitId(Optional<String> commitId) {
            this.commitId = commitId;
        }

        @JsonProperty
        public void setBody(Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setEvent(String event) {
            this.event = event;
        }

        @JsonProperty
        public void setComments(List<ReviewComment> comments) {
            this.comments = comments;
        }

        @Override
        public Optional<String> commitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String event() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ReviewComment> comments() {
            throw new UnsupportedOperationException();
        }
    }
}

