/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Author;
import com.spotify.github.v3.repos.PushCommit;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PushCommit", generator="Immutables")
@Immutable
public final class ImmutablePushCommit
implements PushCommit {
    @Nullable
    private final String id;
    @Nullable
    private final String treeId;
    @Nullable
    private final Boolean distinct;
    @Nullable
    private final String message;
    @Nullable
    private final ZonedDateTime timestamp;
    @Nullable
    private final URI url;
    @Nullable
    private final Author author;
    @Nullable
    private final Author committer;
    @Nullable
    private final List<String> added;
    @Nullable
    private final List<String> removed;
    @Nullable
    private final List<String> modified;

    private ImmutablePushCommit(@Nullable String id, @Nullable String treeId, @Nullable Boolean distinct, @Nullable String message, @Nullable ZonedDateTime timestamp, @Nullable URI url, @Nullable Author author, @Nullable Author committer, @Nullable List<String> added, @Nullable List<String> removed, @Nullable List<String> modified) {
        this.id = id;
        this.treeId = treeId;
        this.distinct = distinct;
        this.message = message;
        this.timestamp = timestamp;
        this.url = url;
        this.author = author;
        this.committer = committer;
        this.added = added;
        this.removed = removed;
        this.modified = modified;
    }

    @Override
    @JsonProperty
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String treeId() {
        return this.treeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean distinct() {
        return this.distinct;
    }

    @Override
    @JsonProperty
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    @Nullable
    public ZonedDateTime timestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Author author() {
        return this.author;
    }

    @Override
    @JsonProperty
    @Nullable
    public Author committer() {
        return this.committer;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> added() {
        return this.added;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> removed() {
        return this.removed;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> modified() {
        return this.modified;
    }

    public final ImmutablePushCommit withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePushCommit(value, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withTreeId(@Nullable String value) {
        if (Objects.equals(this.treeId, value)) {
            return this;
        }
        return new ImmutablePushCommit(this.id, value, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withDistinct(@Nullable Boolean value) {
        if (Objects.equals(this.distinct, value)) {
            return this;
        }
        return new ImmutablePushCommit(this.id, this.treeId, value, this.message, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, value, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withTimestamp(@Nullable ZonedDateTime value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, value, this.url, this.author, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, value, this.author, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withAuthor(@Nullable Author value) {
        if (this.author == value) {
            return this;
        }
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, value, this.committer, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withCommitter(@Nullable Author value) {
        if (this.committer == value) {
            return this;
        }
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, value, this.added, this.removed, this.modified);
    }

    public final ImmutablePushCommit withAdded(String ... elements) {
        if (elements == null) {
            return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, null, this.removed, this.modified);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutablePushCommit.createUnmodifiableList(false, ImmutablePushCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, newValue, this.removed, this.modified);
    }

    public final ImmutablePushCommit withAdded(@Nullable Iterable<String> elements) {
        if (this.added == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutablePushCommit.createUnmodifiableList(false, ImmutablePushCommit.createSafeList(elements, true, false));
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, newValue, this.removed, this.modified);
    }

    public final ImmutablePushCommit withRemoved(String ... elements) {
        if (elements == null) {
            return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, null, this.modified);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutablePushCommit.createUnmodifiableList(false, ImmutablePushCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, newValue, this.modified);
    }

    public final ImmutablePushCommit withRemoved(@Nullable Iterable<String> elements) {
        if (this.removed == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutablePushCommit.createUnmodifiableList(false, ImmutablePushCommit.createSafeList(elements, true, false));
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, newValue, this.modified);
    }

    public final ImmutablePushCommit withModified(String ... elements) {
        if (elements == null) {
            return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutablePushCommit.createUnmodifiableList(false, ImmutablePushCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, newValue);
    }

    public final ImmutablePushCommit withModified(@Nullable Iterable<String> elements) {
        if (this.modified == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutablePushCommit.createUnmodifiableList(false, ImmutablePushCommit.createSafeList(elements, true, false));
        return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added, this.removed, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePushCommit && this.equalTo(0, (ImmutablePushCommit)another);
    }

    private boolean equalTo(int synthetic, ImmutablePushCommit another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.treeId, another.treeId) && Objects.equals(this.distinct, another.distinct) && Objects.equals(this.message, another.message) && Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.url, another.url) && Objects.equals(this.author, another.author) && Objects.equals(this.committer, another.committer) && Objects.equals(this.added, another.added) && Objects.equals(this.removed, another.removed) && Objects.equals(this.modified, another.modified);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.treeId);
        h += (h << 5) + Objects.hashCode(this.distinct);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.timestamp);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.committer);
        h += (h << 5) + Objects.hashCode(this.added);
        h += (h << 5) + Objects.hashCode(this.removed);
        h += (h << 5) + Objects.hashCode(this.modified);
        return h;
    }

    public String toString() {
        return "PushCommit{id=" + this.id + ", treeId=" + this.treeId + ", distinct=" + this.distinct + ", message=" + this.message + ", timestamp=" + String.valueOf(this.timestamp) + ", url=" + String.valueOf(this.url) + ", author=" + String.valueOf(this.author) + ", committer=" + String.valueOf(this.committer) + ", added=" + String.valueOf(this.added) + ", removed=" + String.valueOf(this.removed) + ", modified=" + String.valueOf(this.modified) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePushCommit fromJson(Json json) {
        Builder builder = ImmutablePushCommit.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.treeId != null) {
            builder.treeId(json.treeId);
        }
        if (json.distinct != null) {
            builder.distinct(json.distinct);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.committer != null) {
            builder.committer(json.committer);
        }
        if (json.added != null) {
            builder.addAllAdded(json.added);
        }
        if (json.removed != null) {
            builder.addAllRemoved(json.removed);
        }
        if (json.modified != null) {
            builder.addAllModified(json.modified);
        }
        return builder.build();
    }

    public static ImmutablePushCommit copyOf(PushCommit instance) {
        if (instance instanceof ImmutablePushCommit) {
            return (ImmutablePushCommit)instance;
        }
        return ImmutablePushCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PushCommit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String treeId;
        @Nullable
        private Boolean distinct;
        @Nullable
        private String message;
        @Nullable
        private ZonedDateTime timestamp;
        @Nullable
        private URI url;
        @Nullable
        private Author author;
        @Nullable
        private Author committer;
        private List<String> added = null;
        private List<String> removed = null;
        private List<String> modified = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PushCommit instance) {
            List<String> modifiedValue;
            List<String> removedValue;
            List<String> addedValue;
            Author committerValue;
            Author authorValue;
            URI urlValue;
            ZonedDateTime timestampValue;
            String messageValue;
            Boolean distinctValue;
            String treeIdValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((treeIdValue = instance.treeId()) != null) {
                this.treeId(treeIdValue);
            }
            if ((distinctValue = instance.distinct()) != null) {
                this.distinct(distinctValue);
            }
            if ((messageValue = instance.message()) != null) {
                this.message(messageValue);
            }
            if ((timestampValue = instance.timestamp()) != null) {
                this.timestamp(timestampValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((authorValue = instance.author()) != null) {
                this.author(authorValue);
            }
            if ((committerValue = instance.committer()) != null) {
                this.committer(committerValue);
            }
            if ((addedValue = instance.added()) != null) {
                this.addAllAdded(addedValue);
            }
            if ((removedValue = instance.removed()) != null) {
                this.addAllRemoved(removedValue);
            }
            if ((modifiedValue = instance.modified()) != null) {
                this.addAllModified(modifiedValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder treeId(@Nullable String treeId) {
            this.treeId = treeId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder distinct(@Nullable Boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder timestamp(@Nullable ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder author(@Nullable Author author) {
            this.author = author;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder committer(@Nullable Author committer) {
            this.committer = committer;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdded(String element) {
            if (this.added == null) {
                this.added = new ArrayList<String>();
            }
            this.added.add(Objects.requireNonNull(element, "added element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdded(String ... elements) {
            if (this.added == null) {
                this.added = new ArrayList<String>();
            }
            for (String element : elements) {
                this.added.add(Objects.requireNonNull(element, "added element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder added(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.added = null;
                return this;
            }
            this.added = new ArrayList<String>();
            return this.addAllAdded(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdded(Iterable<String> elements) {
            Objects.requireNonNull(elements, "added element");
            if (this.added == null) {
                this.added = new ArrayList<String>();
            }
            for (String element : elements) {
                this.added.add(Objects.requireNonNull(element, "added element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoved(String element) {
            if (this.removed == null) {
                this.removed = new ArrayList<String>();
            }
            this.removed.add(Objects.requireNonNull(element, "removed element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoved(String ... elements) {
            if (this.removed == null) {
                this.removed = new ArrayList<String>();
            }
            for (String element : elements) {
                this.removed.add(Objects.requireNonNull(element, "removed element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder removed(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.removed = null;
                return this;
            }
            this.removed = new ArrayList<String>();
            return this.addAllRemoved(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRemoved(Iterable<String> elements) {
            Objects.requireNonNull(elements, "removed element");
            if (this.removed == null) {
                this.removed = new ArrayList<String>();
            }
            for (String element : elements) {
                this.removed.add(Objects.requireNonNull(element, "removed element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addModified(String element) {
            if (this.modified == null) {
                this.modified = new ArrayList<String>();
            }
            this.modified.add(Objects.requireNonNull(element, "modified element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addModified(String ... elements) {
            if (this.modified == null) {
                this.modified = new ArrayList<String>();
            }
            for (String element : elements) {
                this.modified.add(Objects.requireNonNull(element, "modified element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder modified(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.modified = null;
                return this;
            }
            this.modified = new ArrayList<String>();
            return this.addAllModified(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllModified(Iterable<String> elements) {
            Objects.requireNonNull(elements, "modified element");
            if (this.modified == null) {
                this.modified = new ArrayList<String>();
            }
            for (String element : elements) {
                this.modified.add(Objects.requireNonNull(element, "modified element"));
            }
            return this;
        }

        public ImmutablePushCommit build() {
            return new ImmutablePushCommit(this.id, this.treeId, this.distinct, this.message, this.timestamp, this.url, this.author, this.committer, this.added == null ? null : ImmutablePushCommit.createUnmodifiableList(true, this.added), this.removed == null ? null : ImmutablePushCommit.createUnmodifiableList(true, this.removed), this.modified == null ? null : ImmutablePushCommit.createUnmodifiableList(true, this.modified));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PushCommit", generator="Immutables")
    static final class Json
    implements PushCommit {
        @Nullable
        String id;
        @Nullable
        String treeId;
        @Nullable
        Boolean distinct;
        @Nullable
        String message;
        @Nullable
        ZonedDateTime timestamp;
        @Nullable
        URI url;
        @Nullable
        Author author;
        @Nullable
        Author committer;
        @Nullable
        List<String> added = null;
        @Nullable
        List<String> removed = null;
        @Nullable
        List<String> modified = null;

        Json() {
        }

        @JsonProperty
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty
        public void setTreeId(@Nullable String treeId) {
            this.treeId = treeId;
        }

        @JsonProperty
        public void setDistinct(@Nullable Boolean distinct) {
            this.distinct = distinct;
        }

        @JsonProperty
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @JsonProperty
        public void setTimestamp(@Nullable ZonedDateTime timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setAuthor(@Nullable Author author) {
            this.author = author;
        }

        @JsonProperty
        public void setCommitter(@Nullable Author committer) {
            this.committer = committer;
        }

        @JsonProperty
        public void setAdded(@Nullable List<String> added) {
            this.added = added;
        }

        @JsonProperty
        public void setRemoved(@Nullable List<String> removed) {
            this.removed = removed;
        }

        @JsonProperty
        public void setModified(@Nullable List<String> modified) {
            this.modified = modified;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String treeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean distinct() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime timestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Author author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Author committer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> added() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> removed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> modified() {
            throw new UnsupportedOperationException();
        }
    }
}

