/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.requests.FileCreate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileCreate", generator="Immutables")
@Immutable
public final class ImmutableFileCreate
implements FileCreate {
    private final String message;
    private final String content;
    @Nullable
    private final String branch;

    private ImmutableFileCreate(String message, String content, @Nullable String branch) {
        this.message = message;
        this.content = content;
        this.branch = branch;
    }

    @Override
    @JsonProperty
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    public String content() {
        return this.content;
    }

    @Override
    @JsonProperty
    @Nullable
    public String branch() {
        return this.branch;
    }

    public final ImmutableFileCreate withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableFileCreate(newValue, this.content, this.branch);
    }

    public final ImmutableFileCreate withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableFileCreate(this.message, newValue, this.branch);
    }

    public final ImmutableFileCreate withBranch(@Nullable String value) {
        if (Objects.equals(this.branch, value)) {
            return this;
        }
        return new ImmutableFileCreate(this.message, this.content, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileCreate && this.equalTo(0, (ImmutableFileCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileCreate another) {
        return this.message.equals(another.message) && this.content.equals(another.content) && Objects.equals(this.branch, another.branch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + Objects.hashCode(this.branch);
        return h;
    }

    public String toString() {
        return "FileCreate{message=" + this.message + ", content=" + this.content + ", branch=" + this.branch + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFileCreate fromJson(Json json) {
        Builder builder = ImmutableFileCreate.builder();
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.branch != null) {
            builder.branch(json.branch);
        }
        return builder.build();
    }

    public static ImmutableFileCreate copyOf(FileCreate instance) {
        if (instance instanceof ImmutableFileCreate) {
            return (ImmutableFileCreate)instance;
        }
        return ImmutableFileCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private long initBits = 3L;
        @Nullable
        private String message;
        @Nullable
        private String content;
        @Nullable
        private String branch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.message(instance.message());
            this.content(instance.content());
            String branchValue = instance.branch();
            if (branchValue != null) {
                this.branch(branchValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder branch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public ImmutableFileCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileCreate(this.message, this.content, this.branch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build FileCreate, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FileCreate", generator="Immutables")
    static final class Json
    implements FileCreate {
        @Nullable
        String message;
        @Nullable
        String content;
        @Nullable
        String branch;

        Json() {
        }

        @JsonProperty
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty
        public void setBranch(@Nullable String branch) {
            this.branch = branch;
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String branch() {
            throw new UnsupportedOperationException();
        }
    }
}

