/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.requests.RepositoryCreateStatus;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryCreateStatus", generator="Immutables")
@Immutable
public final class ImmutableRepositoryCreateStatus
implements RepositoryCreateStatus {
    @Nullable
    private final String state;
    @Nullable
    private final URI targetUrl;
    @Nullable
    private final String description;
    @Nullable
    private final String context;

    private ImmutableRepositoryCreateStatus(@Nullable String state, @Nullable URI targetUrl, @Nullable String description, @Nullable String context) {
        this.state = state;
        this.targetUrl = targetUrl;
        this.description = description;
        this.context = context;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI targetUrl() {
        return this.targetUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty
    @Nullable
    public String context() {
        return this.context;
    }

    public final ImmutableRepositoryCreateStatus withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableRepositoryCreateStatus(value, this.targetUrl, this.description, this.context);
    }

    public final ImmutableRepositoryCreateStatus withTargetUrl(@Nullable URI value) {
        if (this.targetUrl == value) {
            return this;
        }
        return new ImmutableRepositoryCreateStatus(this.state, value, this.description, this.context);
    }

    public final ImmutableRepositoryCreateStatus withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableRepositoryCreateStatus(this.state, this.targetUrl, value, this.context);
    }

    public final ImmutableRepositoryCreateStatus withContext(@Nullable String value) {
        if (Objects.equals(this.context, value)) {
            return this;
        }
        return new ImmutableRepositoryCreateStatus(this.state, this.targetUrl, this.description, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryCreateStatus && this.equalTo(0, (ImmutableRepositoryCreateStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryCreateStatus another) {
        return Objects.equals(this.state, another.state) && Objects.equals(this.targetUrl, another.targetUrl) && Objects.equals(this.description, another.description) && Objects.equals(this.context, another.context);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.targetUrl);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.context);
        return h;
    }

    public String toString() {
        return "RepositoryCreateStatus{state=" + this.state + ", targetUrl=" + String.valueOf(this.targetUrl) + ", description=" + this.description + ", context=" + this.context + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryCreateStatus fromJson(Json json) {
        Builder builder = ImmutableRepositoryCreateStatus.builder();
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.targetUrl != null) {
            builder.targetUrl(json.targetUrl);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.context != null) {
            builder.context(json.context);
        }
        return builder.build();
    }

    public static ImmutableRepositoryCreateStatus copyOf(RepositoryCreateStatus instance) {
        if (instance instanceof ImmutableRepositoryCreateStatus) {
            return (ImmutableRepositoryCreateStatus)instance;
        }
        return ImmutableRepositoryCreateStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryCreateStatus", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String state;
        @Nullable
        private URI targetUrl;
        @Nullable
        private String description;
        @Nullable
        private String context;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryCreateStatus instance) {
            String contextValue;
            String descriptionValue;
            URI targetUrlValue;
            Objects.requireNonNull(instance, "instance");
            String stateValue = instance.state();
            if (stateValue != null) {
                this.state(stateValue);
            }
            if ((targetUrlValue = instance.targetUrl()) != null) {
                this.targetUrl(targetUrlValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            if ((contextValue = instance.context()) != null) {
                this.context(contextValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder targetUrl(@Nullable URI targetUrl) {
            this.targetUrl = targetUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder context(@Nullable String context) {
            this.context = context;
            return this;
        }

        public ImmutableRepositoryCreateStatus build() {
            return new ImmutableRepositoryCreateStatus(this.state, this.targetUrl, this.description, this.context);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryCreateStatus", generator="Immutables")
    static final class Json
    implements RepositoryCreateStatus {
        @Nullable
        String state;
        @Nullable
        URI targetUrl;
        @Nullable
        String description;
        @Nullable
        String context;

        Json() {
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTargetUrl(@Nullable URI targetUrl) {
            this.targetUrl = targetUrl;
        }

        @JsonProperty
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty
        public void setContext(@Nullable String context) {
            this.context = context;
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI targetUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String context() {
            throw new UnsupportedOperationException();
        }
    }
}

