/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.search.Search;
import com.spotify.github.v3.search.SearchIssue;
import com.spotify.github.v3.search.SearchIssues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SearchIssues", generator="Immutables")
@Immutable
public final class ImmutableSearchIssues
implements SearchIssues {
    @Nullable
    private final Integer totalCount;
    @Nullable
    private final Boolean incompleteResults;
    @Nullable
    private final List<SearchIssue> items;

    private ImmutableSearchIssues(@Nullable Integer totalCount, @Nullable Boolean incompleteResults, @Nullable List<SearchIssue> items) {
        this.totalCount = totalCount;
        this.incompleteResults = incompleteResults;
        this.items = items;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean incompleteResults() {
        return this.incompleteResults;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<SearchIssue> items() {
        return this.items;
    }

    public final ImmutableSearchIssues withTotalCount(@Nullable Integer value) {
        if (Objects.equals(this.totalCount, value)) {
            return this;
        }
        return new ImmutableSearchIssues(value, this.incompleteResults, this.items);
    }

    public final ImmutableSearchIssues withIncompleteResults(@Nullable Boolean value) {
        if (Objects.equals(this.incompleteResults, value)) {
            return this;
        }
        return new ImmutableSearchIssues(this.totalCount, value, this.items);
    }

    public final ImmutableSearchIssues withItems(SearchIssue ... elements) {
        if (elements == null) {
            return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, null);
        }
        List<SearchIssue> newValue = Arrays.asList(elements) == null ? null : ImmutableSearchIssues.createUnmodifiableList(false, ImmutableSearchIssues.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, newValue);
    }

    public final ImmutableSearchIssues withItems(@Nullable Iterable<? extends SearchIssue> elements) {
        if (this.items == elements) {
            return this;
        }
        List<SearchIssue> newValue = elements == null ? null : ImmutableSearchIssues.createUnmodifiableList(false, ImmutableSearchIssues.createSafeList(elements, true, false));
        return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchIssues && this.equalTo(0, (ImmutableSearchIssues)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchIssues another) {
        return Objects.equals(this.totalCount, another.totalCount) && Objects.equals(this.incompleteResults, another.incompleteResults) && Objects.equals(this.items, another.items);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.totalCount);
        h += (h << 5) + Objects.hashCode(this.incompleteResults);
        h += (h << 5) + Objects.hashCode(this.items);
        return h;
    }

    public String toString() {
        return "SearchIssues{totalCount=" + this.totalCount + ", incompleteResults=" + this.incompleteResults + ", items=" + String.valueOf(this.items) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSearchIssues fromJson(Json json) {
        Builder builder = ImmutableSearchIssues.builder();
        if (json.totalCount != null) {
            builder.totalCount(json.totalCount);
        }
        if (json.incompleteResults != null) {
            builder.incompleteResults(json.incompleteResults);
        }
        if (json.items != null) {
            builder.addAllItems(json.items);
        }
        return builder.build();
    }

    public static ImmutableSearchIssues copyOf(SearchIssues instance) {
        if (instance instanceof ImmutableSearchIssues) {
            return (ImmutableSearchIssues)instance;
        }
        return ImmutableSearchIssues.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SearchIssues", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer totalCount;
        @Nullable
        private Boolean incompleteResults;
        private List<SearchIssue> items = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Search instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SearchIssues instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Boolean incompleteResultsValue;
            Integer totalCountValue;
            Search instance;
            long bits = 0L;
            if (object instanceof Search) {
                instance = (Search)object;
                if ((bits & 2L) == 0L) {
                    totalCountValue = instance.totalCount();
                    if (totalCountValue != null) {
                        this.totalCount(totalCountValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    incompleteResultsValue = instance.incompleteResults();
                    if (incompleteResultsValue != null) {
                        this.incompleteResults(incompleteResultsValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SearchIssues) {
                List<SearchIssue> itemsValue;
                instance = (SearchIssues)object;
                if ((bits & 2L) == 0L) {
                    totalCountValue = instance.totalCount();
                    if (totalCountValue != null) {
                        this.totalCount(totalCountValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    incompleteResultsValue = instance.incompleteResults();
                    if (incompleteResultsValue != null) {
                        this.incompleteResults(incompleteResultsValue);
                    }
                    bits |= 1L;
                }
                if ((itemsValue = instance.items()) != null) {
                    this.addAllItems(itemsValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(@Nullable Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder incompleteResults(@Nullable Boolean incompleteResults) {
            this.incompleteResults = incompleteResults;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(SearchIssue element) {
            if (this.items == null) {
                this.items = new ArrayList<SearchIssue>();
            }
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(SearchIssue ... elements) {
            if (this.items == null) {
                this.items = new ArrayList<SearchIssue>();
            }
            for (SearchIssue element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder items(@Nullable Iterable<? extends SearchIssue> elements) {
            if (elements == null) {
                this.items = null;
                return this;
            }
            this.items = new ArrayList<SearchIssue>();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<? extends SearchIssue> elements) {
            Objects.requireNonNull(elements, "items element");
            if (this.items == null) {
                this.items = new ArrayList<SearchIssue>();
            }
            for (SearchIssue searchIssue : elements) {
                this.items.add(Objects.requireNonNull(searchIssue, "items element"));
            }
            return this;
        }

        public ImmutableSearchIssues build() {
            return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, this.items == null ? null : ImmutableSearchIssues.createUnmodifiableList(true, this.items));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SearchIssues", generator="Immutables")
    static final class Json
    implements SearchIssues {
        @Nullable
        Integer totalCount;
        @Nullable
        Boolean incompleteResults;
        @Nullable
        List<SearchIssue> items = null;

        Json() {
        }

        @JsonProperty
        public void setTotalCount(@Nullable Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty
        public void setIncompleteResults(@Nullable Boolean incompleteResults) {
            this.incompleteResults = incompleteResults;
        }

        @JsonProperty
        public void setItems(@Nullable List<SearchIssue> items) {
            this.items = items;
        }

        @Override
        public Integer totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean incompleteResults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SearchIssue> items() {
            throw new UnsupportedOperationException();
        }
    }
}

