/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http;

import com.spotify.github.http.HttpRequest;
import com.spotify.github.http.HttpResponse;
import java.util.List;
import java.util.Map;

public abstract class BaseHttpResponse
implements HttpResponse {
    private static final int HTTP_OK = 200;
    private static final int HTTP_BAD_REQUEST = 400;
    protected final HttpRequest request;
    protected final int statusCode;
    protected final String statusMessage;
    protected final Map<String, List<String>> headers;

    public BaseHttpResponse(HttpRequest request, int statusCode, String statusMessage, Map<String, List<String>> headers) {
        this.request = request;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = headers;
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public List<String> headers(String headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public String header(String headerName) {
        List<String> headerValues = this.headers(headerName);
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        if (headerValues.size() == 1) {
            return headerValues.get(0);
        }
        return String.join((CharSequence)",", headerValues);
    }

    @Override
    public boolean isSuccessful() {
        return this.statusCode() >= 200 && this.statusCode() < 400;
    }
}

