/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.tracing.opentelemetry;

import com.spotify.github.http.HttpRequest;
import com.spotify.github.tracing.BaseTracer;
import com.spotify.github.tracing.Span;
import com.spotify.github.tracing.opentelemetry.OpenTelemetrySpan;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenTelemetryTracer
extends BaseTracer {
    private final Tracer tracer;
    private final OpenTelemetry openTelemetry;

    public OpenTelemetryTracer(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.tracer = openTelemetry.getTracer("github-java-client");
    }

    public OpenTelemetryTracer() {
        this(GlobalOpenTelemetry.get());
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Override
    protected Span internalSpan(String path, String method, CompletionStage<?> future) {
        Objects.requireNonNull(path);
        Context context = Context.current();
        io.opentelemetry.api.trace.Span otSpan = this.tracer.spanBuilder("GitHub Request").setParent(context).setSpanKind(SpanKind.CLIENT).startSpan();
        otSpan.setAttribute("component", "github-api-client");
        otSpan.setAttribute("peer.service", "github");
        otSpan.setAttribute("http.url", path);
        otSpan.setAttribute("method", method);
        OpenTelemetrySpan span = new OpenTelemetrySpan(otSpan);
        if (future == null) {
            return span;
        }
        this.attachSpanToFuture(span, future);
        return span;
    }

    @Override
    protected Span internalSpan(HttpRequest request, CompletionStage<?> future) {
        Objects.requireNonNull(request);
        Context context = W3CTraceContextPropagator.getInstance().extract(Context.current(), (Object)request, (TextMapGetter)new TextMapGetter<HttpRequest>(){

            public Iterable<String> keys(@NotNull HttpRequest carrier) {
                return carrier.headers().keySet();
            }

            @Nullable
            public String get(@Nullable HttpRequest carrier, @NotNull String key) {
                if (carrier == null) {
                    return null;
                }
                return carrier.header(key);
            }
        });
        context.makeCurrent();
        return this.internalSpan(request.url(), request.method(), future);
    }
}

