/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BaseEvent", generator="Immutables")
@Immutable
public final class ImmutableBaseEvent
implements BaseEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;

    private ImmutableBaseEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    public final ImmutableBaseEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableBaseEvent(value, this.sender, this.eventInstallation);
    }

    public final ImmutableBaseEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableBaseEvent(this.repository, value, this.eventInstallation);
    }

    public final ImmutableBaseEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableBaseEvent(this.repository, this.sender, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseEvent && this.equalTo(0, (ImmutableBaseEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        return h;
    }

    public String toString() {
        return "BaseEvent{repository=" + String.valueOf(this.repository) + ", sender=" + String.valueOf(this.sender) + ", eventInstallation=" + String.valueOf(this.eventInstallation) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBaseEvent fromJson(Json json) {
        Builder builder = ImmutableBaseEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        return builder.build();
    }

    public static ImmutableBaseEvent copyOf(BaseEvent instance) {
        if (instance instanceof ImmutableBaseEvent) {
            return (ImmutableBaseEvent)instance;
        }
        return ImmutableBaseEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BaseEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            EventInstallation eventInstallationValue;
            User senderValue;
            Objects.requireNonNull(instance, "instance");
            Repository repositoryValue = instance.repository();
            if (repositoryValue != null) {
                this.repository(repositoryValue);
            }
            if ((senderValue = instance.sender()) != null) {
                this.sender(senderValue);
            }
            if ((eventInstallationValue = instance.eventInstallation()) != null) {
                this.eventInstallation(eventInstallationValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        public ImmutableBaseEvent build() {
            return new ImmutableBaseEvent(this.repository, this.sender, this.eventInstallation);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BaseEvent", generator="Immutables")
    static final class Json
    implements BaseEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }
    }
}

