/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.CheckRunEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.checks.CheckRunResponse;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunEvent", generator="Immutables")
@Immutable
public final class ImmutableCheckRunEvent
implements CheckRunEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final String action;
    @Nullable
    private final CheckRunResponse checkRun;

    private ImmutableCheckRunEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable String action, @Nullable CheckRunResponse checkRun) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.action = action;
        this.checkRun = checkRun;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public CheckRunResponse checkRun() {
        return this.checkRun;
    }

    public final ImmutableCheckRunEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableCheckRunEvent(value, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.action, this.checkRun);
    }

    public final ImmutableCheckRunEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableCheckRunEvent(this.repository, value, this.eventInstallation, this.createdAt, this.updatedAt, this.action, this.checkRun);
    }

    public final ImmutableCheckRunEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableCheckRunEvent(this.repository, this.sender, value, this.createdAt, this.updatedAt, this.action, this.checkRun);
    }

    public final ImmutableCheckRunEvent withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableCheckRunEvent(this.repository, this.sender, this.eventInstallation, value, this.updatedAt, this.action, this.checkRun);
    }

    public final ImmutableCheckRunEvent withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableCheckRunEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, value, this.action, this.checkRun);
    }

    public final ImmutableCheckRunEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableCheckRunEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, value, this.checkRun);
    }

    public final ImmutableCheckRunEvent withCheckRun(@Nullable CheckRunResponse value) {
        if (this.checkRun == value) {
            return this;
        }
        return new ImmutableCheckRunEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.action, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunEvent && this.equalTo(0, (ImmutableCheckRunEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckRunEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.action, another.action) && Objects.equals(this.checkRun, another.checkRun);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.checkRun);
        return h;
    }

    public String toString() {
        return "CheckRunEvent{repository=" + String.valueOf(this.repository) + ", sender=" + String.valueOf(this.sender) + ", eventInstallation=" + String.valueOf(this.eventInstallation) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", action=" + this.action + ", checkRun=" + String.valueOf(this.checkRun) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunEvent fromJson(Json json) {
        Builder builder = ImmutableCheckRunEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.checkRun != null) {
            builder.checkRun(json.checkRun);
        }
        return builder.build();
    }

    public static ImmutableCheckRunEvent copyOf(CheckRunEvent instance) {
        if (instance instanceof ImmutableCheckRunEvent) {
            return (ImmutableCheckRunEvent)instance;
        }
        return ImmutableCheckRunEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckRunEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private String action;
        @Nullable
        private CheckRunResponse checkRun;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            User senderValue;
            EventInstallation eventInstallationValue;
            GitHubInstant createdAtValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CheckRunEvent) {
                CheckRunResponse checkRunValue;
                String actionValue;
                instance = (CheckRunEvent)object;
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 4L;
                }
                if ((actionValue = instance.action()) != null) {
                    this.action(actionValue);
                }
                if ((checkRunValue = instance.checkRun()) != null) {
                    this.checkRun(checkRunValue);
                }
                if ((bits & 8L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    GitHubInstant updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 8L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    GitHubInstant updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x10L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder checkRun(@Nullable CheckRunResponse checkRun) {
            this.checkRun = checkRun;
            return this;
        }

        public ImmutableCheckRunEvent build() {
            return new ImmutableCheckRunEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.action, this.checkRun);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunEvent", generator="Immutables")
    static final class Json
    implements CheckRunEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        String action;
        @Nullable
        CheckRunResponse checkRun;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setCheckRun(@Nullable CheckRunResponse checkRun) {
            this.checkRun = checkRun;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CheckRunResponse checkRun() {
            throw new UnsupportedOperationException();
        }
    }
}

