/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.CommitCommentEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitCommentEvent", generator="Immutables")
@Immutable
public final class ImmutableCommitCommentEvent
implements CommitCommentEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Comment comment;

    private ImmutableCommitCommentEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Comment comment) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.comment = comment;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public Comment comment() {
        return this.comment;
    }

    public final ImmutableCommitCommentEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableCommitCommentEvent(value, this.sender, this.eventInstallation, this.action, this.comment);
    }

    public final ImmutableCommitCommentEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableCommitCommentEvent(this.repository, value, this.eventInstallation, this.action, this.comment);
    }

    public final ImmutableCommitCommentEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableCommitCommentEvent(this.repository, this.sender, value, this.action, this.comment);
    }

    public final ImmutableCommitCommentEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableCommitCommentEvent(this.repository, this.sender, this.eventInstallation, value, this.comment);
    }

    public final ImmutableCommitCommentEvent withComment(@Nullable Comment value) {
        if (this.comment == value) {
            return this;
        }
        return new ImmutableCommitCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitCommentEvent && this.equalTo(0, (ImmutableCommitCommentEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitCommentEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.comment, another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.comment);
        return h;
    }

    public String toString() {
        return "CommitCommentEvent{repository=" + String.valueOf(this.repository) + ", sender=" + String.valueOf(this.sender) + ", eventInstallation=" + String.valueOf(this.eventInstallation) + ", action=" + this.action + ", comment=" + String.valueOf(this.comment) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitCommentEvent fromJson(Json json) {
        Builder builder = ImmutableCommitCommentEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.comment != null) {
            builder.comment(json.comment);
        }
        return builder.build();
    }

    public static ImmutableCommitCommentEvent copyOf(CommitCommentEvent instance) {
        if (instance instanceof ImmutableCommitCommentEvent) {
            return (ImmutableCommitCommentEvent)instance;
        }
        return ImmutableCommitCommentEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitCommentEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Comment comment;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitCommentEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof CommitCommentEvent) {
                Comment commentValue;
                instance = (CommitCommentEvent)object;
                String actionValue = instance.action();
                if (actionValue != null) {
                    this.action(actionValue);
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((commentValue = instance.comment()) != null) {
                    this.comment(commentValue);
                }
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comment(@Nullable Comment comment) {
            this.comment = comment;
            return this;
        }

        public ImmutableCommitCommentEvent build() {
            return new ImmutableCommitCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.comment);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitCommentEvent", generator="Immutables")
    static final class Json
    implements CommitCommentEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Comment comment;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setComment(@Nullable Comment comment) {
            this.comment = comment;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comment comment() {
            throw new UnsupportedOperationException();
        }
    }
}

