/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.CheckSuite;
import com.spotify.github.v3.checks.CheckSuiteResponseList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckSuiteResponseList", generator="Immutables")
@Immutable
public final class ImmutableCheckSuiteResponseList
implements CheckSuiteResponseList {
    private final int totalCount;
    private final List<CheckSuite> checkSuites;

    private ImmutableCheckSuiteResponseList(int totalCount, List<CheckSuite> checkSuites) {
        this.totalCount = totalCount;
        this.checkSuites = checkSuites;
    }

    @Override
    @JsonProperty
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    public List<CheckSuite> checkSuites() {
        return this.checkSuites;
    }

    public final ImmutableCheckSuiteResponseList withTotalCount(int value) {
        if (this.totalCount == value) {
            return this;
        }
        return new ImmutableCheckSuiteResponseList(value, this.checkSuites);
    }

    public final ImmutableCheckSuiteResponseList withCheckSuites(CheckSuite ... elements) {
        List<CheckSuite> newValue = ImmutableCheckSuiteResponseList.createUnmodifiableList(false, ImmutableCheckSuiteResponseList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCheckSuiteResponseList(this.totalCount, newValue);
    }

    public final ImmutableCheckSuiteResponseList withCheckSuites(Iterable<? extends CheckSuite> elements) {
        if (this.checkSuites == elements) {
            return this;
        }
        List<CheckSuite> newValue = ImmutableCheckSuiteResponseList.createUnmodifiableList(false, ImmutableCheckSuiteResponseList.createSafeList(elements, true, false));
        return new ImmutableCheckSuiteResponseList(this.totalCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckSuiteResponseList && this.equalTo(0, (ImmutableCheckSuiteResponseList)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckSuiteResponseList another) {
        return this.totalCount == another.totalCount && this.checkSuites.equals(another.checkSuites);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.totalCount;
        h += (h << 5) + this.checkSuites.hashCode();
        return h;
    }

    public String toString() {
        return "CheckSuiteResponseList{totalCount=" + this.totalCount + ", checkSuites=" + String.valueOf(this.checkSuites) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckSuiteResponseList fromJson(Json json) {
        Builder builder = ImmutableCheckSuiteResponseList.builder();
        if (json.totalCountIsSet) {
            builder.totalCount(json.totalCount);
        }
        if (json.checkSuites != null) {
            builder.addAllCheckSuites(json.checkSuites);
        }
        return builder.build();
    }

    public static ImmutableCheckSuiteResponseList copyOf(CheckSuiteResponseList instance) {
        if (instance instanceof ImmutableCheckSuiteResponseList) {
            return (ImmutableCheckSuiteResponseList)instance;
        }
        return ImmutableCheckSuiteResponseList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckSuiteResponseList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_COUNT = 1L;
        private long initBits = 1L;
        private int totalCount;
        private List<CheckSuite> checkSuites = new ArrayList<CheckSuite>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckSuiteResponseList instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalCount(instance.totalCount());
            this.addAllCheckSuites(instance.checkSuites());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(int totalCount) {
            this.totalCount = totalCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCheckSuites(CheckSuite element) {
            this.checkSuites.add(Objects.requireNonNull(element, "checkSuites element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCheckSuites(CheckSuite ... elements) {
            for (CheckSuite element : elements) {
                this.checkSuites.add(Objects.requireNonNull(element, "checkSuites element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder checkSuites(Iterable<? extends CheckSuite> elements) {
            this.checkSuites.clear();
            return this.addAllCheckSuites(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCheckSuites(Iterable<? extends CheckSuite> elements) {
            for (CheckSuite checkSuite : elements) {
                this.checkSuites.add(Objects.requireNonNull(checkSuite, "checkSuites element"));
            }
            return this;
        }

        public ImmutableCheckSuiteResponseList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckSuiteResponseList(this.totalCount, ImmutableCheckSuiteResponseList.createUnmodifiableList(true, this.checkSuites));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalCount");
            }
            return "Cannot build CheckSuiteResponseList, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckSuiteResponseList", generator="Immutables")
    static final class Json
    implements CheckSuiteResponseList {
        int totalCount;
        boolean totalCountIsSet;
        @Nullable
        List<CheckSuite> checkSuites = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
            this.totalCountIsSet = true;
        }

        @JsonProperty
        public void setCheckSuites(List<CheckSuite> checkSuites) {
            this.checkSuites = checkSuites;
        }

        @Override
        public int totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CheckSuite> checkSuites() {
            throw new UnsupportedOperationException();
        }
    }
}

