/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.spotify.github.async.Async;
import com.spotify.github.http.HttpClient;
import com.spotify.github.http.HttpRequest;
import com.spotify.github.http.HttpResponse;
import com.spotify.github.http.ImmutableHttpRequest;
import com.spotify.github.http.okhttp.OkHttpHttpClient;
import com.spotify.github.jackson.Json;
import com.spotify.github.tracing.NoopTracer;
import com.spotify.github.tracing.Tracer;
import com.spotify.github.v3.Team;
import com.spotify.github.v3.User;
import com.spotify.github.v3.checks.AccessToken;
import com.spotify.github.v3.checks.Installation;
import com.spotify.github.v3.clients.ChecksClient;
import com.spotify.github.v3.clients.GitDataClient;
import com.spotify.github.v3.clients.JwtTokenIssuer;
import com.spotify.github.v3.clients.OrganisationClient;
import com.spotify.github.v3.clients.RepositoryClient;
import com.spotify.github.v3.clients.SearchClient;
import com.spotify.github.v3.clients.UserClient;
import com.spotify.github.v3.comment.CommentReaction;
import com.spotify.github.v3.exceptions.ReadOnlyRepositoryException;
import com.spotify.github.v3.exceptions.RequestNotOkException;
import com.spotify.github.v3.git.FileItem;
import com.spotify.github.v3.git.Reference;
import com.spotify.github.v3.orgs.TeamInvitation;
import com.spotify.github.v3.prs.Comment;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.Review;
import com.spotify.github.v3.prs.ReviewRequests;
import com.spotify.github.v3.repos.Branch;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.github.v3.repos.FolderContent;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.repos.RepositoryInvitation;
import com.spotify.github.v3.repos.Status;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubClient {
    private static final int EXPIRY_MARGIN_IN_MINUTES = 5;
    private static final int HTTP_NOT_FOUND = 404;
    private Tracer tracer = NoopTracer.INSTANCE;
    static final Consumer<HttpResponse> IGNORE_RESPONSE_CONSUMER = response -> {
        if (response != null) {
            response.close();
        }
    };
    static final TypeReference<List<com.spotify.github.v3.comment.Comment>> LIST_COMMENT_TYPE_REFERENCE = new TypeReference<List<com.spotify.github.v3.comment.Comment>>(){};
    static final TypeReference<List<CommentReaction>> LIST_COMMENT_REACTION_TYPE_REFERENCE = new TypeReference<List<CommentReaction>>(){};
    static final TypeReference<List<Repository>> LIST_REPOSITORY = new TypeReference<List<Repository>>(){};
    static final TypeReference<List<CommitItem>> LIST_COMMIT_TYPE_REFERENCE = new TypeReference<List<CommitItem>>(){};
    static final TypeReference<List<Review>> LIST_REVIEW_TYPE_REFERENCE = new TypeReference<List<Review>>(){};
    static final TypeReference<ReviewRequests> LIST_REVIEW_REQUEST_TYPE_REFERENCE = new TypeReference<ReviewRequests>(){};
    static final TypeReference<List<Status>> LIST_STATUS_TYPE_REFERENCE = new TypeReference<List<Status>>(){};
    static final TypeReference<List<FolderContent>> LIST_FOLDERCONTENT_TYPE_REFERENCE = new TypeReference<List<FolderContent>>(){};
    static final TypeReference<List<PullRequestItem>> LIST_PR_TYPE_REFERENCE = new TypeReference<List<PullRequestItem>>(){};
    static final TypeReference<List<Comment>> LIST_PR_COMMENT_TYPE_REFERENCE = new TypeReference<List<Comment>>(){};
    static final TypeReference<List<Branch>> LIST_BRANCHES = new TypeReference<List<Branch>>(){};
    static final TypeReference<List<Reference>> LIST_REFERENCES = new TypeReference<List<Reference>>(){};
    static final TypeReference<List<RepositoryInvitation>> LIST_REPOSITORY_INVITATION = new TypeReference<List<RepositoryInvitation>>(){};
    static final TypeReference<List<Team>> LIST_TEAMS = new TypeReference<List<Team>>(){};
    static final TypeReference<List<User>> LIST_TEAM_MEMBERS = new TypeReference<List<User>>(){};
    static final TypeReference<List<TeamInvitation>> LIST_PENDING_TEAM_INVITATIONS = new TypeReference<List<TeamInvitation>>(){};
    static final TypeReference<List<FileItem>> LIST_FILE_ITEMS = new TypeReference<List<FileItem>>(){};
    private static final String GET_ACCESS_TOKEN_URL = "app/installations/%s/access_tokens";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int PERMANENT_REDIRECT = 301;
    private static final int TEMPORARY_REDIRECT = 307;
    private static final int FORBIDDEN = 403;
    private final URI baseUrl;
    private final Optional<URI> graphqlUrl;
    private final Json json = Json.create();
    private final HttpClient client;
    private Call.Factory callFactory;
    private final String token;
    private final byte[] privateKey;
    private final Integer appId;
    private final Integer installationId;
    private final Map<Integer, AccessToken> installationTokens;

    private GitHubClient(HttpClient client, URI baseUrl, URI graphqlUrl, String accessToken, byte[] privateKey, Integer appId, Integer installationId) {
        this.baseUrl = baseUrl;
        this.graphqlUrl = Optional.ofNullable(graphqlUrl);
        this.token = accessToken;
        this.client = client;
        this.privateKey = privateKey;
        this.appId = appId;
        this.installationId = installationId;
        this.installationTokens = new ConcurrentHashMap<Integer, AccessToken>();
    }

    private GitHubClient(OkHttpClient client, URI baseUrl, URI graphqlUrl, String accessToken, byte[] privateKey, Integer appId, Integer installationId) {
        this.baseUrl = baseUrl;
        this.graphqlUrl = Optional.ofNullable(graphqlUrl);
        this.token = accessToken;
        this.client = new OkHttpHttpClient(client);
        this.privateKey = privateKey;
        this.appId = appId;
        this.installationId = installationId;
        this.installationTokens = new ConcurrentHashMap<Integer, AccessToken>();
    }

    public static GitHubClient create(URI baseUrl, String token) {
        return new GitHubClient(new OkHttpClient(), baseUrl, null, token, null, null, null);
    }

    public static GitHubClient create(URI baseUrl, URI graphqlUri, String token) {
        return new GitHubClient(new OkHttpClient(), baseUrl, graphqlUri, token, null, null, null);
    }

    public static GitHubClient create(URI baseUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(new OkHttpClient(), baseUrl, null, privateKey, appId, null);
    }

    public static GitHubClient create(URI baseUrl, byte[] privateKey, Integer appId) {
        return new GitHubClient(new OkHttpClient(), baseUrl, null, null, privateKey, appId, null);
    }

    public static GitHubClient create(URI baseUrl, File privateKey, Integer appId, Integer installationId) {
        return GitHubClient.createOrThrow(new OkHttpClient(), baseUrl, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(URI baseUrl, byte[] privateKey, Integer appId, Integer installationId) {
        return new GitHubClient(new OkHttpClient(), baseUrl, null, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, null, privateKey, appId, null);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, URI graphqlUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, graphqlUrl, privateKey, appId, null);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, byte[] privateKey, Integer appId) {
        return new GitHubClient(httpClient, baseUrl, null, null, privateKey, appId, null);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, File privateKey, Integer appId, Integer installationId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, byte[] privateKey, Integer appId, Integer installationId) {
        return new GitHubClient(httpClient, baseUrl, null, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, String token) {
        return new GitHubClient(httpClient, baseUrl, null, token, null, null, null);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, URI graphqlUrl, String token) {
        return new GitHubClient(httpClient, baseUrl, graphqlUrl, token, null, null, null);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, null, privateKey, appId, null);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, URI graphqlUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, graphqlUrl, privateKey, appId, null);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, byte[] privateKey, Integer appId) {
        return new GitHubClient(httpClient, baseUrl, null, null, privateKey, appId, null);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, File privateKey, Integer appId, Integer installationId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, byte[] privateKey, Integer appId, Integer installationId) {
        return new GitHubClient(httpClient, baseUrl, null, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, String token) {
        return new GitHubClient(httpClient, baseUrl, null, token, null, null, null);
    }

    public static GitHubClient create(HttpClient httpClient, URI baseUrl, URI graphqlUrl, String token) {
        return new GitHubClient(httpClient, baseUrl, graphqlUrl, token, null, null, null);
    }

    public static GitHubClient scopeForInstallationId(GitHubClient client, int installationId) {
        if (client.getPrivateKey().isEmpty()) {
            throw new RuntimeException("Installation ID scoped client needs a private key");
        }
        return new GitHubClient(client.client, client.baseUrl, null, null, client.getPrivateKey().get(), client.appId, (Integer)installationId);
    }

    public GitHubClient withScopeForInstallationId(int installationId) {
        if (Optional.ofNullable(this.privateKey).isEmpty()) {
            throw new RuntimeException("Installation ID scoped client needs a private key");
        }
        return new GitHubClient(this.client, this.baseUrl, (URI)this.graphqlUrl.orElse(null), null, this.privateKey, this.appId, (Integer)installationId);
    }

    public CompletionStage<Optional<GitHubClient>> asAppScopedClient(String owner) {
        return ((CompletableFuture)Async.exceptionallyCompose(this.createOrganisationClient(owner).createGithubAppClient().getInstallation().thenApply(Installation::id), e -> {
            if (e.getCause() instanceof RequestNotOkException && ((RequestNotOkException)e.getCause()).statusCode() == 404) {
                return this.createUserClient(owner).createGithubAppClient().getUserInstallation().thenApply(Installation::id);
            }
            return CompletableFuture.failedFuture(e);
        }).thenApply(id -> Optional.of(this.withScopeForInstallationId((int)id)))).exceptionally(e -> {
            if (e.getCause() instanceof RequestNotOkException && ((RequestNotOkException)e.getCause()).statusCode() == 404) {
                return Optional.empty();
            }
            throw new RuntimeException((Throwable)e);
        });
    }

    public GitHubClient withTracer(Tracer tracer) {
        this.tracer = tracer;
        this.client.setTracer(tracer);
        return this;
    }

    public Optional<byte[]> getPrivateKey() {
        return Optional.ofNullable(this.privateKey);
    }

    public Optional<String> getAccessToken() {
        return Optional.ofNullable(this.token);
    }

    public RepositoryClient createRepositoryClient(String owner, String repo) {
        return RepositoryClient.create(this, owner, repo);
    }

    public GitDataClient createGitDataClient(String owner, String repo) {
        return GitDataClient.create(this, owner, repo);
    }

    public SearchClient createSearchClient() {
        return SearchClient.create(this);
    }

    public ChecksClient createChecksClient(String owner, String repo) {
        return ChecksClient.create(this, owner, repo);
    }

    public OrganisationClient createOrganisationClient(String org) {
        return OrganisationClient.create(this, org);
    }

    public UserClient createUserClient(String owner) {
        return UserClient.create(this, owner);
    }

    Json json() {
        return this.json;
    }

    CompletableFuture<HttpResponse> request(String path) {
        return this.call("GET", path);
    }

    CompletableFuture<HttpResponse> request(String path, Map<String, String> extraHeaders) {
        return this.call("GET", path, extraHeaders);
    }

    <T> CompletableFuture<T> request(String path, Class<T> clazz) {
        return this.call(path).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    <T> CompletableFuture<T> request(String path, Class<T> clazz, Map<String, String> extraHeaders) {
        return this.call("GET", path, null, extraHeaders).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    <T> CompletableFuture<T> request(String path, TypeReference<T> typeReference, Map<String, String> extraHeaders) {
        return this.call("GET", path, null, extraHeaders).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), typeReference));
    }

    <T> CompletableFuture<T> request(String path, TypeReference<T> typeReference) {
        return this.call(path).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), typeReference));
    }

    CompletableFuture<HttpResponse> post(String path, String data) {
        return this.call("POST", path, data);
    }

    CompletableFuture<HttpResponse> post(String path, String data, Map<String, String> extraHeaders) {
        return this.call("POST", path, data, extraHeaders);
    }

    <T> CompletableFuture<T> post(String path, String data, Class<T> clazz, Map<String, String> extraHeaders) {
        return this.post(path, data, extraHeaders).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    <T> CompletableFuture<T> post(String path, String data, Class<T> clazz) {
        return this.post(path, data).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    public CompletableFuture<HttpResponse> postGraphql(String data) {
        return this.graphqlRequestBuilder().thenCompose(requestBuilder -> {
            ImmutableHttpRequest request = requestBuilder.method("POST").body(data).build();
            log.info("Making POST request to {}", (Object)request.url());
            return this.call(request);
        });
    }

    CompletableFuture<HttpResponse> put(String path, String data) {
        return this.call("PUT", path, data);
    }

    <T> CompletableFuture<T> put(String path, String data, Class<T> clazz) {
        return this.put(path, data).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    CompletableFuture<HttpResponse> patch(String path, String data) {
        return this.call("PATCH", path, data);
    }

    <T> CompletableFuture<T> patch(String path, String data, Class<T> clazz) {
        return this.patch(path, data).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    <T> CompletableFuture<T> patch(String path, String data, Class<T> clazz, Map<String, String> extraHeaders) {
        return this.call("PATCH", path, data, extraHeaders).thenApply(response -> this.json().fromJsonUncheckedNotNull(response.bodyString(), clazz));
    }

    CompletableFuture<HttpResponse> delete(String path) {
        return this.call("DELETE", path);
    }

    CompletableFuture<HttpResponse> delete(String path, String data) {
        return this.call("DELETE", path, data);
    }

    private CompletableFuture<HttpResponse> call(String path) {
        return this.call("GET", path, null, null);
    }

    private CompletableFuture<HttpResponse> call(String method, String path) {
        return this.call(method, path, null, null);
    }

    private CompletableFuture<HttpResponse> call(String method, String path, Map<String, String> extraHeaders) {
        return this.call(method, path, null, extraHeaders);
    }

    private CompletableFuture<HttpResponse> call(String method, String path, String data) {
        return this.call(method, path, data, null);
    }

    private CompletableFuture<HttpResponse> call(String method, String path, @Nullable String data, @Nullable Map<String, String> extraHeaders) {
        return this.requestBuilder(path).thenCompose(requestBuilder -> {
            ImmutableHttpRequest.Builder builder = requestBuilder.method(method);
            if (data != null) {
                builder.body(data);
            }
            ImmutableHttpRequest request = extraHeaders == null || extraHeaders.isEmpty() ? builder.build() : this.toHttpRequestHeaders(builder, extraHeaders).build();
            log.debug("Making {} request to {}", (Object)method, (Object)request.url().toString());
            return this.call(request);
        });
    }

    String urlFor(String path) {
        return this.baseUrl.toString().replaceAll("/+$", "") + "/" + path.replaceAll("^/+", "");
    }

    private ImmutableHttpRequest.Builder toHttpRequestHeaders(ImmutableHttpRequest.Builder builder, Map<String, String> extraHeaders) {
        ImmutableHttpRequest request = builder.build();
        extraHeaders.forEach((headerKey, headerValue) -> {
            if (request.headers().containsKey(headerKey)) {
                ArrayList<String> headers = new ArrayList<String>((Collection)request.headers().get(headerKey));
                headers.add((String)headerValue);
                builder.putHeaders((String)headerKey, (List<String>)headers);
            } else {
                builder.putHeaders((String)headerKey, List.of(headerValue));
            }
        });
        return builder;
    }

    private CompletableFuture<ImmutableHttpRequest.Builder> graphqlRequestBuilder() {
        URI url = this.graphqlUrl.orElseThrow(() -> new IllegalStateException("No graphql url set"));
        return this.requestBuilder("/graphql").thenApply(requestBuilder -> requestBuilder.url(url.toString()));
    }

    private CompletableFuture<ImmutableHttpRequest.Builder> requestBuilder(String path) {
        return this.getAuthorizationHeader(path).thenApply(authHeader -> ImmutableHttpRequest.builder().url(this.urlFor(path)).method("GET").body("").putHeaders("Accept", List.of("application/json")).putHeaders("Content-Type", List.of("application/json")).putHeaders("Authorization", List.of(authHeader)));
    }

    public boolean isGraphqlEnabled() {
        return this.graphqlUrl.isPresent();
    }

    private CompletableFuture<String> getAuthorizationHeader(String path) {
        if (this.isJwtRequest(path) && this.getPrivateKey().isEmpty()) {
            throw new IllegalStateException("This endpoint needs a client with a private key for an App");
        }
        if (this.getAccessToken().isPresent()) {
            return CompletableFuture.completedFuture(String.format("token %s", this.token));
        }
        if (this.getPrivateKey().isPresent()) {
            String jwtToken;
            try {
                jwtToken = JwtTokenIssuer.fromPrivateKey(this.privateKey).getToken(this.appId);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an error generating JWT token", e);
            }
            if (this.isJwtRequest(path)) {
                return CompletableFuture.completedFuture(String.format("Bearer %s", jwtToken));
            }
            if (this.installationId == null) {
                throw new RuntimeException("This endpoint needs a client with an installation ID");
            }
            try {
                return ((CompletableFuture)this.getInstallationToken(jwtToken, this.installationId).thenApply(token -> String.format("token %s", token))).exceptionally(ex -> {
                    throw new RuntimeException("Could not generate access token for github app", (Throwable)ex);
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate access token for github app", e);
            }
        }
        throw new RuntimeException("Not possible to authenticate. ");
    }

    private boolean isJwtRequest(String path) {
        return path.startsWith("/app/installation") || path.endsWith("installation");
    }

    private CompletableFuture<String> getInstallationToken(String jwtToken, int installationId) {
        AccessToken installationToken = this.installationTokens.get(installationId);
        if (installationToken == null || this.isExpired(installationToken)) {
            log.info("GitHub token for installation {} is either expired or null. Trying to get a new one.", (Object)installationId);
            return this.generateInstallationToken(jwtToken, installationId).thenApply(accessToken -> {
                this.installationTokens.put(installationId, (AccessToken)accessToken);
                return accessToken.token();
            });
        }
        return CompletableFuture.completedFuture(installationToken.token());
    }

    private boolean isExpired(AccessToken token) {
        return token.expiresAt().isBefore(ZonedDateTime.now().plusMinutes(5L));
    }

    private CompletableFuture<AccessToken> generateInstallationToken(String jwtToken, int installationId) {
        log.info("Got JWT Token. Now getting GitHub access_token for installation {}", (Object)installationId);
        String url = String.format(this.urlFor(GET_ACCESS_TOKEN_URL), installationId);
        ImmutableHttpRequest request = ImmutableHttpRequest.builder().url(url).putHeaders("Accept", List.of("application/vnd.github.machine-man-preview+json")).putHeaders("Authorization", List.of("Bearer " + jwtToken)).method("POST").body("").build();
        return ((CompletableFuture)this.client.send(request).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw new RuntimeException(String.format("Got non-2xx status %s when getting an access token from GitHub: %s", response.statusCode(), response.statusMessage()));
            }
            if (response.bodyString() == null) {
                throw new RuntimeException(String.format("Got empty response body when getting an access token from GitHub, HTTP status was: %s", response.statusMessage()));
            }
            String text = response.bodyString();
            try {
                return Json.create().fromJson(text, AccessToken.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).toCompletableFuture();
    }

    private CompletableFuture<HttpResponse> call(HttpRequest httpRequest) {
        return this.client.send(httpRequest).thenCompose(httpResponse -> this.handleResponse(httpRequest, (HttpResponse)httpResponse));
    }

    private CompletableFuture<HttpResponse> handleResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        AtomicBoolean redirected = new AtomicBoolean(false);
        ((CompletableFuture)this.processPossibleRedirects(httpResponse, redirected).handle((res, ex) -> {
            if (Objects.nonNull(ex)) {
                future.completeExceptionally((Throwable)ex);
            } else if (!res.isSuccessful()) {
                try {
                    future.completeExceptionally(this.mapException(httpRequest, (HttpResponse)res));
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            } else {
                future.complete((HttpResponse)res);
            }
            return res;
        })).join();
        return future;
    }

    private RequestNotOkException mapException(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        String bodyString = Optional.ofNullable(httpResponse.bodyString()).orElse("");
        Map<String, List<String>> headersMap = httpResponse.headers();
        if (httpResponse.statusCode() == 403 && bodyString.contains("Repository was archived so is read-only")) {
            return new ReadOnlyRepositoryException(httpRequest.method(), URI.create(httpRequest.url()).getPath(), httpResponse.statusCode(), bodyString, headersMap);
        }
        return new RequestNotOkException(httpRequest.method(), URI.create(httpRequest.url()).getPath(), httpResponse.statusCode(), bodyString, headersMap);
    }

    CompletableFuture<HttpResponse> processPossibleRedirects(HttpResponse response, AtomicBoolean redirected) {
        if (response.statusCode() >= 301 && response.statusCode() <= 307 && !redirected.get()) {
            redirected.set(true);
            String newLocation = response.headers().get("Location").get(0);
            return this.requestBuilder(newLocation).thenCompose(requestBuilder -> {
                ImmutableHttpRequest request = requestBuilder.url(newLocation).method(response.request().method()).body(response.request().body()).build();
                return this.call(request);
            });
        }
        return CompletableFuture.completedFuture(response);
    }

    private static GitHubClient createOrThrow(OkHttpClient httpClient, URI baseUrl, URI graphqlUrl, File privateKey, Integer appId, Integer installationId) {
        try {
            return new GitHubClient(httpClient, baseUrl, graphqlUrl, null, FileUtils.readFileToByteArray((File)privateKey), appId, installationId);
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error generating JWT token", e);
        }
    }

    private static GitHubClient createOrThrow(HttpClient httpClient, URI baseUrl, URI graphqlUrl, File privateKey, Integer appId, Integer installationId) {
        try {
            return new GitHubClient(httpClient, baseUrl, graphqlUrl, null, FileUtils.readFileToByteArray((File)privateKey), appId, installationId);
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error generating JWT token", e);
        }
    }
}

