/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.collect.ImmutableMap;
import com.spotify.github.async.AsyncPage;
import com.spotify.github.http.HttpResponse;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubPage;
import com.spotify.github.v3.clients.GithubPageIterator;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.comment.CommentReaction;
import com.spotify.github.v3.comment.CommentReactionContent;
import com.spotify.github.v3.issues.Issue;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueClient {
    static final String COMMENTS_URI_NUMBER_TEMPLATE = "/repos/%s/%s/issues/%s/comments";
    static final String COMMENTS_URI_TEMPLATE = "/repos/%s/%s/issues/comments";
    static final String COMMENTS_URI_ID_TEMPLATE = "/repos/%s/%s/issues/comments/%s";
    static final String COMMENTS_REACTION_TEMPLATE = "/repos/%s/%s/issues/comments/%s/reactions";
    static final String COMMENTS_REACTION_ID_TEMPLATE = "/repos/%s/%s/issues/%s/reactions/%s";
    static final String ISSUES_URI_ID_TEMPLATE = "/repos/%s/%s/issues/%s";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GitHubClient github;
    private final String owner;
    private final String repo;

    IssueClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static IssueClient create(GitHubClient github, String owner, String repo) {
        return new IssueClient(github, owner, repo);
    }

    public Iterator<AsyncPage<Comment>> listComments() {
        return this.listComments(String.format(COMMENTS_URI_TEMPLATE, this.owner, this.repo));
    }

    public Iterator<AsyncPage<Comment>> listComments(long issueNumber) {
        return this.listComments(String.format(COMMENTS_URI_NUMBER_TEMPLATE, this.owner, this.repo, issueNumber));
    }

    @Deprecated
    public Iterator<AsyncPage<Comment>> listComments(int issueNumber) {
        return this.listComments((long)issueNumber);
    }

    public CompletableFuture<Comment> getComment(long commentId) {
        String path = String.format(COMMENTS_URI_ID_TEMPLATE, this.owner, this.repo, commentId);
        log.info("Fetching issue comments from " + path);
        return this.github.request(path, Comment.class);
    }

    @Deprecated
    public CompletableFuture<Comment> getComment(int commentId) {
        return this.getComment((long)commentId);
    }

    public CompletableFuture<Comment> createComment(long issueNumber, String body) {
        String path = String.format(COMMENTS_URI_NUMBER_TEMPLATE, this.owner, this.repo, issueNumber);
        String requestBody = this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"body", (Object)body));
        return this.github.post(path, requestBody, Comment.class);
    }

    @Deprecated
    public CompletableFuture<Comment> createComment(int issueNumber, String body) {
        return this.createComment((long)issueNumber, body);
    }

    public CompletableFuture<Void> editComment(long commentId, String body) {
        String path = String.format(COMMENTS_URI_ID_TEMPLATE, this.owner, this.repo, commentId);
        return this.github.patch(path, this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"body", (Object)body))).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    @Deprecated
    public CompletableFuture<Void> editComment(int commentId, String body) {
        return this.editComment((long)commentId, body);
    }

    public CompletableFuture<Void> deleteComment(long commentId) {
        return this.github.delete(String.format(COMMENTS_URI_ID_TEMPLATE, this.owner, this.repo, commentId)).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    @Deprecated
    public CompletableFuture<Void> deleteComment(int commentId) {
        return this.deleteComment((long)commentId);
    }

    private Iterator<AsyncPage<Comment>> listComments(String path) {
        return new GithubPageIterator<Comment>(new GithubPage<Comment>(this.github, path, GitHubClient.LIST_COMMENT_TYPE_REFERENCE));
    }

    public CompletableFuture<Issue> getIssue(long issueId) {
        return this.github.request(String.format(ISSUES_URI_ID_TEMPLATE, this.owner, this.repo, issueId), Issue.class);
    }

    @Deprecated
    public CompletableFuture<Issue> getIssue(int issueId) {
        return this.getIssue((long)issueId);
    }

    public CompletableFuture<CommentReaction> createCommentReaction(long commentId, CommentReactionContent reaction) {
        String path = String.format(COMMENTS_REACTION_TEMPLATE, this.owner, this.repo, commentId);
        String requestBody = this.github.json().toJsonUnchecked(ImmutableMap.of((Object)"content", (Object)reaction.toString()));
        return this.github.post(path, requestBody, CommentReaction.class);
    }

    public CompletableFuture<HttpResponse> deleteCommentReaction(long issueNumber, long reactionId) {
        String path = String.format(COMMENTS_REACTION_ID_TEMPLATE, this.owner, this.repo, issueNumber, reactionId);
        return this.github.delete(path);
    }

    public GithubPageIterator<CommentReaction> listCommentReaction(long commentId) {
        String path = String.format(COMMENTS_REACTION_TEMPLATE, this.owner, this.repo, commentId);
        return new GithubPageIterator<CommentReaction>(new GithubPage<CommentReaction>(this.github, path, GitHubClient.LIST_COMMENT_REACTION_TYPE_REFERENCE));
    }
}

