/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubAppClient;
import com.spotify.github.v3.user.requests.SuspensionReason;
import java.util.concurrent.CompletableFuture;

public class UserClient {
    public static final int NO_CONTENT = 204;
    private final GitHubClient github;
    private final String owner;
    private static final String SUSPEND_USER_TEMPLATE = "/users/%s/suspended";

    UserClient(GitHubClient github, String owner) {
        this.github = github;
        this.owner = owner;
    }

    static UserClient create(GitHubClient github, String owner) {
        return new UserClient(github, owner);
    }

    public GithubAppClient createGithubAppClient() {
        return new GithubAppClient(this.github, this.owner);
    }

    public CompletableFuture<Boolean> suspendUser(String username, SuspensionReason reason) {
        String path = String.format(SUSPEND_USER_TEMPLATE, username);
        return this.github.put(path, this.github.json().toJsonUnchecked(reason)).thenApply(resp -> resp.statusCode() == 204);
    }

    public CompletableFuture<Boolean> unSuspendUser(String username, SuspensionReason reason) {
        String path = String.format(SUSPEND_USER_TEMPLATE, username);
        return this.github.delete(path, this.github.json().toJsonUnchecked(reason)).thenApply(resp -> resp.statusCode() == 204);
    }
}

