/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.issues.Label;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Label", generator="Immutables")
@Immutable
public final class ImmutableLabel
implements Label {
    private final Long id;
    @Nullable
    private final String nodeId;
    @Nullable
    private final URI url;
    @Nullable
    private final String name;
    @Nullable
    private final String color;
    @Nullable
    private final String description;
    private final boolean isDefault;

    private ImmutableLabel(Long id, @Nullable String nodeId, @Nullable URI url, @Nullable String name, @Nullable String color, @Nullable String description, boolean isDefault) {
        this.id = id;
        this.nodeId = nodeId;
        this.url = url;
        this.name = name;
        this.color = color;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    @JsonProperty
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String color() {
        return this.color;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="default")
    public boolean isDefault() {
        return this.isDefault;
    }

    public final ImmutableLabel withId(Long value) {
        Long newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableLabel(newValue, this.nodeId, this.url, this.name, this.color, this.description, this.isDefault);
    }

    public final ImmutableLabel withNodeId(@Nullable String value) {
        if (Objects.equals(this.nodeId, value)) {
            return this;
        }
        return new ImmutableLabel(this.id, value, this.url, this.name, this.color, this.description, this.isDefault);
    }

    public final ImmutableLabel withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableLabel(this.id, this.nodeId, value, this.name, this.color, this.description, this.isDefault);
    }

    public final ImmutableLabel withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableLabel(this.id, this.nodeId, this.url, value, this.color, this.description, this.isDefault);
    }

    public final ImmutableLabel withColor(@Nullable String value) {
        if (Objects.equals(this.color, value)) {
            return this;
        }
        return new ImmutableLabel(this.id, this.nodeId, this.url, this.name, value, this.description, this.isDefault);
    }

    public final ImmutableLabel withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableLabel(this.id, this.nodeId, this.url, this.name, this.color, value, this.isDefault);
    }

    public final ImmutableLabel withIsDefault(boolean value) {
        if (this.isDefault == value) {
            return this;
        }
        return new ImmutableLabel(this.id, this.nodeId, this.url, this.name, this.color, this.description, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabel && this.equalTo(0, (ImmutableLabel)another);
    }

    private boolean equalTo(int synthetic, ImmutableLabel another) {
        return this.id.equals(another.id) && Objects.equals(this.nodeId, another.nodeId) && Objects.equals(this.url, another.url) && Objects.equals(this.name, another.name) && Objects.equals(this.color, another.color) && Objects.equals(this.description, another.description) && this.isDefault == another.isDefault;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.nodeId);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.color);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Boolean.hashCode(this.isDefault);
        return h;
    }

    public String toString() {
        return "Label{id=" + this.id + ", nodeId=" + this.nodeId + ", url=" + String.valueOf(this.url) + ", name=" + this.name + ", color=" + this.color + ", description=" + this.description + ", isDefault=" + this.isDefault + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLabel fromJson(Json json) {
        Builder builder = ImmutableLabel.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.color != null) {
            builder.color(json.color);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.isDefaultIsSet) {
            builder.isDefault(json.isDefault);
        }
        return builder.build();
    }

    public static ImmutableLabel copyOf(Label instance) {
        if (instance instanceof ImmutableLabel) {
            return (ImmutableLabel)instance;
        }
        return ImmutableLabel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Label", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IS_DEFAULT = 2L;
        private long initBits = 3L;
        @Nullable
        private Long id;
        @Nullable
        private String nodeId;
        @Nullable
        private URI url;
        @Nullable
        private String name;
        @Nullable
        private String color;
        @Nullable
        private String description;
        private boolean isDefault;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Label instance) {
            String descriptionValue;
            String colorValue;
            String nameValue;
            URI urlValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            String nodeIdValue = instance.nodeId();
            if (nodeIdValue != null) {
                this.nodeId(nodeIdValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((nameValue = instance.name()) != null) {
                this.name(nameValue);
            }
            if ((colorValue = instance.color()) != null) {
                this.color(colorValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            this.isDefault(instance.isDefault());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Long id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder color(@Nullable String color) {
            this.color = color;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="default")
        @CanIgnoreReturnValue
        public final Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLabel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLabel(this.id, this.nodeId, this.url, this.name, this.color, this.description, this.isDefault);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isDefault");
            }
            return "Cannot build Label, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Label", generator="Immutables")
    static final class Json
    implements Label {
        @Nullable
        Long id;
        @Nullable
        String nodeId;
        @Nullable
        URI url;
        @Nullable
        String name;
        @Nullable
        String color;
        @Nullable
        String description;
        boolean isDefault;
        boolean isDefaultIsSet;

        Json() {
        }

        @JsonProperty
        public void setId(Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setNodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setColor(@Nullable String color) {
            this.color = color;
        }

        @JsonProperty
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="default")
        public void setIsDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.isDefaultIsSet = true;
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String color() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }
    }
}

