/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.orgs.requests.TeamRepoPermissionUpdate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TeamRepoPermissionUpdate", generator="Immutables")
@Immutable
public final class ImmutableTeamRepoPermissionUpdate
implements TeamRepoPermissionUpdate {
    private final String org;
    private final String repo;
    private final String teamSlug;
    private final String permission;

    private ImmutableTeamRepoPermissionUpdate(String org, String repo, String teamSlug, String permission) {
        this.org = org;
        this.repo = repo;
        this.teamSlug = teamSlug;
        this.permission = permission;
    }

    @Override
    @JsonProperty
    public String org() {
        return this.org;
    }

    @Override
    @JsonProperty
    public String repo() {
        return this.repo;
    }

    @Override
    @JsonProperty
    public String teamSlug() {
        return this.teamSlug;
    }

    @Override
    @JsonProperty
    public String permission() {
        return this.permission;
    }

    public final ImmutableTeamRepoPermissionUpdate withOrg(String value) {
        String newValue = Objects.requireNonNull(value, "org");
        if (this.org.equals(newValue)) {
            return this;
        }
        return new ImmutableTeamRepoPermissionUpdate(newValue, this.repo, this.teamSlug, this.permission);
    }

    public final ImmutableTeamRepoPermissionUpdate withRepo(String value) {
        String newValue = Objects.requireNonNull(value, "repo");
        if (this.repo.equals(newValue)) {
            return this;
        }
        return new ImmutableTeamRepoPermissionUpdate(this.org, newValue, this.teamSlug, this.permission);
    }

    public final ImmutableTeamRepoPermissionUpdate withTeamSlug(String value) {
        String newValue = Objects.requireNonNull(value, "teamSlug");
        if (this.teamSlug.equals(newValue)) {
            return this;
        }
        return new ImmutableTeamRepoPermissionUpdate(this.org, this.repo, newValue, this.permission);
    }

    public final ImmutableTeamRepoPermissionUpdate withPermission(String value) {
        String newValue = Objects.requireNonNull(value, "permission");
        if (this.permission.equals(newValue)) {
            return this;
        }
        return new ImmutableTeamRepoPermissionUpdate(this.org, this.repo, this.teamSlug, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTeamRepoPermissionUpdate && this.equalTo(0, (ImmutableTeamRepoPermissionUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableTeamRepoPermissionUpdate another) {
        return this.org.equals(another.org) && this.repo.equals(another.repo) && this.teamSlug.equals(another.teamSlug) && this.permission.equals(another.permission);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.org.hashCode();
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.teamSlug.hashCode();
        h += (h << 5) + this.permission.hashCode();
        return h;
    }

    public String toString() {
        return "TeamRepoPermissionUpdate{org=" + this.org + ", repo=" + this.repo + ", teamSlug=" + this.teamSlug + ", permission=" + this.permission + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTeamRepoPermissionUpdate fromJson(Json json) {
        Builder builder = ImmutableTeamRepoPermissionUpdate.builder();
        if (json.org != null) {
            builder.org(json.org);
        }
        if (json.repo != null) {
            builder.repo(json.repo);
        }
        if (json.teamSlug != null) {
            builder.teamSlug(json.teamSlug);
        }
        if (json.permission != null) {
            builder.permission(json.permission);
        }
        return builder.build();
    }

    public static ImmutableTeamRepoPermissionUpdate copyOf(TeamRepoPermissionUpdate instance) {
        if (instance instanceof ImmutableTeamRepoPermissionUpdate) {
            return (ImmutableTeamRepoPermissionUpdate)instance;
        }
        return ImmutableTeamRepoPermissionUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TeamRepoPermissionUpdate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ORG = 1L;
        private static final long INIT_BIT_REPO = 2L;
        private static final long INIT_BIT_TEAM_SLUG = 4L;
        private static final long INIT_BIT_PERMISSION = 8L;
        private long initBits = 15L;
        @Nullable
        private String org;
        @Nullable
        private String repo;
        @Nullable
        private String teamSlug;
        @Nullable
        private String permission;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TeamRepoPermissionUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.org(instance.org());
            this.repo(instance.repo());
            this.teamSlug(instance.teamSlug());
            this.permission(instance.permission());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder org(String org) {
            this.org = Objects.requireNonNull(org, "org");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repo(String repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder teamSlug(String teamSlug) {
            this.teamSlug = Objects.requireNonNull(teamSlug, "teamSlug");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder permission(String permission) {
            this.permission = Objects.requireNonNull(permission, "permission");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTeamRepoPermissionUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTeamRepoPermissionUpdate(this.org, this.repo, this.teamSlug, this.permission);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("org");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("teamSlug");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("permission");
            }
            return "Cannot build TeamRepoPermissionUpdate, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TeamRepoPermissionUpdate", generator="Immutables")
    static final class Json
    implements TeamRepoPermissionUpdate {
        @Nullable
        String org;
        @Nullable
        String repo;
        @Nullable
        String teamSlug;
        @Nullable
        String permission;

        Json() {
        }

        @JsonProperty
        public void setOrg(String org) {
            this.org = org;
        }

        @JsonProperty
        public void setRepo(String repo) {
            this.repo = repo;
        }

        @JsonProperty
        public void setTeamSlug(String teamSlug) {
            this.teamSlug = teamSlug;
        }

        @JsonProperty
        public void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public String org() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String repo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String teamSlug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String permission() {
            throw new UnsupportedOperationException();
        }
    }
}

