/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.AutoMerge;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AutoMerge", generator="Immutables")
@Immutable
public final class ImmutableAutoMerge
implements AutoMerge {
    private final User enabledBy;
    private final String mergeMethod;
    @Nullable
    private final String commitTitle;
    @Nullable
    private final String commitMessage;

    private ImmutableAutoMerge(User enabledBy, String mergeMethod, @Nullable String commitTitle, @Nullable String commitMessage) {
        this.enabledBy = enabledBy;
        this.mergeMethod = mergeMethod;
        this.commitTitle = commitTitle;
        this.commitMessage = commitMessage;
    }

    @Override
    @JsonProperty
    public User enabledBy() {
        return this.enabledBy;
    }

    @Override
    @JsonProperty
    public String mergeMethod() {
        return this.mergeMethod;
    }

    @Override
    @JsonProperty
    @Nullable
    public String commitTitle() {
        return this.commitTitle;
    }

    @Override
    @JsonProperty
    @Nullable
    public String commitMessage() {
        return this.commitMessage;
    }

    public final ImmutableAutoMerge withEnabledBy(User value) {
        if (this.enabledBy == value) {
            return this;
        }
        User newValue = Objects.requireNonNull(value, "enabledBy");
        return new ImmutableAutoMerge(newValue, this.mergeMethod, this.commitTitle, this.commitMessage);
    }

    public final ImmutableAutoMerge withMergeMethod(String value) {
        String newValue = Objects.requireNonNull(value, "mergeMethod");
        if (this.mergeMethod.equals(newValue)) {
            return this;
        }
        return new ImmutableAutoMerge(this.enabledBy, newValue, this.commitTitle, this.commitMessage);
    }

    public final ImmutableAutoMerge withCommitTitle(@Nullable String value) {
        if (Objects.equals(this.commitTitle, value)) {
            return this;
        }
        return new ImmutableAutoMerge(this.enabledBy, this.mergeMethod, value, this.commitMessage);
    }

    public final ImmutableAutoMerge withCommitMessage(@Nullable String value) {
        if (Objects.equals(this.commitMessage, value)) {
            return this;
        }
        return new ImmutableAutoMerge(this.enabledBy, this.mergeMethod, this.commitTitle, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAutoMerge && this.equalTo(0, (ImmutableAutoMerge)another);
    }

    private boolean equalTo(int synthetic, ImmutableAutoMerge another) {
        return this.enabledBy.equals(another.enabledBy) && this.mergeMethod.equals(another.mergeMethod) && Objects.equals(this.commitTitle, another.commitTitle) && Objects.equals(this.commitMessage, another.commitMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.enabledBy.hashCode();
        h += (h << 5) + this.mergeMethod.hashCode();
        h += (h << 5) + Objects.hashCode(this.commitTitle);
        h += (h << 5) + Objects.hashCode(this.commitMessage);
        return h;
    }

    public String toString() {
        return "AutoMerge{enabledBy=" + String.valueOf(this.enabledBy) + ", mergeMethod=" + this.mergeMethod + ", commitTitle=" + this.commitTitle + ", commitMessage=" + this.commitMessage + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAutoMerge fromJson(Json json) {
        Builder builder = ImmutableAutoMerge.builder();
        if (json.enabledBy != null) {
            builder.enabledBy(json.enabledBy);
        }
        if (json.mergeMethod != null) {
            builder.mergeMethod(json.mergeMethod);
        }
        if (json.commitTitle != null) {
            builder.commitTitle(json.commitTitle);
        }
        if (json.commitMessage != null) {
            builder.commitMessage(json.commitMessage);
        }
        return builder.build();
    }

    public static ImmutableAutoMerge copyOf(AutoMerge instance) {
        if (instance instanceof ImmutableAutoMerge) {
            return (ImmutableAutoMerge)instance;
        }
        return ImmutableAutoMerge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AutoMerge", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENABLED_BY = 1L;
        private static final long INIT_BIT_MERGE_METHOD = 2L;
        private long initBits = 3L;
        @Nullable
        private User enabledBy;
        @Nullable
        private String mergeMethod;
        @Nullable
        private String commitTitle;
        @Nullable
        private String commitMessage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AutoMerge instance) {
            String commitMessageValue;
            Objects.requireNonNull(instance, "instance");
            this.enabledBy(instance.enabledBy());
            this.mergeMethod(instance.mergeMethod());
            String commitTitleValue = instance.commitTitle();
            if (commitTitleValue != null) {
                this.commitTitle(commitTitleValue);
            }
            if ((commitMessageValue = instance.commitMessage()) != null) {
                this.commitMessage(commitMessageValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder enabledBy(User enabledBy) {
            this.enabledBy = Objects.requireNonNull(enabledBy, "enabledBy");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeMethod(String mergeMethod) {
            this.mergeMethod = Objects.requireNonNull(mergeMethod, "mergeMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitTitle(@Nullable String commitTitle) {
            this.commitTitle = commitTitle;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitMessage(@Nullable String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public ImmutableAutoMerge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAutoMerge(this.enabledBy, this.mergeMethod, this.commitTitle, this.commitMessage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabledBy");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mergeMethod");
            }
            return "Cannot build AutoMerge, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AutoMerge", generator="Immutables")
    static final class Json
    implements AutoMerge {
        @Nullable
        User enabledBy;
        @Nullable
        String mergeMethod;
        @Nullable
        String commitTitle;
        @Nullable
        String commitMessage;

        Json() {
        }

        @JsonProperty
        public void setEnabledBy(User enabledBy) {
            this.enabledBy = enabledBy;
        }

        @JsonProperty
        public void setMergeMethod(String mergeMethod) {
            this.mergeMethod = mergeMethod;
        }

        @JsonProperty
        public void setCommitTitle(@Nullable String commitTitle) {
            this.commitTitle = commitTitle;
        }

        @JsonProperty
        public void setCommitMessage(@Nullable String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public User enabledBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mergeMethod() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String commitTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String commitMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

