/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.MergeMethod;
import com.spotify.github.v3.prs.MergeParameters;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeParameters", generator="Immutables")
@Immutable
public final class ImmutableMergeParameters
extends MergeParameters {
    private final String sha;
    @Nullable
    private final String commitMessage;
    @Nullable
    private final String commitTitle;
    private final MergeMethod mergeMethod;

    private ImmutableMergeParameters(Builder builder) {
        this.sha = builder.sha;
        this.commitMessage = builder.commitMessage;
        this.commitTitle = builder.commitTitle;
        this.mergeMethod = builder.mergeMethod != null ? builder.mergeMethod : Objects.requireNonNull(super.mergeMethod(), "mergeMethod");
    }

    private ImmutableMergeParameters(String sha, @Nullable String commitMessage, @Nullable String commitTitle, MergeMethod mergeMethod) {
        this.sha = sha;
        this.commitMessage = commitMessage;
        this.commitTitle = commitTitle;
        this.mergeMethod = mergeMethod;
    }

    @Override
    @JsonProperty
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    public Optional<String> commitMessage() {
        return Optional.ofNullable(this.commitMessage);
    }

    @Override
    @JsonProperty
    public Optional<String> commitTitle() {
        return Optional.ofNullable(this.commitTitle);
    }

    @Override
    @JsonProperty
    public MergeMethod mergeMethod() {
        return this.mergeMethod;
    }

    public final ImmutableMergeParameters withSha(String value) {
        String newValue = Objects.requireNonNull(value, "sha");
        if (this.sha.equals(newValue)) {
            return this;
        }
        return new ImmutableMergeParameters(newValue, this.commitMessage, this.commitTitle, this.mergeMethod);
    }

    public final ImmutableMergeParameters withCommitMessage(String value) {
        String newValue = Objects.requireNonNull(value, "commitMessage");
        if (Objects.equals(this.commitMessage, newValue)) {
            return this;
        }
        return new ImmutableMergeParameters(this.sha, newValue, this.commitTitle, this.mergeMethod);
    }

    public final ImmutableMergeParameters withCommitMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commitMessage, value)) {
            return this;
        }
        return new ImmutableMergeParameters(this.sha, value, this.commitTitle, this.mergeMethod);
    }

    public final ImmutableMergeParameters withCommitTitle(String value) {
        String newValue = Objects.requireNonNull(value, "commitTitle");
        if (Objects.equals(this.commitTitle, newValue)) {
            return this;
        }
        return new ImmutableMergeParameters(this.sha, this.commitMessage, newValue, this.mergeMethod);
    }

    public final ImmutableMergeParameters withCommitTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commitTitle, value)) {
            return this;
        }
        return new ImmutableMergeParameters(this.sha, this.commitMessage, value, this.mergeMethod);
    }

    public final ImmutableMergeParameters withMergeMethod(MergeMethod value) {
        MergeMethod newValue = Objects.requireNonNull(value, "mergeMethod");
        if (this.mergeMethod == newValue) {
            return this;
        }
        return new ImmutableMergeParameters(this.sha, this.commitMessage, this.commitTitle, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeParameters && this.equalTo(0, (ImmutableMergeParameters)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeParameters another) {
        return this.sha.equals(another.sha) && Objects.equals(this.commitMessage, another.commitMessage) && Objects.equals(this.commitTitle, another.commitTitle) && this.mergeMethod.equals((Object)another.mergeMethod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sha.hashCode();
        h += (h << 5) + Objects.hashCode(this.commitMessage);
        h += (h << 5) + Objects.hashCode(this.commitTitle);
        h += (h << 5) + this.mergeMethod.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MergeParameters{");
        builder.append("sha=").append(this.sha);
        if (this.commitMessage != null) {
            builder.append(", ");
            builder.append("commitMessage=").append(this.commitMessage);
        }
        if (this.commitTitle != null) {
            builder.append(", ");
            builder.append("commitTitle=").append(this.commitTitle);
        }
        builder.append(", ");
        builder.append("mergeMethod=").append((Object)this.mergeMethod);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergeParameters fromJson(Json json) {
        Builder builder = ImmutableMergeParameters.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.commitMessage != null) {
            builder.commitMessage(json.commitMessage);
        }
        if (json.commitTitle != null) {
            builder.commitTitle(json.commitTitle);
        }
        if (json.mergeMethod != null) {
            builder.mergeMethod(json.mergeMethod);
        }
        return builder.build();
    }

    public static ImmutableMergeParameters copyOf(MergeParameters instance) {
        if (instance instanceof ImmutableMergeParameters) {
            return (ImmutableMergeParameters)instance;
        }
        return ImmutableMergeParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SHA = 1L;
        private long initBits = 1L;
        @Nullable
        private String sha;
        @Nullable
        private String commitMessage;
        @Nullable
        private String commitTitle;
        @Nullable
        private MergeMethod mergeMethod;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeParameters instance) {
            Optional<String> commitTitleOptional;
            Objects.requireNonNull(instance, "instance");
            this.sha(instance.sha());
            Optional<String> commitMessageOptional = instance.commitMessage();
            if (commitMessageOptional.isPresent()) {
                this.commitMessage(commitMessageOptional);
            }
            if ((commitTitleOptional = instance.commitTitle()).isPresent()) {
                this.commitTitle(commitTitleOptional);
            }
            this.mergeMethod(instance.mergeMethod());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(String sha) {
            this.sha = Objects.requireNonNull(sha, "sha");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = Objects.requireNonNull(commitMessage, "commitMessage");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitMessage(Optional<String> commitMessage) {
            this.commitMessage = commitMessage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitTitle(String commitTitle) {
            this.commitTitle = Objects.requireNonNull(commitTitle, "commitTitle");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitTitle(Optional<String> commitTitle) {
            this.commitTitle = commitTitle.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeMethod(MergeMethod mergeMethod) {
            this.mergeMethod = Objects.requireNonNull(mergeMethod, "mergeMethod");
            return this;
        }

        public ImmutableMergeParameters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeParameters(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sha");
            }
            return "Cannot build MergeParameters, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MergeParameters", generator="Immutables")
    static final class Json
    extends MergeParameters {
        @Nullable
        String sha;
        @Nullable
        Optional<String> commitMessage = Optional.empty();
        @Nullable
        Optional<String> commitTitle = Optional.empty();
        @Nullable
        MergeMethod mergeMethod;

        Json() {
        }

        @JsonProperty
        public void setSha(String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setCommitMessage(Optional<String> commitMessage) {
            this.commitMessage = commitMessage;
        }

        @JsonProperty
        public void setCommitTitle(Optional<String> commitTitle) {
            this.commitTitle = commitTitle;
        }

        @JsonProperty
        public void setMergeMethod(MergeMethod mergeMethod) {
            this.mergeMethod = mergeMethod;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> commitMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> commitTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MergeMethod mergeMethod() {
            throw new UnsupportedOperationException();
        }
    }
}

