/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.PartialPullRequestItem;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.PullRequestLinks;
import com.spotify.github.v3.prs.PullRequestRef;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestItem", generator="Immutables")
@Immutable
public final class ImmutablePullRequestItem
implements PullRequestItem {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final GitHubInstant closedAt;
    @Nullable
    private final Long id;
    @Nullable
    private final URI url;
    @Nullable
    private final Long number;
    @Nullable
    private final PullRequestRef head;
    @Nullable
    private final PullRequestRef base;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI diffUrl;
    @Nullable
    private final URI patchUrl;
    @Nullable
    private final URI issueUrl;
    @Nullable
    private final URI commitsUrl;
    @Nullable
    private final String state;
    @Nullable
    private final String title;
    @Nullable
    private final String body;
    @Nullable
    private final User assignee;
    @Nullable
    private final List<User> assignees;
    @Nullable
    private final Milestone milestone;
    @Nullable
    private final Boolean locked;
    @Nullable
    private final GitHubInstant mergedAt;
    @Nullable
    private final User user;
    @Nullable
    private final URI statusesUrl;
    @Nullable
    private final URI reviewCommentsUrl;
    @Nullable
    private final String reviewCommentUrl;
    @Nullable
    private final URI commentsUrl;
    @Nullable
    private final PullRequestLinks links;
    @Nullable
    private final List<User> requestedReviewers;
    @Nullable
    private final List<User> requestedTeams;
    @Nullable
    private final String mergeCommitSha;
    @Nullable
    private final String nodeId;

    private ImmutablePullRequestItem(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable GitHubInstant closedAt, @Nullable Long id, @Nullable URI url, @Nullable Long number, @Nullable PullRequestRef head, @Nullable PullRequestRef base, @Nullable URI htmlUrl, @Nullable URI diffUrl, @Nullable URI patchUrl, @Nullable URI issueUrl, @Nullable URI commitsUrl, @Nullable String state, @Nullable String title, @Nullable String body, @Nullable User assignee, @Nullable List<User> assignees, @Nullable Milestone milestone, @Nullable Boolean locked, @Nullable GitHubInstant mergedAt, @Nullable User user, @Nullable URI statusesUrl, @Nullable URI reviewCommentsUrl, @Nullable String reviewCommentUrl, @Nullable URI commentsUrl, @Nullable PullRequestLinks links, @Nullable List<User> requestedReviewers, @Nullable List<User> requestedTeams, @Nullable String mergeCommitSha, @Nullable String nodeId) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.id = id;
        this.url = url;
        this.number = number;
        this.head = head;
        this.base = base;
        this.htmlUrl = htmlUrl;
        this.diffUrl = diffUrl;
        this.patchUrl = patchUrl;
        this.issueUrl = issueUrl;
        this.commitsUrl = commitsUrl;
        this.state = state;
        this.title = title;
        this.body = body;
        this.assignee = assignee;
        this.assignees = assignees;
        this.milestone = milestone;
        this.locked = locked;
        this.mergedAt = mergedAt;
        this.user = user;
        this.statusesUrl = statusesUrl;
        this.reviewCommentsUrl = reviewCommentsUrl;
        this.reviewCommentUrl = reviewCommentUrl;
        this.commentsUrl = commentsUrl;
        this.links = links;
        this.requestedReviewers = requestedReviewers;
        this.requestedTeams = requestedTeams;
        this.mergeCommitSha = mergeCommitSha;
        this.nodeId = nodeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> closedAt() {
        return Optional.ofNullable(this.closedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestRef head() {
        return this.head;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestRef base() {
        return this.base;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI diffUrl() {
        return this.diffUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI patchUrl() {
        return this.patchUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI issueUrl() {
        return this.issueUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commitsUrl() {
        return this.commitsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty
    public Optional<User> assignee() {
        return Optional.ofNullable(this.assignee);
    }

    @Override
    @JsonProperty
    public Optional<List<User>> assignees() {
        return Optional.ofNullable(this.assignees);
    }

    @Override
    @JsonProperty
    public Optional<Milestone> milestone() {
        return Optional.ofNullable(this.milestone);
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean locked() {
        return this.locked;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> mergedAt() {
        return Optional.ofNullable(this.mergedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI statusesUrl() {
        return this.statusesUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI reviewCommentsUrl() {
        return this.reviewCommentsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String reviewCommentUrl() {
        return this.reviewCommentUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commentsUrl() {
        return this.commentsUrl;
    }

    @Override
    @JsonProperty(value="_links")
    @Nullable
    public PullRequestLinks links() {
        return this.links;
    }

    @Override
    @JsonProperty(value="requested_reviewers")
    @Nullable
    public List<User> requestedReviewers() {
        return this.requestedReviewers;
    }

    @Override
    @JsonProperty(value="requested_teams")
    @Nullable
    public List<User> requestedTeams() {
        return this.requestedTeams;
    }

    @Override
    @JsonProperty
    public Optional<String> mergeCommitSha() {
        return Optional.ofNullable(this.mergeCommitSha);
    }

    @Override
    @JsonProperty
    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    public final ImmutablePullRequestItem withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutablePullRequestItem(value, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, value, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withClosedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
        if (this.closedAt == newValue) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, newValue, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withClosedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.closedAt == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, value, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, value, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, value, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withNumber(@Nullable Long value) {
        if (Objects.equals(this.number, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, value, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withHead(@Nullable PullRequestRef value) {
        if (this.head == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, value, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withBase(@Nullable PullRequestRef value) {
        if (this.base == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, value, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, value, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withDiffUrl(@Nullable URI value) {
        if (this.diffUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, value, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withPatchUrl(@Nullable URI value) {
        if (this.patchUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, value, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withIssueUrl(@Nullable URI value) {
        if (this.issueUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, value, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withCommitsUrl(@Nullable URI value) {
        if (this.commitsUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, value, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, value, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, value, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, newValue, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, value, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withAssignee(User value) {
        User newValue = Objects.requireNonNull(value, "assignee");
        if (this.assignee == newValue) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, newValue, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withAssignee(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.assignee == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, value, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withAssignees(List<User> value) {
        List<User> newValue = Objects.requireNonNull(value, "assignees");
        if (this.assignees == newValue) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, newValue, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withAssignees(Optional<? extends List<User>> optional) {
        List value = optional.orElse(null);
        if (this.assignees == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, value, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withMilestone(Milestone value) {
        Milestone newValue = Objects.requireNonNull(value, "milestone");
        if (this.milestone == newValue) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, newValue, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withMilestone(Optional<? extends Milestone> optional) {
        Milestone value = optional.orElse(null);
        if (this.milestone == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, value, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withLocked(@Nullable Boolean value) {
        if (Objects.equals(this.locked, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, value, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withMergedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "mergedAt");
        if (this.mergedAt == newValue) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, newValue, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withMergedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.mergedAt == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, value, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, value, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withStatusesUrl(@Nullable URI value) {
        if (this.statusesUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, value, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withReviewCommentsUrl(@Nullable URI value) {
        if (this.reviewCommentsUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, value, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withReviewCommentUrl(@Nullable String value) {
        if (Objects.equals(this.reviewCommentUrl, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, value, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withCommentsUrl(@Nullable URI value) {
        if (this.commentsUrl == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, value, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withLinks(@Nullable PullRequestLinks value) {
        if (this.links == value) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, value, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withRequestedReviewers(User ... elements) {
        if (elements == null) {
            return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, null, this.requestedTeams, this.mergeCommitSha, this.nodeId);
        }
        List<User> newValue = Arrays.asList(elements) == null ? null : ImmutablePullRequestItem.createUnmodifiableList(false, ImmutablePullRequestItem.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, newValue, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withRequestedReviewers(@Nullable Iterable<? extends User> elements) {
        if (this.requestedReviewers == elements) {
            return this;
        }
        List<User> newValue = elements == null ? null : ImmutablePullRequestItem.createUnmodifiableList(false, ImmutablePullRequestItem.createSafeList(elements, true, false));
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, newValue, this.requestedTeams, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withRequestedTeams(User ... elements) {
        if (elements == null) {
            return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, null, this.mergeCommitSha, this.nodeId);
        }
        List<User> newValue = Arrays.asList(elements) == null ? null : ImmutablePullRequestItem.createUnmodifiableList(false, ImmutablePullRequestItem.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, newValue, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withRequestedTeams(@Nullable Iterable<? extends User> elements) {
        if (this.requestedTeams == elements) {
            return this;
        }
        List<User> newValue = elements == null ? null : ImmutablePullRequestItem.createUnmodifiableList(false, ImmutablePullRequestItem.createSafeList(elements, true, false));
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, newValue, this.mergeCommitSha, this.nodeId);
    }

    public final ImmutablePullRequestItem withMergeCommitSha(String value) {
        String newValue = Objects.requireNonNull(value, "mergeCommitSha");
        if (Objects.equals(this.mergeCommitSha, newValue)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, newValue, this.nodeId);
    }

    public final ImmutablePullRequestItem withMergeCommitSha(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeCommitSha, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, value, this.nodeId);
    }

    public final ImmutablePullRequestItem withNodeId(@Nullable String value) {
        if (Objects.equals(this.nodeId, value)) {
            return this;
        }
        return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestItem && this.equalTo(0, (ImmutablePullRequestItem)another);
    }

    private boolean equalTo(int synthetic, ImmutablePullRequestItem another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.closedAt, another.closedAt) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.number, another.number) && Objects.equals(this.head, another.head) && Objects.equals(this.base, another.base) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.diffUrl, another.diffUrl) && Objects.equals(this.patchUrl, another.patchUrl) && Objects.equals(this.issueUrl, another.issueUrl) && Objects.equals(this.commitsUrl, another.commitsUrl) && Objects.equals(this.state, another.state) && Objects.equals(this.title, another.title) && Objects.equals(this.body, another.body) && Objects.equals(this.assignee, another.assignee) && Objects.equals(this.assignees, another.assignees) && Objects.equals(this.milestone, another.milestone) && Objects.equals(this.locked, another.locked) && Objects.equals(this.mergedAt, another.mergedAt) && Objects.equals(this.user, another.user) && Objects.equals(this.statusesUrl, another.statusesUrl) && Objects.equals(this.reviewCommentsUrl, another.reviewCommentsUrl) && Objects.equals(this.reviewCommentUrl, another.reviewCommentUrl) && Objects.equals(this.commentsUrl, another.commentsUrl) && Objects.equals(this.links, another.links) && Objects.equals(this.requestedReviewers, another.requestedReviewers) && Objects.equals(this.requestedTeams, another.requestedTeams) && Objects.equals(this.mergeCommitSha, another.mergeCommitSha) && Objects.equals(this.nodeId, another.nodeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.closedAt);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.number);
        h += (h << 5) + Objects.hashCode(this.head);
        h += (h << 5) + Objects.hashCode(this.base);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.diffUrl);
        h += (h << 5) + Objects.hashCode(this.patchUrl);
        h += (h << 5) + Objects.hashCode(this.issueUrl);
        h += (h << 5) + Objects.hashCode(this.commitsUrl);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.assignee);
        h += (h << 5) + Objects.hashCode(this.assignees);
        h += (h << 5) + Objects.hashCode(this.milestone);
        h += (h << 5) + Objects.hashCode(this.locked);
        h += (h << 5) + Objects.hashCode(this.mergedAt);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.statusesUrl);
        h += (h << 5) + Objects.hashCode(this.reviewCommentsUrl);
        h += (h << 5) + Objects.hashCode(this.reviewCommentUrl);
        h += (h << 5) + Objects.hashCode(this.commentsUrl);
        h += (h << 5) + Objects.hashCode(this.links);
        h += (h << 5) + Objects.hashCode(this.requestedReviewers);
        h += (h << 5) + Objects.hashCode(this.requestedTeams);
        h += (h << 5) + Objects.hashCode(this.mergeCommitSha);
        h += (h << 5) + Objects.hashCode(this.nodeId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PullRequestItem{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.closedAt != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("closedAt=").append(this.closedAt);
        }
        if (this.id != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.url != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.number != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("number=").append(this.number);
        }
        if (this.head != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("head=").append(this.head);
        }
        if (this.base != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("base=").append(this.base);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.diffUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("diffUrl=").append(this.diffUrl);
        }
        if (this.patchUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("patchUrl=").append(this.patchUrl);
        }
        if (this.issueUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("issueUrl=").append(this.issueUrl);
        }
        if (this.commitsUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("commitsUrl=").append(this.commitsUrl);
        }
        if (this.state != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.title != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.body != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.assignee != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("assignee=").append(this.assignee);
        }
        if (this.assignees != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("assignees=").append(this.assignees);
        }
        if (this.milestone != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("milestone=").append(this.milestone);
        }
        if (this.locked != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("locked=").append(this.locked);
        }
        if (this.mergedAt != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("mergedAt=").append(this.mergedAt);
        }
        if (this.user != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("user=").append(this.user);
        }
        if (this.statusesUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("statusesUrl=").append(this.statusesUrl);
        }
        if (this.reviewCommentsUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("reviewCommentsUrl=").append(this.reviewCommentsUrl);
        }
        if (this.reviewCommentUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("reviewCommentUrl=").append(this.reviewCommentUrl);
        }
        if (this.commentsUrl != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("commentsUrl=").append(this.commentsUrl);
        }
        if (this.links != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("links=").append(this.links);
        }
        if (this.requestedReviewers != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("requestedReviewers=").append(this.requestedReviewers);
        }
        if (this.requestedTeams != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("requestedTeams=").append(this.requestedTeams);
        }
        if (this.mergeCommitSha != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("mergeCommitSha=").append(this.mergeCommitSha);
        }
        if (this.nodeId != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("nodeId=").append(this.nodeId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestItem fromJson(Json json) {
        Builder builder = ImmutablePullRequestItem.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.closedAt != null) {
            builder.closedAt(json.closedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.base != null) {
            builder.base(json.base);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.diffUrl != null) {
            builder.diffUrl(json.diffUrl);
        }
        if (json.patchUrl != null) {
            builder.patchUrl(json.patchUrl);
        }
        if (json.issueUrl != null) {
            builder.issueUrl(json.issueUrl);
        }
        if (json.commitsUrl != null) {
            builder.commitsUrl(json.commitsUrl);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.assignee != null) {
            builder.assignee(json.assignee);
        }
        if (json.assignees != null) {
            builder.assignees(json.assignees);
        }
        if (json.milestone != null) {
            builder.milestone(json.milestone);
        }
        if (json.locked != null) {
            builder.locked(json.locked);
        }
        if (json.mergedAt != null) {
            builder.mergedAt(json.mergedAt);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.statusesUrl != null) {
            builder.statusesUrl(json.statusesUrl);
        }
        if (json.reviewCommentsUrl != null) {
            builder.reviewCommentsUrl(json.reviewCommentsUrl);
        }
        if (json.reviewCommentUrl != null) {
            builder.reviewCommentUrl(json.reviewCommentUrl);
        }
        if (json.commentsUrl != null) {
            builder.commentsUrl(json.commentsUrl);
        }
        if (json.links != null) {
            builder.links(json.links);
        }
        if (json.requestedReviewers != null) {
            builder.addAllRequestedReviewers(json.requestedReviewers);
        }
        if (json.requestedTeams != null) {
            builder.addAllRequestedTeams(json.requestedTeams);
        }
        if (json.mergeCommitSha != null) {
            builder.mergeCommitSha(json.mergeCommitSha);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        return builder.build();
    }

    public static ImmutablePullRequestItem copyOf(PullRequestItem instance) {
        if (instance instanceof ImmutablePullRequestItem) {
            return (ImmutablePullRequestItem)instance;
        }
        return ImmutablePullRequestItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PullRequestItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private GitHubInstant closedAt;
        @Nullable
        private Long id;
        @Nullable
        private URI url;
        @Nullable
        private Long number;
        @Nullable
        private PullRequestRef head;
        @Nullable
        private PullRequestRef base;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI diffUrl;
        @Nullable
        private URI patchUrl;
        @Nullable
        private URI issueUrl;
        @Nullable
        private URI commitsUrl;
        @Nullable
        private String state;
        @Nullable
        private String title;
        @Nullable
        private String body;
        @Nullable
        private User assignee;
        @Nullable
        private List<User> assignees;
        @Nullable
        private Milestone milestone;
        @Nullable
        private Boolean locked;
        @Nullable
        private GitHubInstant mergedAt;
        @Nullable
        private User user;
        @Nullable
        private URI statusesUrl;
        @Nullable
        private URI reviewCommentsUrl;
        @Nullable
        private String reviewCommentUrl;
        @Nullable
        private URI commentsUrl;
        @Nullable
        private PullRequestLinks links;
        private List<User> requestedReviewers = null;
        private List<User> requestedTeams = null;
        @Nullable
        private String mergeCommitSha;
        @Nullable
        private String nodeId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CloseTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PartialPullRequestItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GitHubInstant updatedAtValue;
            GitHubInstant createdAtValue;
            Optional<GitHubInstant> closedAtOptional;
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof PullRequestItem) {
                String nodeIdValue;
                User userValue;
                Optional<User> assigneeOptional;
                URI commentsUrlValue;
                Optional<Milestone> milestoneOptional;
                URI issueUrlValue;
                URI htmlUrlValue;
                Optional<GitHubInstant> mergedAtOptional;
                Boolean lockedValue;
                String stateValue;
                PullRequestLinks linksValue;
                URI statusesUrlValue;
                Optional<String> mergeCommitShaOptional;
                URI patchUrlValue;
                Optional<String> bodyOptional;
                String titleValue;
                URI commitsUrlValue;
                URI reviewCommentsUrlValue;
                Optional<List<User>> assigneesOptional;
                List<User> requestedTeamsValue;
                String reviewCommentUrlValue;
                URI diffUrlValue;
                instance = (PullRequestItem)object;
                List<User> requestedReviewersValue = instance.requestedReviewers();
                if (requestedReviewersValue != null) {
                    this.addAllRequestedReviewers(requestedReviewersValue);
                }
                if ((diffUrlValue = instance.diffUrl()) != null) {
                    this.diffUrl(diffUrlValue);
                }
                if ((reviewCommentUrlValue = instance.reviewCommentUrl()) != null) {
                    this.reviewCommentUrl(reviewCommentUrlValue);
                }
                if ((requestedTeamsValue = instance.requestedTeams()) != null) {
                    this.addAllRequestedTeams(requestedTeamsValue);
                }
                if ((assigneesOptional = instance.assignees()).isPresent()) {
                    this.assignees(assigneesOptional);
                }
                if ((reviewCommentsUrlValue = instance.reviewCommentsUrl()) != null) {
                    this.reviewCommentsUrl(reviewCommentsUrlValue);
                }
                if ((commitsUrlValue = instance.commitsUrl()) != null) {
                    this.commitsUrl(commitsUrlValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                if ((bodyOptional = instance.body()).isPresent()) {
                    this.body(bodyOptional);
                }
                if ((bits & 1L) == 0L) {
                    PullRequestRef headValue = instance.head();
                    if (headValue != null) {
                        this.head(headValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    GitHubInstant createdAtValue2 = instance.createdAt();
                    if (createdAtValue2 != null) {
                        this.createdAt(createdAtValue2);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Long numberValue = instance.number();
                    if (numberValue != null) {
                        this.number(numberValue);
                    }
                    bits |= 4L;
                }
                if ((patchUrlValue = instance.patchUrl()) != null) {
                    this.patchUrl(patchUrlValue);
                }
                if ((mergeCommitShaOptional = instance.mergeCommitSha()).isPresent()) {
                    this.mergeCommitSha(mergeCommitShaOptional);
                }
                if ((statusesUrlValue = instance.statusesUrl()) != null) {
                    this.statusesUrl(statusesUrlValue);
                }
                if ((linksValue = instance.links()) != null) {
                    this.links(linksValue);
                }
                if ((bits & 8L) == 0L) {
                    Long idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((stateValue = instance.state()) != null) {
                    this.state(stateValue);
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional2 = instance.closedAt();
                    if (closedAtOptional2.isPresent()) {
                        this.closedAt(closedAtOptional2);
                    }
                    bits |= 0x10L;
                }
                if ((lockedValue = instance.locked()) != null) {
                    this.locked(lockedValue);
                }
                if ((bits & 0x20L) == 0L) {
                    GitHubInstant updatedAtValue2 = instance.updatedAt();
                    if (updatedAtValue2 != null) {
                        this.updatedAt(updatedAtValue2);
                    }
                    bits |= 0x20L;
                }
                if ((mergedAtOptional = instance.mergedAt()).isPresent()) {
                    this.mergedAt(mergedAtOptional);
                }
                if ((htmlUrlValue = instance.htmlUrl()) != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((bits & 0x40L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x40L;
                }
                if ((issueUrlValue = instance.issueUrl()) != null) {
                    this.issueUrl(issueUrlValue);
                }
                if ((milestoneOptional = instance.milestone()).isPresent()) {
                    this.milestone(milestoneOptional);
                }
                if ((commentsUrlValue = instance.commentsUrl()) != null) {
                    this.commentsUrl(commentsUrlValue);
                }
                if ((assigneeOptional = instance.assignee()).isPresent()) {
                    this.assignee(assigneeOptional);
                }
                if ((userValue = instance.user()) != null) {
                    this.user(userValue);
                }
                if ((nodeIdValue = instance.nodeId()) != null) {
                    this.nodeId(nodeIdValue);
                }
                if ((bits & 0x80L) == 0L) {
                    PullRequestRef baseValue = instance.base();
                    if (baseValue != null) {
                        this.base(baseValue);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof CloseTracking) {
                instance = (CloseTracking)object;
                if ((bits & 0x10L) == 0L) {
                    closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x20L;
                }
            }
            if (object instanceof PartialPullRequestItem) {
                instance = (PartialPullRequestItem)object;
                if ((bits & 1L) == 0L) {
                    PullRequestRef headValue = instance.head();
                    if (headValue != null) {
                        this.head(headValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Long numberValue = instance.number();
                    if (numberValue != null) {
                        this.number(numberValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    Long idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x40L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x20L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x80L) == 0L) {
                    PullRequestRef baseValue = instance.base();
                    if (baseValue != null) {
                        this.base(baseValue);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 2L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x20L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedAt(GitHubInstant closedAt) {
            this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
            this.closedAt = closedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(@Nullable Long number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder head(@Nullable PullRequestRef head) {
            this.head = head;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder base(@Nullable PullRequestRef base) {
            this.base = base;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder diffUrl(@Nullable URI diffUrl) {
            this.diffUrl = diffUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder patchUrl(@Nullable URI patchUrl) {
            this.patchUrl = patchUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder issueUrl(@Nullable URI issueUrl) {
            this.issueUrl = issueUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitsUrl(@Nullable URI commitsUrl) {
            this.commitsUrl = commitsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assignee(User assignee) {
            this.assignee = Objects.requireNonNull(assignee, "assignee");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder assignee(Optional<? extends User> assignee) {
            this.assignee = assignee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assignees(List<User> assignees) {
            this.assignees = Objects.requireNonNull(assignees, "assignees");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder assignees(Optional<? extends List<User>> assignees) {
            this.assignees = assignees.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder milestone(Milestone milestone) {
            this.milestone = Objects.requireNonNull(milestone, "milestone");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder milestone(Optional<? extends Milestone> milestone) {
            this.milestone = milestone.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder locked(@Nullable Boolean locked) {
            this.locked = locked;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergedAt(GitHubInstant mergedAt) {
            this.mergedAt = Objects.requireNonNull(mergedAt, "mergedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergedAt(Optional<? extends GitHubInstant> mergedAt) {
            this.mergedAt = mergedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder statusesUrl(@Nullable URI statusesUrl) {
            this.statusesUrl = statusesUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
            this.reviewCommentsUrl = reviewCommentsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reviewCommentUrl(@Nullable String reviewCommentUrl) {
            this.reviewCommentUrl = reviewCommentUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
            return this;
        }

        @JsonProperty(value="_links")
        @CanIgnoreReturnValue
        public final Builder links(@Nullable PullRequestLinks links) {
            this.links = links;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedReviewers(User element) {
            if (this.requestedReviewers == null) {
                this.requestedReviewers = new ArrayList<User>();
            }
            this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedReviewers(User ... elements) {
            if (this.requestedReviewers == null) {
                this.requestedReviewers = new ArrayList<User>();
            }
            for (User element : elements) {
                this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
            }
            return this;
        }

        @JsonProperty(value="requested_reviewers")
        @CanIgnoreReturnValue
        public final Builder requestedReviewers(@Nullable Iterable<? extends User> elements) {
            if (elements == null) {
                this.requestedReviewers = null;
                return this;
            }
            this.requestedReviewers = new ArrayList<User>();
            return this.addAllRequestedReviewers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestedReviewers(Iterable<? extends User> elements) {
            Objects.requireNonNull(elements, "requestedReviewers element");
            if (this.requestedReviewers == null) {
                this.requestedReviewers = new ArrayList<User>();
            }
            for (User user : elements) {
                this.requestedReviewers.add(Objects.requireNonNull(user, "requestedReviewers element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedTeams(User element) {
            if (this.requestedTeams == null) {
                this.requestedTeams = new ArrayList<User>();
            }
            this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedTeams(User ... elements) {
            if (this.requestedTeams == null) {
                this.requestedTeams = new ArrayList<User>();
            }
            for (User element : elements) {
                this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
            }
            return this;
        }

        @JsonProperty(value="requested_teams")
        @CanIgnoreReturnValue
        public final Builder requestedTeams(@Nullable Iterable<? extends User> elements) {
            if (elements == null) {
                this.requestedTeams = null;
                return this;
            }
            this.requestedTeams = new ArrayList<User>();
            return this.addAllRequestedTeams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestedTeams(Iterable<? extends User> elements) {
            Objects.requireNonNull(elements, "requestedTeams element");
            if (this.requestedTeams == null) {
                this.requestedTeams = new ArrayList<User>();
            }
            for (User user : elements) {
                this.requestedTeams.add(Objects.requireNonNull(user, "requestedTeams element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeCommitSha(String mergeCommitSha) {
            this.mergeCommitSha = Objects.requireNonNull(mergeCommitSha, "mergeCommitSha");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeCommitSha(Optional<String> mergeCommitSha) {
            this.mergeCommitSha = mergeCommitSha.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public ImmutablePullRequestItem build() {
            return new ImmutablePullRequestItem(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.number, this.head, this.base, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers == null ? null : ImmutablePullRequestItem.createUnmodifiableList(true, this.requestedReviewers), this.requestedTeams == null ? null : ImmutablePullRequestItem.createUnmodifiableList(true, this.requestedTeams), this.mergeCommitSha, this.nodeId);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestItem", generator="Immutables")
    static final class Json
    implements PullRequestItem {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Optional<GitHubInstant> closedAt = Optional.empty();
        @Nullable
        Long id;
        @Nullable
        URI url;
        @Nullable
        Long number;
        @Nullable
        PullRequestRef head;
        @Nullable
        PullRequestRef base;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI diffUrl;
        @Nullable
        URI patchUrl;
        @Nullable
        URI issueUrl;
        @Nullable
        URI commitsUrl;
        @Nullable
        String state;
        @Nullable
        String title;
        @Nullable
        Optional<String> body = Optional.empty();
        @Nullable
        Optional<User> assignee = Optional.empty();
        @Nullable
        Optional<List<User>> assignees = Optional.empty();
        @Nullable
        Optional<Milestone> milestone = Optional.empty();
        @Nullable
        Boolean locked;
        @Nullable
        Optional<GitHubInstant> mergedAt = Optional.empty();
        @Nullable
        User user;
        @Nullable
        URI statusesUrl;
        @Nullable
        URI reviewCommentsUrl;
        @Nullable
        String reviewCommentUrl;
        @Nullable
        URI commentsUrl;
        @Nullable
        PullRequestLinks links;
        @Nullable
        List<User> requestedReviewers = null;
        @Nullable
        List<User> requestedTeams = null;
        @Nullable
        Optional<String> mergeCommitSha = Optional.empty();
        @Nullable
        String nodeId;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setClosedAt(Optional<GitHubInstant> closedAt) {
            this.closedAt = closedAt;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setNumber(@Nullable Long number) {
            this.number = number;
        }

        @JsonProperty
        public void setHead(@Nullable PullRequestRef head) {
            this.head = head;
        }

        @JsonProperty
        public void setBase(@Nullable PullRequestRef base) {
            this.base = base;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setDiffUrl(@Nullable URI diffUrl) {
            this.diffUrl = diffUrl;
        }

        @JsonProperty
        public void setPatchUrl(@Nullable URI patchUrl) {
            this.patchUrl = patchUrl;
        }

        @JsonProperty
        public void setIssueUrl(@Nullable URI issueUrl) {
            this.issueUrl = issueUrl;
        }

        @JsonProperty
        public void setCommitsUrl(@Nullable URI commitsUrl) {
            this.commitsUrl = commitsUrl;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setBody(Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setAssignee(Optional<User> assignee) {
            this.assignee = assignee;
        }

        @JsonProperty
        public void setAssignees(Optional<List<User>> assignees) {
            this.assignees = assignees;
        }

        @JsonProperty
        public void setMilestone(Optional<Milestone> milestone) {
            this.milestone = milestone;
        }

        @JsonProperty
        public void setLocked(@Nullable Boolean locked) {
            this.locked = locked;
        }

        @JsonProperty
        public void setMergedAt(Optional<GitHubInstant> mergedAt) {
            this.mergedAt = mergedAt;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setStatusesUrl(@Nullable URI statusesUrl) {
            this.statusesUrl = statusesUrl;
        }

        @JsonProperty
        public void setReviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
            this.reviewCommentsUrl = reviewCommentsUrl;
        }

        @JsonProperty
        public void setReviewCommentUrl(@Nullable String reviewCommentUrl) {
            this.reviewCommentUrl = reviewCommentUrl;
        }

        @JsonProperty
        public void setCommentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
        }

        @JsonProperty(value="_links")
        public void setLinks(@Nullable PullRequestLinks links) {
            this.links = links;
        }

        @JsonProperty(value="requested_reviewers")
        public void setRequestedReviewers(@Nullable List<User> requestedReviewers) {
            this.requestedReviewers = requestedReviewers;
        }

        @JsonProperty(value="requested_teams")
        public void setRequestedTeams(@Nullable List<User> requestedTeams) {
            this.requestedTeams = requestedTeams;
        }

        @JsonProperty
        public void setMergeCommitSha(Optional<String> mergeCommitSha) {
            this.mergeCommitSha = mergeCommitSha;
        }

        @JsonProperty
        public void setNodeId(@Nullable String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> closedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestRef head() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestRef base() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI diffUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI patchUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI issueUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commitsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> assignee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<User>> assignees() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Milestone> milestone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean locked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> mergedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI statusesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI reviewCommentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String reviewCommentUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestLinks links() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<User> requestedReviewers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<User> requestedTeams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> mergeCommitSha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }
    }
}

