/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.prs.ReviewComment;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReviewComment", generator="Immutables")
@Immutable
public final class ImmutableReviewComment
extends ReviewComment {
    private final String path;
    private final int position;
    private final String body;

    private ImmutableReviewComment(String path, int position, String body) {
        this.path = path;
        this.position = position;
        this.body = body;
    }

    @Override
    @JsonProperty
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty
    public int position() {
        return this.position;
    }

    @Override
    @JsonProperty
    public String body() {
        return this.body;
    }

    public final ImmutableReviewComment withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableReviewComment(newValue, this.position, this.body);
    }

    public final ImmutableReviewComment withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableReviewComment(this.path, value, this.body);
    }

    public final ImmutableReviewComment withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (this.body.equals(newValue)) {
            return this;
        }
        return new ImmutableReviewComment(this.path, this.position, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReviewComment && this.equalTo(0, (ImmutableReviewComment)another);
    }

    private boolean equalTo(int synthetic, ImmutableReviewComment another) {
        return this.path.equals(another.path) && this.position == another.position && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.position;
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return "ReviewComment{path=" + this.path + ", position=" + this.position + ", body=" + this.body + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReviewComment fromJson(Json json) {
        Builder builder = ImmutableReviewComment.builder();
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.positionIsSet) {
            builder.position(json.position);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        return builder.build();
    }

    public static ImmutableReviewComment copyOf(ReviewComment instance) {
        if (instance instanceof ImmutableReviewComment) {
            return (ImmutableReviewComment)instance;
        }
        return ImmutableReviewComment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReviewComment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_POSITION = 2L;
        private static final long INIT_BIT_BODY = 4L;
        private long initBits = 7L;
        @Nullable
        private String path;
        private int position;
        @Nullable
        private String body;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReviewComment instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            this.position(instance.position());
            this.body(instance.body());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReviewComment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReviewComment(this.path, this.position, this.body);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("position");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build ReviewComment, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReviewComment", generator="Immutables")
    static final class Json
    extends ReviewComment {
        @Nullable
        String path;
        int position;
        boolean positionIsSet;
        @Nullable
        String body;

        Json() {
        }

        @JsonProperty
        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty
        public void setPosition(int position) {
            this.position = position;
            this.positionIsSet = true;
        }

        @JsonProperty
        public void setBody(String body) {
            this.body = body;
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int position() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String body() {
            throw new UnsupportedOperationException();
        }
    }
}

