/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.workflows;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.workflows.WorkflowsRepositoryResponseList;
import com.spotify.github.v3.workflows.WorkflowsResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WorkflowsRepositoryResponseList", generator="Immutables")
@Immutable
public final class ImmutableWorkflowsRepositoryResponseList
implements WorkflowsRepositoryResponseList {
    private final int totalCount;
    private final List<WorkflowsResponse> workflows;

    private ImmutableWorkflowsRepositoryResponseList(int totalCount, List<WorkflowsResponse> workflows) {
        this.totalCount = totalCount;
        this.workflows = workflows;
    }

    @Override
    @JsonProperty
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    public List<WorkflowsResponse> workflows() {
        return this.workflows;
    }

    public final ImmutableWorkflowsRepositoryResponseList withTotalCount(int value) {
        if (this.totalCount == value) {
            return this;
        }
        return new ImmutableWorkflowsRepositoryResponseList(value, this.workflows);
    }

    public final ImmutableWorkflowsRepositoryResponseList withWorkflows(WorkflowsResponse ... elements) {
        List<WorkflowsResponse> newValue = ImmutableWorkflowsRepositoryResponseList.createUnmodifiableList(false, ImmutableWorkflowsRepositoryResponseList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWorkflowsRepositoryResponseList(this.totalCount, newValue);
    }

    public final ImmutableWorkflowsRepositoryResponseList withWorkflows(Iterable<? extends WorkflowsResponse> elements) {
        if (this.workflows == elements) {
            return this;
        }
        List<WorkflowsResponse> newValue = ImmutableWorkflowsRepositoryResponseList.createUnmodifiableList(false, ImmutableWorkflowsRepositoryResponseList.createSafeList(elements, true, false));
        return new ImmutableWorkflowsRepositoryResponseList(this.totalCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowsRepositoryResponseList && this.equalTo(0, (ImmutableWorkflowsRepositoryResponseList)another);
    }

    private boolean equalTo(int synthetic, ImmutableWorkflowsRepositoryResponseList another) {
        return this.totalCount == another.totalCount && this.workflows.equals(another.workflows);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.totalCount;
        h += (h << 5) + this.workflows.hashCode();
        return h;
    }

    public String toString() {
        return "WorkflowsRepositoryResponseList{totalCount=" + this.totalCount + ", workflows=" + String.valueOf(this.workflows) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowsRepositoryResponseList fromJson(Json json) {
        Builder builder = ImmutableWorkflowsRepositoryResponseList.builder();
        if (json.totalCountIsSet) {
            builder.totalCount(json.totalCount);
        }
        if (json.workflows != null) {
            builder.addAllWorkflows(json.workflows);
        }
        return builder.build();
    }

    public static ImmutableWorkflowsRepositoryResponseList copyOf(WorkflowsRepositoryResponseList instance) {
        if (instance instanceof ImmutableWorkflowsRepositoryResponseList) {
            return (ImmutableWorkflowsRepositoryResponseList)instance;
        }
        return ImmutableWorkflowsRepositoryResponseList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WorkflowsRepositoryResponseList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_COUNT = 1L;
        private long initBits = 1L;
        private int totalCount;
        private List<WorkflowsResponse> workflows = new ArrayList<WorkflowsResponse>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowsRepositoryResponseList instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalCount(instance.totalCount());
            this.addAllWorkflows(instance.workflows());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(int totalCount) {
            this.totalCount = totalCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWorkflows(WorkflowsResponse element) {
            this.workflows.add(Objects.requireNonNull(element, "workflows element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWorkflows(WorkflowsResponse ... elements) {
            for (WorkflowsResponse element : elements) {
                this.workflows.add(Objects.requireNonNull(element, "workflows element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder workflows(Iterable<? extends WorkflowsResponse> elements) {
            this.workflows.clear();
            return this.addAllWorkflows(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllWorkflows(Iterable<? extends WorkflowsResponse> elements) {
            for (WorkflowsResponse workflowsResponse : elements) {
                this.workflows.add(Objects.requireNonNull(workflowsResponse, "workflows element"));
            }
            return this;
        }

        public ImmutableWorkflowsRepositoryResponseList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowsRepositoryResponseList(this.totalCount, ImmutableWorkflowsRepositoryResponseList.createUnmodifiableList(true, this.workflows));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalCount");
            }
            return "Cannot build WorkflowsRepositoryResponseList, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkflowsRepositoryResponseList", generator="Immutables")
    static final class Json
    implements WorkflowsRepositoryResponseList {
        int totalCount;
        boolean totalCountIsSet;
        @Nullable
        List<WorkflowsResponse> workflows = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
            this.totalCountIsSet = true;
        }

        @JsonProperty
        public void setWorkflows(List<WorkflowsResponse> workflows) {
            this.workflows = workflows;
        }

        @Override
        public int totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WorkflowsResponse> workflows() {
            throw new UnsupportedOperationException();
        }
    }
}

