/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.async;

import com.spotify.github.async.AsyncPage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Async {
    private Async() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> Stream<T> streamFromPaginatingIterable(Iterable<AsyncPage<T>> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).flatMap(page -> StreamSupport.stream(page.spliterator(), false));
    }

    public static <T> CompletableFuture<T> exceptionallyCompose(CompletableFuture<T> future, Function<Throwable, CompletableFuture<T>> handler) {
        return ((CompletableFuture)future.handle((result, throwable) -> {
            if (throwable != null) {
                return (CompletableFuture)handler.apply((Throwable)throwable);
            }
            return CompletableFuture.completedFuture(result);
        })).thenCompose(Function.identity());
    }
}

