/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.spotify.github.GithubStyle;
import com.spotify.github.http.ImmutableHttpRequest;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableHttpRequest.class)
@JsonDeserialize(as=ImmutableHttpRequest.class)
@Value.Immutable
@GithubStyle
public interface HttpRequest {
    @Value.Default
    default public String method() {
        return "GET";
    }

    public String url();

    @Nullable
    public String body();

    @Value.Default
    default public Map<String, List<String>> headers() {
        return Map.of();
    }

    default public List<String> headers(String headerName) {
        return this.headers().get(headerName);
    }

    default public String header(String headerName) {
        List<String> headerValues = this.headers(headerName);
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        if (headerValues.size() == 1) {
            return headerValues.get(0);
        }
        return String.join((CharSequence)",", headerValues);
    }
}

